package org.hsqldb;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class HsqlDateTime
{
  private static Calendar today = new GregorianCalendar();
  private static Calendar tempCal = new GregorianCalendar();
  private static Calendar tempCalDefault = new GregorianCalendar();
  private static Calendar tempCalGMT = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
  private static java.sql.Date tempDate = new java.sql.Date(0L);
  private static java.sql.Date currentDate;
  static final String zerodatetime = "1970-01-01 00:00:00.000000000";
  static final String zeronanos = "000000000";
  private static final String sdftPattern = "HH:mm:ss";
  private static final String sdfdPattern = "yyyy-MM-dd";
  private static final String sdftsPattern = "yyyy-MM-dd HH:mm:ss.";
  private static final String sdftsSysPattern = "yyyy-MM-dd HH:mm:ss.SSS";
  static SimpleDateFormat sdfd;
  static SimpleDateFormat sdft;
  static SimpleDateFormat sdfts;
  static SimpleDateFormat sdftsSys;
  private static java.util.Date sysDate;
  private static final char[][] dateTokens;
  private static final String[] javaDateTokens;
  public static final char e = '￿';

  public static Timestamp timestampValue(String paramString)
    throws HsqlException
  {
    if (paramString == null)
      throw Trace.error(131);
    if (paramString.length() > "1970-01-01 00:00:00.000000000".length())
      throw Trace.error(124);
    paramString = paramString + "1970-01-01 00:00:00.000000000".substring(paramString.length());
    return Timestamp.valueOf(paramString);
  }

  public static Timestamp simpleTimestampValue(String paramString)
  {
    return Timestamp.valueOf(paramString);
  }

  public static Timestamp timestampValue(long paramLong, int paramInt)
  {
    Timestamp localTimestamp = new Timestamp(paramLong);
    localTimestamp.setNanos(paramInt);
    return localTimestamp;
  }

  public static java.sql.Date dateValue(String paramString)
    throws HsqlException
  {
    if (paramString == null)
      throw Trace.error(131);
    if (paramString.length() > "yyyy-MM-dd".length())
      paramString = paramString.substring(0, "yyyy-MM-dd".length());
    return java.sql.Date.valueOf(paramString);
  }

  public static Time timeValue(String paramString)
  {
    if (paramString == null)
      throw new IllegalArgumentException(Trace.getMessage(131));
    return Time.valueOf(paramString);
  }

  static int compare(java.sql.Date paramDate1, java.sql.Date paramDate2)
  {
    long l1 = paramDate1.getTime();
    long l2 = paramDate2.getTime();
    if (l1 == l2)
      return 0;
    return l1 > l2 ? 1 : -1;
  }

  static int compare(Time paramTime1, Time paramTime2)
  {
    long l1 = paramTime1.getTime();
    long l2 = paramTime2.getTime();
    if (l1 == l2)
      return 0;
    return l1 > l2 ? 1 : -1;
  }

  static int compare(Timestamp paramTimestamp1, Timestamp paramTimestamp2)
  {
    long l1 = paramTimestamp1.getTime();
    long l2 = paramTimestamp2.getTime();
    if (l1 == l2)
    {
      if (paramTimestamp1.getNanos() == paramTimestamp2.getNanos())
        return 0;
      return paramTimestamp1.getNanos() > paramTimestamp2.getNanos() ? 1 : -1;
    }
    return l1 > l2 ? 1 : -1;
  }

  public static synchronized java.sql.Date getCurrentDate(long paramLong)
  {
    getToday(paramLong);
    return currentDate;
  }

  public static Timestamp getTimestamp(long paramLong)
  {
    return new Timestamp(paramLong);
  }

  public static String getTimestampString(Timestamp paramTimestamp)
  {
    synchronized (sdfts)
    {
      sdfts.setCalendar(tempCalDefault);
      String str = String.valueOf(paramTimestamp.getNanos());
      return sdfts.format(paramTimestamp) + "000000000".substring(str.length()) + str;
    }
  }

  public static String getTimestampString(Timestamp paramTimestamp, Calendar paramCalendar)
  {
    synchronized (sdfts)
    {
      sdfts.setCalendar(paramCalendar == null ? tempCalDefault : paramCalendar);
      String str = String.valueOf(paramTimestamp.getNanos());
      return sdfts.format(paramTimestamp) + "000000000".substring(str.length()) + str;
    }
  }

  public static String getSytemTimeString()
  {
    synchronized (sdftsSys)
    {
      sysDate.setTime(System.currentTimeMillis());
      return sdftsSys.format(sysDate);
    }
  }

  public static String getTimestampString(long paramLong)
  {
    synchronized (sdftsSys)
    {
      sysDate.setTime(paramLong);
      return sdftsSys.format(sysDate);
    }
  }

  public static String getTimeString(java.util.Date paramDate, Calendar paramCalendar)
  {
    synchronized (sdft)
    {
      sdft.setCalendar(paramCalendar == null ? tempCalDefault : paramCalendar);
      return sdft.format(paramDate);
    }
  }

  public static String getDateString(java.util.Date paramDate, Calendar paramCalendar)
  {
    synchronized (sdfd)
    {
      sdfd.setCalendar(paramCalendar == null ? tempCalDefault : paramCalendar);
      return sdfd.format(paramDate);
    }
  }

  static synchronized Calendar getToday(long paramLong)
  {
    if (paramLong - getTimeInMillis(today) >= 86400000L)
      resetToday(paramLong);
    return today;
  }

  public static void resetToDate(Calendar paramCalendar)
  {
    paramCalendar.set(11, 0);
    paramCalendar.set(12, 0);
    paramCalendar.set(13, 0);
    paramCalendar.set(14, 0);
  }

  public static void resetToTime(Calendar paramCalendar)
  {
    paramCalendar.set(1, 1970);
    paramCalendar.set(2, 0);
    paramCalendar.set(5, 1);
    paramCalendar.set(14, 0);
  }

  private static synchronized void resetToday(long paramLong)
  {
    today.setTimeInMillis(paramLong);
    resetToDate(today);
    currentDate = new java.sql.Date(getTimeInMillis(today));
  }

  private static void setTimeInMillis(Calendar paramCalendar, long paramLong)
  {
    paramCalendar.setTimeInMillis(paramLong);
  }

  public static long getTimeInMillis(java.util.Date paramDate, Calendar paramCalendar1, Calendar paramCalendar2)
  {
    if (paramCalendar1 == null)
      paramCalendar1 = tempCalDefault;
    if (paramCalendar2 == null)
      paramCalendar2 = tempCalDefault;
    synchronized (tempCal)
    {
      tempCal.setTimeZone(paramCalendar1.getTimeZone());
      tempCal.setTime(paramDate);
      tempCal.setTimeZone(paramCalendar2.getTimeZone());
      return getTimeInMillis(tempCal);
    }
  }

  public static long getTimeInMillis(Calendar paramCalendar)
  {
    return paramCalendar.getTimeInMillis();
  }

  public static long getNormalisedTime(long paramLong)
  {
    synchronized (tempCalDefault)
    {
      setTimeInMillis(tempCalDefault, paramLong);
      resetToTime(tempCalDefault);
      return getTimeInMillis(tempCalDefault);
    }
  }

  public static Time getNormalisedTime(Time paramTime)
  {
    return new Time(getNormalisedTime(paramTime.getTime()));
  }

  public static Time getNormalisedTime(Timestamp paramTimestamp)
  {
    return new Time(getNormalisedTime(paramTimestamp.getTime()));
  }

  public static long getNormalisedDate(long paramLong)
  {
    synchronized (tempCalDefault)
    {
      setTimeInMillis(tempCalDefault, paramLong);
      resetToDate(tempCalDefault);
      return getTimeInMillis(tempCalDefault);
    }
  }

  public static java.sql.Date getNormalisedDate(Timestamp paramTimestamp)
  {
    synchronized (tempCalDefault)
    {
      setTimeInMillis(tempCalDefault, paramTimestamp.getTime());
      resetToDate(tempCalDefault);
      long l = getTimeInMillis(tempCalDefault);
      return new java.sql.Date(l);
    }
  }

  public static java.sql.Date getNormalisedDate(java.sql.Date paramDate)
  {
    synchronized (tempCalDefault)
    {
      setTimeInMillis(tempCalDefault, paramDate.getTime());
      resetToDate(tempCalDefault);
      long l = getTimeInMillis(tempCalDefault);
      return new java.sql.Date(l);
    }
  }

  public static Timestamp getNormalisedTimestamp(Time paramTime)
  {
    synchronized (tempCalDefault)
    {
      setTimeInMillis(tempCalDefault, System.currentTimeMillis());
      resetToDate(tempCalDefault);
      long l = getTimeInMillis(tempCalDefault) + paramTime.getTime();
      return new Timestamp(l);
    }
  }

  public static Timestamp getNormalisedTimestamp(java.sql.Date paramDate)
  {
    synchronized (tempCalDefault)
    {
      setTimeInMillis(tempCalDefault, paramDate.getTime());
      resetToDate(tempCalDefault);
      long l = getTimeInMillis(tempCalDefault);
      return new Timestamp(l);
    }
  }

  static int getDateTimePart(java.util.Date paramDate, int paramInt)
  {
    synchronized (tempCalDefault)
    {
      tempCalDefault.setTime(paramDate);
      return tempCalDefault.get(paramInt);
    }
  }

  public static String toJavaDatePattern(String paramString)
  {
    int i = paramString.length();
    StringBuffer localStringBuffer = new StringBuffer(i);
    Tokenizer localTokenizer = new Tokenizer();
    for (int j = 0; j <= i; j++)
    {
      char c = j == i ? 65535 : paramString.charAt(j);
      if (!localTokenizer.next(c, dateTokens))
      {
        int k = localTokenizer.getLastMatch();
        if (k >= 0)
        {
          localStringBuffer.setLength(localStringBuffer.length() - localTokenizer.length());
          localStringBuffer.append(javaDateTokens[k]);
        }
        localTokenizer.reset();
        if (localTokenizer.isConsumed())
          continue;
      }
      localStringBuffer.append(c);
    }
    localStringBuffer.setLength(localStringBuffer.length() - 1);
    return localStringBuffer.toString();
  }

  static
  {
    resetToday(System.currentTimeMillis());
    sdfd = new SimpleDateFormat("yyyy-MM-dd");
    sdft = new SimpleDateFormat("HH:mm:ss");
    sdfts = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.");
    sdftsSys = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    sysDate = new java.util.Date();
    dateTokens = new char[][] { { 'R', 'R', 'R', 'R' }, { 'I', 'Y', 'Y', 'Y' }, { 'Y', 'Y', 'Y', 'Y' }, { 'I', 'Y' }, { 'Y', 'Y' }, { 'B', 'C' }, { 'B', '.', 'C', '.' }, { 'A', 'D' }, { 'A', '.', 'D', '.' }, { 'M', 'O', 'N' }, { 'M', 'O', 'N', 'T', 'H' }, { 'D' }, { 'I', 'W' }, { 'D', 'D' }, { 'D', 'D', 'D' }, { 'H', 'H', '2', '4' }, { 'H', 'H', '1', '2' }, { 'H', 'H' }, { 'M', 'I' }, { 'S', 'S' }, { 'A', 'M' }, { 'P', 'M' }, { 'A', '.', 'M', '.' }, { 'P', '.', 'M', '.' } };
    javaDateTokens = new String[] { "yyyy", "yyyy", "yyyy", "yy", "yy", "G", "G", "G", "G", "MMM", "MMMMM", "E", "w", "dd", "D", "k", "K", "K", "mm", "ss", "aaa", "aaa", "aaa", "aaa" };
  }

  static class Tokenizer
  {
    private int last;
    private int offset;
    private long state;
    private boolean consumed;

    public Tokenizer()
    {
      reset();
    }

    public void reset()
    {
      this.last = -1;
      this.offset = -1;
      this.state = 0L;
    }

    public int length()
    {
      return this.offset;
    }

    public int getLastMatch()
    {
      return this.last;
    }

    public boolean isConsumed()
    {
      return this.consumed;
    }

    private boolean isZeroBit(int paramInt)
    {
      return (this.state & 1L << paramInt) == 0L;
    }

    private void setBit(int paramInt)
    {
      this.state |= 1L << paramInt;
    }

    public boolean next(char paramChar, char[][] paramArrayOfChar)
    {
      int i = ++this.offset;
      int j = this.offset + 1;
      int k = 0;
      this.consumed = false;
      int m = paramArrayOfChar.length;
      while (true)
      {
        m--;
        if (m < 0)
          break;
        if (!isZeroBit(m))
          continue;
        if (paramArrayOfChar[m][i] == paramChar)
        {
          this.consumed = true;
          if (paramArrayOfChar[m].length == j)
          {
            setBit(m);
            this.last = m;
            continue;
          }
          k++;
          continue;
        }
        setBit(m);
      }
      return k > 0;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.HsqlDateTime
 * JD-Core Version:    0.6.0
 */