package org.hsqldb;

public class NumberSequence
{
  HsqlNameManager.HsqlName name;
  private long startValue;
  private long currValue;
  private long lastValue;
  private long increment;
  private int dataType;

  public NumberSequence(HsqlNameManager.HsqlName paramHsqlName, long paramLong1, long paramLong2, int paramInt)
  {
    this.name = paramHsqlName;
    this.startValue = (this.currValue = this.lastValue = paramLong1);
    this.increment = paramLong2;
    this.dataType = paramInt;
  }

  synchronized long getValue()
  {
    long l = this.currValue;
    this.currValue += this.increment;
    return l;
  }

  synchronized long getValue(long paramLong)
  {
    if (paramLong >= this.currValue)
    {
      this.currValue = paramLong;
      this.currValue += this.increment;
      return paramLong;
    }
    return paramLong;
  }

  Object getValueObject()
  {
    long l = this.currValue;
    this.currValue += this.increment;
    Object localObject;
    if (this.dataType == 4)
      localObject = new Integer((int)l);
    else
      localObject = new Long(l);
    return localObject;
  }

  void reset()
  {
    this.lastValue = (this.currValue = this.startValue);
  }

  public long peek()
  {
    return this.currValue;
  }

  boolean wasUsed()
  {
    return this.lastValue != this.currValue;
  }

  void resetWasUsed()
  {
    this.lastValue = this.currValue;
  }

  public void reset(long paramLong)
  {
    this.startValue = (this.currValue = this.lastValue = paramLong);
  }

  void reset(long paramLong1, long paramLong2)
  {
    reset(paramLong1);
    this.increment = paramLong2;
  }

  int getType()
  {
    return this.dataType;
  }

  public HsqlNameManager.HsqlName getName()
  {
    return this.name;
  }

  public String getSchemaName()
  {
    return this.name.schema.name;
  }

  long getIncrement()
  {
    return this.increment;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.NumberSequence
 * JD-Core Version:    0.6.0
 */