package org.hsqldb;

import java.util.Locale;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.store.ValuePool;

class Parser
{
  private Database database;
  private Tokenizer tokenizer;
  private Session session;
  private String sSchema;
  private String sTable;
  private String sToken;
  private boolean wasQuoted;
  private Object oData;
  private int iType;
  private int iToken;
  private boolean compilingView;
  private int subQueryLevel;
  private HsqlArrayList subQueryList = new HsqlArrayList();
  static HashMap simpleFunctions = new HashMap();
  private static IntValueHashMap tokenSet;
  HsqlArrayList parameters = new HsqlArrayList();
  private static final Expression[] noParameters;
  private static final SubQuery[] noSubqueries;

  Parser(Session paramSession, Database paramDatabase, Tokenizer paramTokenizer)
  {
    this.database = paramDatabase;
    this.tokenizer = paramTokenizer;
    this.session = paramSession;
  }

  void setCompilingView()
  {
    this.compilingView = true;
  }

  boolean isCompilingView()
  {
    return this.compilingView;
  }

  void reset(String paramString)
  {
    this.sTable = null;
    this.sToken = null;
    this.oData = null;
    this.tokenizer.reset(paramString);
    this.subQueryList.clear();
    this.subQueryLevel = 0;
    this.parameters.clear();
  }

  void checkTableWriteAccess(Table paramTable, int paramInt)
    throws HsqlException
  {
    this.session.checkReadWrite();
    this.session.check(paramTable.getName(), paramInt);
    if (paramTable.isView())
      throw Trace.error(55, paramTable.getName().name);
    paramTable.checkDataReadOnly();
  }

  static HsqlArrayList getColumnNames(Database paramDatabase, Table paramTable, Tokenizer paramTokenizer, boolean paramBoolean)
    throws HsqlException
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    while (true)
    {
      if (paramBoolean)
      {
        str = paramTokenizer.getSimpleName();
        boolean bool = paramTokenizer.wasQuotedIdentifier();
        HsqlNameManager.HsqlName localHsqlName = paramDatabase.nameManager.newHsqlName(str, bool);
        localHsqlArrayList.add(localHsqlName);
      }
      else
      {
        localHsqlArrayList.add(paramTokenizer.getName());
        if ((paramTokenizer.wasLongName()) && (!paramTokenizer.getLongNameFirst().equals(paramTable.getName().name)))
          throw Trace.error(22, paramTokenizer.getLongNameFirst());
      }
      String str = paramTokenizer.getSimpleToken();
      if (str.equals(","))
        continue;
      if (str.equals(")"))
        break;
      paramTokenizer.throwUnexpected();
    }
    return localHsqlArrayList;
  }

  SubQuery parseSubquery(int paramInt1, HsqlNameManager.HsqlName[] paramArrayOfHsqlName, boolean paramBoolean, int paramInt2)
    throws HsqlException
  {
    SubQuery localSubQuery = new SubQuery();
    this.subQueryLevel += 1;
    boolean bool1 = paramInt2 == 115;
    boolean bool2 = (paramInt2 == 103) || (paramInt2 == 115) || (paramInt2 == 3);
    boolean bool3 = (paramInt2 == 30) || (paramInt2 == 32) || (paramInt2 == 33);
    Select localSelect = parseSelect(paramInt1, bool1, bool2, bool3, true);
    localSubQuery.level = this.subQueryLevel;
    this.subQueryLevel -= 1;
    boolean bool4 = localSelect.resolveAll(this.session, paramBoolean);
    localSubQuery.select = localSelect;
    localSubQuery.isResolved = bool4;
    HsqlNameManager.HsqlName localHsqlName = this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false);
    localHsqlName.schema = SchemaManager.SYSTEM_SCHEMA_HSQLNAME;
    Table localTable = new Table(this.database, localHsqlName, 1);
    if (paramArrayOfHsqlName != null)
    {
      if (paramArrayOfHsqlName.length != localSelect.iResultLen)
        throw Trace.error(5);
      for (i = 0; i < localSelect.iResultLen; i++)
      {
        localObject = paramArrayOfHsqlName[i];
        localSelect.exprColumns[i].setAlias(((HsqlNameManager.HsqlName)localObject).name, ((HsqlNameManager.HsqlName)localObject).isNameQuoted);
      }
    }
    for (int i = 0; i < localSelect.iResultLen; i++)
    {
      localObject = localSelect.exprColumns[i].getAlias();
      if ((localObject != null) && (((String)localObject).length() != 0))
        continue;
      localObject = "COL_" + String.valueOf(i + 1);
      localSelect.exprColumns[i].setAlias((String)localObject, false);
    }
    localTable.addColumns(localSelect);
    i = (paramInt2 == 31) || (paramInt2 == 30) || (paramInt2 == 32) || (paramInt2 == 33) ? 1 : 0;
    Object localObject = null;
    if (i != 0)
    {
      localObject = new int[localSelect.iResultLen];
      ArrayUtil.fillSequence(localObject);
    }
    localTable.createPrimaryKey(localObject);
    localSubQuery.table = localTable;
    localSubQuery.uniqueRows = i;
    this.subQueryList.add(localSubQuery);
    return (SubQuery)localSubQuery;
  }

  SubQuery getViewSubquery(View paramView)
  {
    SubQuery localSubQuery = paramView.viewSubQuery;
    for (int i = 0; i < paramView.viewSubqueries.length; i++)
      this.subQueryList.add(paramView.viewSubqueries[i]);
    return localSubQuery;
  }

  Select parseSelect(int paramInt, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3, boolean paramBoolean4)
    throws HsqlException
  {
    Select localSelect = new Select();
    String str = this.tokenizer.getString();
    if (((paramBoolean2) || (paramBoolean3)) && ((this.tokenizer.wasThis("LIMIT")) || (this.tokenizer.wasThis("TOP"))))
    {
      parseLimit(str, localSelect, false);
      str = this.tokenizer.getString();
    }
    if (this.tokenizer.wasThis("DISTINCT"))
      localSelect.isDistinctSelect = true;
    else if (!this.tokenizer.wasThis("ALL"))
      this.tokenizer.back();
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    int i;
    do
    {
      i = this.tokenizer.getPosition();
      localObject1 = parseExpression();
      if ((isCompilingView()) && (((Expression)localObject1).getType() == 6))
      {
        if (localSelect.asteriskPositions == null)
          localSelect.asteriskPositions = new IntKeyHashMap();
        localSelect.asteriskPositions.put(i, localObject1);
      }
      str = this.tokenizer.getString();
      if (this.tokenizer.wasThis("AS"))
      {
        ((Expression)localObject1).setAlias(this.tokenizer.getSimpleName(), this.tokenizer.wasQuotedIdentifier());
        str = this.tokenizer.getString();
      }
      else if (this.tokenizer.wasSimpleName())
      {
        ((Expression)localObject1).setAlias(str, this.tokenizer.wasQuotedIdentifier());
        str = this.tokenizer.getString();
      }
      localHsqlArrayList.add(localObject1);
    }
    while (this.tokenizer.wasThis(","));
    if (str.equals("INTO"))
    {
      i = 1;
      str = this.tokenizer.getString();
      localSelect.intoType = this.database.getDefaultTableType();
      if (this.tokenizer.wasSimpleToken())
      {
        switch (Token.get(str))
        {
        case 302:
          localSelect.intoType = 4;
          break;
        case 327:
          localSelect.intoType = 2;
          break;
        case 328:
          localSelect.intoType = 6;
          break;
        case 310:
          localSelect.intoType = 3;
          break;
        default:
          i = 0;
        }
        if (i != 0)
          str = this.tokenizer.getName();
      }
      if (!this.tokenizer.wasName())
        this.tokenizer.throwUnexpected();
      localSelect.sIntoTable = this.database.nameManager.newHsqlName(str, this.tokenizer.wasQuotedIdentifier());
      localSelect.sIntoTable.schema = this.session.getSchemaHsqlName(this.tokenizer.getLongNameFirst());
      str = this.tokenizer.getString();
    }
    this.tokenizer.matchThis("FROM");
    Expression localExpression1 = null;
    Object localObject1 = new HsqlArrayList();
    ((HsqlArrayList)localObject1).add(parseTableFilter(false));
    Object localObject2;
    while (true)
    {
      str = this.tokenizer.getString();
      int j = 0;
      if (this.tokenizer.wasThis("INNER"))
      {
        this.tokenizer.getThis("JOIN");
        str = "JOIN";
      }
      else if (this.tokenizer.wasThis("CROSS"))
      {
        this.tokenizer.getThis("JOIN");
        str = "JOIN";
        j = 1;
      }
      Object localObject3;
      if ((str.equals("LEFT")) && (!this.tokenizer.wasQuotedIdentifier()))
      {
        this.tokenizer.isGetThis("OUTER");
        this.tokenizer.getThis("JOIN");
        localObject2 = parseTableFilter(true);
        ((HsqlArrayList)localObject1).add(localObject2);
        this.tokenizer.getThis("ON");
        localObject3 = parseExpression();
        ((Expression)localObject3).checkTables((HsqlArrayList)localObject1);
        localExpression1 = addJoinCondition(localExpression1, (Expression)localObject3, (TableFilter)localObject2, true);
        continue;
      }
      if ((str.equals("RIGHT")) && (!this.tokenizer.wasQuotedIdentifier()))
      {
        this.tokenizer.isGetThis("OUTER");
        this.tokenizer.getThis("JOIN");
        localObject2 = parseTableFilter(false);
        localObject3 = new HsqlArrayList();
        ((HsqlArrayList)localObject3).add(localObject2);
        ((HsqlArrayList)localObject3).addAll((Collection)localObject1);
        localObject1 = localObject3;
        ((TableFilter)((HsqlArrayList)localObject1).get(1)).isOuterJoin = true;
        this.tokenizer.getThis("ON");
        Expression localExpression3 = parseExpression();
        localExpression3.checkTables((HsqlArrayList)localObject1);
        localExpression1 = addJoinCondition(localExpression1, localExpression3, (TableFilter)((HsqlArrayList)localObject1).get(1), true);
        continue;
      }
      if (this.tokenizer.wasThis("JOIN"))
      {
        ((HsqlArrayList)localObject1).add(parseTableFilter(false));
        if (j != 0)
          continue;
        this.tokenizer.getThis("ON");
        localObject2 = parseExpression();
        ((Expression)localObject2).checkTables((HsqlArrayList)localObject1);
        localExpression1 = addJoinCondition(localExpression1, (Expression)localObject2, null, false);
        continue;
      }
      if (!this.tokenizer.wasThis(","))
        break;
      ((HsqlArrayList)localObject1).add(parseTableFilter(false));
    }
    this.tokenizer.back();
    resolveSelectTableFilter(localSelect, localHsqlArrayList, (HsqlArrayList)localObject1);
    str = this.tokenizer.getString();
    if (this.tokenizer.wasThis("WHERE"))
    {
      Expression localExpression2 = parseExpression();
      localExpression1 = addCondition(localExpression1, localExpression2);
      str = this.tokenizer.getString();
    }
    localSelect.queryCondition = localExpression1;
    if (this.tokenizer.wasThis("GROUP"))
    {
      this.tokenizer.getThis("BY");
      k = 0;
      do
      {
        localObject2 = parseExpression();
        localHsqlArrayList.add(localObject2);
        str = this.tokenizer.getString();
        k++;
      }
      while (this.tokenizer.wasThis(","));
      localSelect.iGroupLen = k;
    }
    if (this.tokenizer.wasThis("HAVING"))
    {
      localSelect.iHavingLen = 1;
      localSelect.havingCondition = parseExpression();
      str = this.tokenizer.getString();
      localHsqlArrayList.add(localSelect.havingCondition);
    }
    if ((paramBoolean4) || (paramBoolean3))
    {
      if (this.tokenizer.wasThis("ORDER"))
      {
        this.tokenizer.getThis("BY");
        parseOrderBy(localSelect, localHsqlArrayList);
        str = this.tokenizer.getString();
      }
      if (this.tokenizer.wasThis("LIMIT"))
      {
        parseLimit(str, localSelect, true);
        str = this.tokenizer.getString();
      }
    }
    int k = 0;
    if ((paramInt > 0) && (str.equals(")")))
    {
      k = 1;
      paramInt -= parseCloseBrackets(paramInt - 1) + 1;
      str = this.tokenizer.getString();
    }
    localSelect.unionDepth = paramInt;
    if ((!paramBoolean4) && (k == 0))
      paramBoolean3 = false;
    int m = localSelect.iOrderLen != 0 ? 1 : 0;
    int n = localSelect.limitCondition != null ? 1 : 0;
    if (paramBoolean3)
    {
      if ((n != 0) && (m == 0))
        throw Trace.error(163);
    }
    else
    {
      if ((m != 0) && (!paramBoolean1))
        throw Trace.error(70);
      if ((n != 0) && (!paramBoolean2))
        throw Trace.error(153);
    }
    int i1 = parseUnion(str);
    if (i1 != 0)
    {
      boolean bool = false;
      localSelect.unionType = i1;
      if (this.tokenizer.isGetThis("("))
      {
        bool = true;
        paramInt += parseOpenBrackets() + 1;
      }
      this.tokenizer.getThis("SELECT");
      localSelect.unionSelect = parseSelect(paramInt, false, false, bool, false);
      str = this.tokenizer.getString();
    }
    if ((paramBoolean4) && ((paramBoolean1) || (paramBoolean3)) && (localSelect.iOrderLen == 0))
    {
      if (this.tokenizer.wasThis("ORDER"))
      {
        this.tokenizer.getThis("BY");
        parseOrderBy(localSelect, localHsqlArrayList);
        str = this.tokenizer.getString();
        localSelect.sortUnion = true;
      }
      if (this.tokenizer.wasThis("LIMIT"))
      {
        parseLimit(str, localSelect, true);
        str = this.tokenizer.getString();
      }
    }
    this.tokenizer.back();
    if (paramBoolean4)
      localSelect.prepareUnions();
    int i2 = localHsqlArrayList.size();
    localSelect.exprColumns = new Expression[i2];
    localHsqlArrayList.toArray(localSelect.exprColumns);
    return (Select)(Select)(Select)localSelect;
  }

  int parseUnion(String paramString)
    throws HsqlException
  {
    int i = 0;
    if (this.tokenizer.wasSimpleToken())
      switch (Token.get(paramString))
      {
      case 227:
        paramString = this.tokenizer.getSimpleToken();
        if (paramString.equals("ALL"))
        {
          i = 2;
        }
        else if (paramString.equals("DISTINCT"))
        {
          i = 1;
        }
        else
        {
          i = 1;
          this.tokenizer.back();
        }
        break;
      case 115:
        this.tokenizer.isGetThis("DISTINCT");
        i = 3;
        break;
      case 78:
      case 311:
        this.tokenizer.isGetThis("DISTINCT");
        i = 4;
        break;
      }
    return i;
  }

  private void parseLimit(String paramString, Select paramSelect, boolean paramBoolean)
    throws HsqlException
  {
    if (paramSelect.limitCondition != null)
      return;
    Expression localExpression1 = null;
    int i = 0;
    Expression localExpression2;
    if (paramBoolean)
    {
      if (paramString.equals("LIMIT"))
      {
        i = 1;
        read();
        localExpression2 = readTerm();
        if (this.sToken.equals("OFFSET"))
        {
          read();
          localExpression1 = readTerm();
        }
        this.tokenizer.back();
      }
      else
      {
        return;
      }
    }
    else if (paramString.equals("LIMIT"))
    {
      read();
      localExpression1 = readTerm();
      localExpression2 = readTerm();
      i = 1;
      this.tokenizer.back();
    }
    else if (paramString.equals("TOP"))
    {
      read();
      localExpression2 = readTerm();
      this.tokenizer.back();
    }
    else
    {
      return;
    }
    if (localExpression1 == null)
      localExpression1 = new Expression(4, ValuePool.getInt(0));
    if (((localExpression1.isParam()) || ((localExpression1.getType() == 1) && (localExpression1.getDataType() == 4) && (localExpression1.getValue(null) != null) && (((Integer)localExpression1.getValue(null)).intValue() >= 0))) && ((localExpression2.isParam()) || ((localExpression2.getType() == 1) && (localExpression2.getDataType() == 4) && (localExpression2.getValue(null) != null) && (((Integer)localExpression2.getValue(null)).intValue() >= 0))))
    {
      localExpression1.setDataType(4);
      localExpression2.setDataType(4);
      paramSelect.limitCondition = new Expression(8, localExpression1, localExpression2);
      return;
    }
    int j = i != 0 ? 168 : 169;
    throw Trace.error(16, j);
  }

  private void parseOrderBy(Select paramSelect, HsqlArrayList paramHsqlArrayList)
    throws HsqlException
  {
    int i = 0;
    String str;
    do
    {
      Expression localExpression = parseExpression();
      localExpression = resolveOrderByExpression(localExpression, paramSelect, paramHsqlArrayList);
      str = this.tokenizer.getString();
      if (str.equals("DESC"))
      {
        localExpression.setDescending();
        str = this.tokenizer.getString();
      }
      else if (str.equals("ASC"))
      {
        str = this.tokenizer.getString();
      }
      paramHsqlArrayList.add(localExpression);
      i++;
    }
    while (str.equals(","));
    this.tokenizer.back();
    paramSelect.iOrderLen = i;
  }

  private void resolveSelectTableFilter(Select paramSelect, HsqlArrayList paramHsqlArrayList1, HsqlArrayList paramHsqlArrayList2)
    throws HsqlException
  {
    TableFilter[] arrayOfTableFilter = new TableFilter[paramHsqlArrayList2.size()];
    paramHsqlArrayList2.toArray(arrayOfTableFilter);
    paramSelect.tFilter = arrayOfTableFilter;
    int i = paramHsqlArrayList1.size();
    int j = 0;
    Expression localExpression1;
    while (j < i)
    {
      localExpression1 = (Expression)paramHsqlArrayList1.get(j);
      if (localExpression1.getType() == 6)
      {
        paramHsqlArrayList1.remove(j);
        i = paramHsqlArrayList1.size();
        String str = localExpression1.getTableName();
        int m = j;
        if (str == null)
          for (int n = 0; n < arrayOfTableFilter.length; n++)
          {
            j = addFilterColumns(arrayOfTableFilter[n], paramHsqlArrayList1, j);
            i = paramHsqlArrayList1.size();
          }
        TableFilter localTableFilter = localExpression1.findTableFilter(arrayOfTableFilter);
        if (localTableFilter == null)
          throw Trace.error(22, str);
        j = addFilterColumns(localTableFilter, paramHsqlArrayList1, j);
        i = paramHsqlArrayList1.size();
        if (!isCompilingView())
          continue;
        boolean bool = false;
        Iterator localIterator = paramSelect.asteriskPositions.keySet().iterator();
        while (localIterator.hasNext())
        {
          int i1 = localIterator.nextInt();
          if (localExpression1 != paramSelect.asteriskPositions.get(i1))
            continue;
          StringBuffer localStringBuffer = new StringBuffer();
          for (int i2 = m; i2 < j; i2++)
          {
            Expression localExpression2 = (Expression)paramHsqlArrayList1.get(i2);
            localStringBuffer.append(localExpression2.getColumnDDL());
            if (i2 >= j - 1)
              continue;
            localStringBuffer.append(", ");
          }
          paramSelect.asteriskPositions.put(i1, localStringBuffer.toString());
          bool = true;
        }
        Trace.doAssert(bool);
        continue;
      }
      if (localExpression1.getFilter() == null)
        for (int k = 0; k < arrayOfTableFilter.length; k++)
          localExpression1.resolveTables(arrayOfTableFilter[k]);
      j++;
    }
    for (j = 0; j < i; j++)
    {
      localExpression1 = (Expression)paramHsqlArrayList1.get(j);
      localExpression1.resolveTypes(this.session);
    }
    paramSelect.iResultLen = i;
  }

  int addFilterColumns(TableFilter paramTableFilter, HsqlArrayList paramHsqlArrayList, int paramInt)
    throws HsqlException
  {
    Table localTable = paramTableFilter.getTable();
    int i = localTable.getColumnCount();
    for (int j = 0; j < i; j++)
    {
      Expression localExpression = new Expression(paramTableFilter, localTable.getColumn(j));
      if (isCompilingView())
        localExpression.resolveTables(paramTableFilter);
      paramHsqlArrayList.add(paramInt++, localExpression);
    }
    return paramInt;
  }

  private static Expression resolveOrderByExpression(Expression paramExpression, Select paramSelect, HsqlArrayList paramHsqlArrayList)
    throws HsqlException
  {
    int i = paramSelect.iResultLen;
    int j = paramSelect.unionSelect != null ? 1 : 0;
    if (paramExpression.getType() == 1)
      return resolveOrderByColumnIndex(paramExpression, paramHsqlArrayList, i);
    if (paramExpression.getType() != 2)
    {
      if (j != 0)
        throw Trace.error(70);
      return paramExpression;
    }
    String str1 = paramExpression.getColumnName();
    String str2 = paramExpression.getTableName();
    int k = 0;
    int m = i;
    while (k < m)
    {
      Expression localExpression = (Expression)paramHsqlArrayList.get(k);
      String str3 = localExpression.getDefinedAlias();
      String str4 = localExpression.getColumnName();
      String str5 = localExpression.getTableName();
      String str6 = localExpression.getFilterTableName();
      if (((str1.equals(str3)) || (str1.equals(str4))) && ((str2 == null) || (str2.equals(str5)) || (str2.equals(str6))))
      {
        localExpression.joinedTableColumnIndex = k;
        return localExpression;
      }
      k++;
    }
    if (j != 0)
      throw Trace.error(70, str1);
    return paramExpression;
  }

  private static Expression resolveOrderByColumnIndex(Expression paramExpression, HsqlArrayList paramHsqlArrayList, int paramInt)
    throws HsqlException
  {
    if (paramExpression.getDataType() == 4)
    {
      int i = ((Integer)paramExpression.getValue(null)).intValue();
      if ((0 < i) && (i <= paramInt))
      {
        Expression localExpression = (Expression)paramHsqlArrayList.get(i - 1);
        localExpression.joinedTableColumnIndex = (i - 1);
        return localExpression;
      }
    }
    throw Trace.error(70);
  }

  private TableFilter parseSimpleTableFilter(int paramInt)
    throws HsqlException
  {
    Object localObject = null;
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
    Table localTable = this.database.schemaManager.getTable(this.session, str1, str2);
    checkTableWriteAccess(localTable, paramInt);
    str1 = this.tokenizer.getString();
    if (str1.equals("AS"))
      localObject = this.tokenizer.getSimpleName();
    else if (this.tokenizer.wasSimpleName())
      localObject = str1;
    else
      this.tokenizer.back();
    return (TableFilter)new TableFilter(localTable, (String)localObject, null, false);
  }

  private TableFilter parseTableFilter(boolean paramBoolean)
    throws HsqlException
  {
    Table localTable = null;
    SubQuery localSubQuery = null;
    Object localObject = null;
    HashMappedList localHashMappedList = null;
    if (this.tokenizer.isGetThis("("))
    {
      int i = parseOpenBrackets();
      this.tokenizer.getThis("SELECT");
      localSubQuery = parseSubquery(i, null, true, 3);
      this.tokenizer.getThis(")");
      localTable = localSubQuery.table;
    }
    else
    {
      str1 = this.tokenizer.getName();
      String str2 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
      localTable = this.database.schemaManager.getTable(this.session, str1, str2);
      this.session.check(localTable.getName(), 1);
      if (localTable.isView())
      {
        localSubQuery = getViewSubquery((View)localTable);
        localSubQuery.select = ((View)localTable).viewSelect;
        localTable = localSubQuery.table;
        localObject = str1;
      }
    }
    String str1 = this.tokenizer.getString();
    if (this.tokenizer.wasLongName())
      this.tokenizer.throwUnexpected();
    if (((str1.equals("LEFT")) || (str1.equals("RIGHT"))) && (!this.tokenizer.wasQuotedIdentifier()))
    {
      this.tokenizer.back();
    }
    else if ((str1.equals("AS")) && (!this.tokenizer.wasQuotedIdentifier()))
    {
      localObject = this.tokenizer.getSimpleName();
      if (this.tokenizer.isGetThis("("))
      {
        this.tokenizer.back();
        localHashMappedList = parseColumnList();
      }
    }
    else if (this.tokenizer.wasSimpleName())
    {
      localObject = str1;
      if (this.tokenizer.isGetThis("("))
      {
        this.tokenizer.back();
        localHashMappedList = parseColumnList();
      }
    }
    else
    {
      this.tokenizer.back();
    }
    if ((localHashMappedList != null) && (localTable.getColumnCount() != localHashMappedList.size()))
      throw Trace.error(5);
    return (TableFilter)new TableFilter(localTable, (String)localObject, localHashMappedList, paramBoolean);
  }

  private static Expression addCondition(Expression paramExpression1, Expression paramExpression2)
  {
    if (paramExpression1 == null)
      return paramExpression2;
    if (paramExpression2 == null)
      return paramExpression1;
    return new Expression(28, paramExpression1, paramExpression2);
  }

  private static Expression addJoinCondition(Expression paramExpression1, Expression paramExpression2, TableFilter paramTableFilter, boolean paramBoolean)
    throws HsqlException
  {
    if (!paramExpression2.setForJoin(paramTableFilter, paramBoolean))
      throw Trace.error(64);
    return addCondition(paramExpression1, paramExpression2);
  }

  Expression parseExpression()
    throws HsqlException
  {
    read();
    Expression localExpression = readOr();
    this.tokenizer.back();
    return localExpression;
  }

  private Expression readAggregate()
    throws HsqlException
  {
    boolean bool = false;
    int i = 0;
    int j = this.iToken;
    read();
    String str = this.tokenizer.getString();
    if (str.equals("DISTINCT"))
      bool = true;
    else if (str.equals("ALL"))
      i = 1;
    else
      this.tokenizer.back();
    readThis(101);
    Expression localExpression1 = readOr();
    readThis(102);
    if (((i != 0) || (bool)) && ((j == 47) || (j == 48) || (j == 49) || (j == 50)))
      throw Trace.error(200);
    Expression localExpression2 = new Expression(j, localExpression1, null);
    localExpression2.setDistinctAggregate(bool);
    return localExpression2;
  }

  private Expression readOr()
    throws HsqlException
  {
    int i;
    Expression localExpression2;
    for (Expression localExpression1 = readAnd(); this.iToken == 29; localExpression1 = new Expression(i, localExpression2, readAnd()))
    {
      i = this.iToken;
      localExpression2 = localExpression1;
      read();
    }
    return localExpression1;
  }

  private Expression readAnd()
    throws HsqlException
  {
    int i;
    Expression localExpression2;
    for (Expression localExpression1 = readCondition(); this.iToken == 28; localExpression1 = new Expression(i, localExpression2, readCondition()))
    {
      i = this.iToken;
      localExpression2 = localExpression1;
      read();
    }
    return localExpression1;
  }

  private Expression readCondition()
    throws HsqlException
  {
    int i;
    switch (this.iToken)
    {
    case 20:
      i = this.iToken;
      read();
      return new Expression(i, readCondition(), null);
    case 31:
      i = this.iToken;
      read();
      readThis(101);
      j = 0;
      if (this.iToken == 101)
      {
        j += parseOpenBrackets() + 1;
        read();
      }
      Trace.check(this.iToken == 103, 11);
      SubQuery localSubQuery = parseSubquery(j, null, false, 31);
      Expression localExpression2 = new Expression(localSubQuery);
      read();
      readThis(102);
      return new Expression(i, localExpression2, null);
    }
    Expression localExpression1 = readConcat();
    if (this.iToken == 109)
    {
      read();
      if (this.iToken == 20)
      {
        j = 1;
        read();
      }
      else
      {
        j = 0;
      }
      Trace.check((this.iToken == 1) && (this.oData == null), 11);
      read();
      localExpression1 = new Expression(34, localExpression1, new Expression(0, null));
      if (j != 0)
        localExpression1 = new Expression(20, localExpression1, null);
      return localExpression1;
    }
    int j = 0;
    if (this.iToken == 20)
    {
      j = 1;
      read();
    }
    switch (this.iToken)
    {
    case 27:
      localExpression1 = parseLikePredicate(localExpression1);
      break;
    case 106:
      localExpression1 = parseBetweenPredicate(localExpression1);
      break;
    case 30:
      localExpression1 = parseInPredicate(localExpression1);
      break;
    default:
      Trace.check(j == 0, 11);
      if (Expression.isCompare(this.iToken))
      {
        int k = this.iToken;
        read();
        return new Expression(k, localExpression1, readConcat());
      }
      return localExpression1;
    }
    if (j != 0)
      localExpression1 = new Expression(20, localExpression1, null);
    return localExpression1;
  }

  private Expression parseLikePredicate(Expression paramExpression)
    throws HsqlException
  {
    read();
    Expression localExpression1 = readConcat();
    Character localCharacter = null;
    if (this.sToken.equals("ESCAPE"))
    {
      read();
      Expression localExpression2 = readTerm();
      Trace.check(localExpression2.getType() == 1, 7);
      String str = (String)localExpression2.getValue(this.session, 12);
      if ((str == null) || (str.length() < 1))
        throw Trace.error(7, str);
      localCharacter = new Character(str.charAt(0));
    }
    boolean bool = this.database.collation.name != null;
    paramExpression = new Expression(paramExpression, localExpression1, localCharacter, bool);
    return paramExpression;
  }

  private Expression parseBetweenPredicate(Expression paramExpression)
    throws HsqlException
  {
    read();
    Expression localExpression1 = new Expression(22, paramExpression, readConcat());
    readThis(28);
    Expression localExpression2 = new Expression(25, paramExpression, readConcat());
    if ((localExpression1.getArg().isParam()) && (localExpression1.getArg2().isParam()))
      throw Trace.error(216, 185);
    if ((localExpression2.getArg().isParam()) && (localExpression2.getArg2().isParam()))
      throw Trace.error(216, 185);
    return new Expression(28, localExpression1, localExpression2);
  }

  private Expression parseInPredicate(Expression paramExpression)
    throws HsqlException
  {
    int i = this.iToken;
    read();
    readThis(101);
    Expression localExpression = null;
    int j = 0;
    if (this.iToken == 101)
    {
      j += parseOpenBrackets() + 1;
      read();
    }
    Object localObject1;
    if (this.iToken == 103)
    {
      localObject1 = parseSubquery(j, null, false, 30);
      Trace.check(((SubQuery)localObject1).select.iResultLen == 1, 159);
      localExpression = new Expression((SubQuery)localObject1);
      read();
    }
    else
    {
      this.tokenizer.back();
      localObject1 = new HsqlArrayList();
      while (true)
      {
        localObject2 = parseExpression();
        if ((((Expression)localObject2).exprType == 1) && (((Expression)localObject2).valueData == null) && (!((Expression)localObject2).isParam()))
          throw Trace.error(79);
        ((HsqlArrayList)localObject1).add(localObject2);
        read();
        if (this.iToken != 104)
          break;
      }
      Object localObject2 = (Expression[])((HsqlArrayList)localObject1).toArray(new Expression[((HsqlArrayList)localObject1).size()]);
      localExpression = new Expression(localObject2);
    }
    readThis(102);
    return (Expression)(Expression)new Expression(i, paramExpression, localExpression);
  }

  private Expression parseAllAnyPredicate()
    throws HsqlException
  {
    int i = this.iToken;
    read();
    readThis(101);
    Expression localExpression = null;
    int j = 0;
    if (this.iToken == 101)
    {
      j += parseOpenBrackets() + 1;
      read();
    }
    if (this.iToken != 103)
      throw Trace.error(74);
    SubQuery localSubQuery = parseSubquery(j, null, false, i);
    Select localSelect = localSubQuery.select;
    Trace.check(localSubQuery.select.iResultLen == 1, 159);
    localExpression = new Expression(localSubQuery);
    read();
    readThis(102);
    return new Expression(i, localExpression, null);
  }

  private void readThis(int paramInt)
    throws HsqlException
  {
    Trace.check(this.iToken == paramInt, 11);
    read();
  }

  private Expression readConcat()
    throws HsqlException
  {
    int i;
    Expression localExpression2;
    for (Expression localExpression1 = readSum(); this.iToken == 15; localExpression1 = new Expression(i, localExpression2, readSum()))
    {
      i = 15;
      localExpression2 = localExpression1;
      read();
    }
    return localExpression1;
  }

  private Expression readSum()
    throws HsqlException
  {
    int i;
    Expression localExpression2;
    for (Expression localExpression1 = readFactor(); ; localExpression1 = new Expression(i, localExpression2, readFactor()))
    {
      if (this.iToken == 100)
      {
        i = 11;
      }
      else
      {
        if (this.iToken != 10)
          break;
        i = 12;
      }
      localExpression2 = localExpression1;
      read();
    }
    return localExpression1;
  }

  private Expression readFactor()
    throws HsqlException
  {
    int i;
    Expression localExpression2;
    for (Expression localExpression1 = readTerm(); (this.iToken == 13) || (this.iToken == 14); localExpression1 = new Expression(i, localExpression2, readTerm()))
    {
      i = this.iToken;
      localExpression2 = localExpression1;
      read();
    }
    return localExpression1;
  }

  private Expression readTerm()
    throws HsqlException
  {
    Expression localExpression = null;
    switch (this.iToken)
    {
    case 2:
      localExpression = readColumnExpression();
      break;
    case 10:
      int i = this.iToken;
      read();
      localExpression = new Expression(i, readTerm(), null);
      Trace.check(!localExpression.getArg().isParam(), 212);
      break;
    case 100:
      read();
      localExpression = readTerm();
      Trace.check(!localExpression.isParam(), 216, Trace.getMessage(212));
      break;
    case 101:
      read();
      localExpression = readOr();
      if (this.iToken != 102)
        throw Trace.error(11, this.sToken);
      read();
      break;
    case 1:
      localExpression = new Expression(this.iType, this.oData);
      read();
      break;
    case 9:
      localExpression = new Expression(0, null, true);
      this.parameters.add(localExpression);
      read();
      break;
    case 103:
      SubQuery localSubQuery = parseSubquery(0, null, false, 103);
      localExpression = new Expression(localSubQuery);
      read();
      break;
    case 32:
    case 33:
      localExpression = parseAllAnyPredicate();
      break;
    case 13:
      localExpression = new Expression(this.sSchema, this.sTable, (String)null);
      read();
      break;
    case 62:
      return readCaseWhenExpression();
    case 68:
      return readCaseExpression();
    case 67:
      return readNullIfExpression();
    case 60:
    case 69:
      return readCoalesceExpression();
    case 71:
      return readSequenceExpression();
    case 61:
    case 107:
      return readCastExpression();
    case 63:
      return readExtractExpression();
    case 65:
      return readTrimExpression();
    case 64:
      return readPositionExpression();
    case 66:
      return readSubstringExpression();
    default:
      if (Expression.isAggregate(this.iToken))
        return readAggregate();
      throw Trace.error(11, this.sToken);
    }
    return localExpression;
  }

  Expression readCaseExpression()
    throws HsqlException
  {
    int i = 62;
    Object localObject = null;
    Expression localExpression1 = null;
    read();
    if (this.iToken != 110)
      localExpression1 = readOr();
    Expression localExpression2 = null;
    Expression localExpression3;
    while (true)
    {
      localExpression3 = parseCaseWhen(localExpression1);
      if (localObject == null)
        localObject = localExpression3;
      else
        localExpression2.setRightExpression(localExpression3);
      localExpression2 = localExpression3.getRightExpression();
      if (this.iToken != 110)
        break;
    }
    if (this.iToken == 112)
    {
      readThis(112);
      localExpression3 = readOr();
      localExpression2.setRightExpression(localExpression3);
    }
    readThis(113);
    return localObject;
  }

  private Expression parseCaseWhen(Expression paramExpression)
    throws HsqlException
  {
    readThis(110);
    Expression localExpression1;
    if (paramExpression == null)
      localExpression1 = readOr();
    else
      localExpression1 = new Expression(21, paramExpression, readOr());
    readThis(111);
    Expression localExpression2 = readOr();
    Expression localExpression3 = new Expression(70, localExpression2, new Expression(0, null));
    Expression localExpression4 = new Expression(62, localExpression1, localExpression3);
    return localExpression4;
  }

  private Expression readCaseWhenExpression()
    throws HsqlException
  {
    int i = this.iToken;
    Expression localExpression1 = null;
    read();
    readThis(101);
    localExpression1 = readOr();
    readThis(104);
    Expression localExpression2 = readOr();
    readThis(104);
    localExpression2 = new Expression(70, localExpression2, readOr());
    localExpression1 = new Expression(i, localExpression1, localExpression2);
    readThis(102);
    return localExpression1;
  }

  private Expression readCastExpression()
    throws HsqlException
  {
    int i = this.iToken == 61 ? 1 : 0;
    read();
    readThis(101);
    Expression localExpression = readOr();
    if (i != 0)
      readThis(104);
    else
      readThis(122);
    int j = Types.getTypeNr(this.sToken);
    int k = 0;
    int m = 0;
    int n = 0;
    if ((Types.acceptsPrecisionCreateParam(j)) && (this.tokenizer.isGetThis("(")))
    {
      k = this.tokenizer.getInt();
      n = 1;
      if ((Types.acceptsScaleCreateParam(j)) && (this.tokenizer.isGetThis(",")))
        m = this.tokenizer.getInt();
      this.tokenizer.getThis(")");
    }
    if ((j == 6) && (k > 53))
      throw Trace.error(65);
    if (j == 93)
      if (n == 0)
        k = 6;
      else if ((k != 0) && (k != 6))
        throw Trace.error(65);
    if (localExpression.isParam())
      localExpression.setDataType(j);
    localExpression = new Expression(localExpression, j, k, m);
    read();
    readThis(102);
    return localExpression;
  }

  private Expression readColumnExpression()
    throws HsqlException
  {
    String str1 = this.sToken;
    Expression localExpression = new Expression(this.sTable, str1, this.wasQuoted);
    read();
    String str2;
    Function localFunction;
    if (this.iToken == 101)
    {
      str2 = this.database.getJavaName(str1);
      localFunction = new Function(str1, str2, false);
      this.session.check(str2);
      int i = localFunction.getArgCount();
      int j = 0;
      read();
      if (this.iToken != 102)
        while (true)
        {
          localFunction.setArgument(j++, readOr());
          if (this.iToken != 104)
            break;
          read();
        }
      readThis(102);
      localExpression = new Expression(localFunction);
    }
    else
    {
      str2 = (String)simpleFunctions.get(str1);
      if (str2 != null)
      {
        localFunction = new Function(str1, str2, true);
        localExpression = new Expression(localFunction);
      }
    }
    return localExpression;
  }

  private Expression readConcatExpression()
    throws HsqlException
  {
    int i = this.iToken;
    read();
    readThis(101);
    Expression localExpression = readOr();
    readThis(104);
    localExpression = new Expression(i, localExpression, readOr());
    readThis(102);
    return localExpression;
  }

  private Expression readNullIfExpression()
    throws HsqlException
  {
    read();
    readThis(101);
    Expression localExpression1 = readOr();
    readThis(104);
    Expression localExpression2 = new Expression(70, new Expression(0, null), localExpression1);
    localExpression1 = new Expression(21, localExpression1, readOr());
    localExpression1 = new Expression(62, localExpression1, localExpression2);
    readThis(102);
    return localExpression1;
  }

  private Expression readCoalesceExpression()
    throws HsqlException
  {
    Object localObject1 = null;
    read();
    readThis(101);
    Object localObject2 = null;
    while (true)
    {
      Expression localExpression1 = readOr();
      if ((localObject2 != null) && (this.iToken == 102))
      {
        readThis(102);
        localObject2.setLeftExpression(localExpression1);
        break;
      }
      Expression localExpression2 = new Expression(34, localExpression1, null);
      Expression localExpression3 = new Expression(70, new Expression(0, null), localExpression1);
      Expression localExpression4 = new Expression(62, localExpression2, localExpression3);
      if (localObject1 == null)
        localObject1 = localExpression4;
      else
        localObject2.setLeftExpression(localExpression4);
      localObject2 = localExpression3;
      readThis(104);
    }
    return localObject1;
  }

  private Expression readExtractExpression()
    throws HsqlException
  {
    read();
    readThis(101);
    String str = this.sToken;
    if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(str))
      throw Trace.error(11, this.sToken);
    readToken();
    readThis(124);
    Function localFunction = new Function(str, this.database.getJavaName(str), false);
    localFunction.setArgument(0, readOr());
    readThis(102);
    return new Expression(localFunction);
  }

  private Expression readPositionExpression()
    throws HsqlException
  {
    read();
    readThis(101);
    Function localFunction = new Function("POSITION", "org.hsqldb.Library.position", false);
    localFunction.setArgument(0, readTerm());
    readThis(30);
    localFunction.setArgument(1, readOr());
    readThis(102);
    return new Expression(localFunction);
  }

  private Expression readSubstringExpression()
    throws HsqlException
  {
    int i = 0;
    read();
    readThis(101);
    Function localFunction = new Function("SUBSTRING", "org.hsqldb.Library.substring", false);
    localFunction.setArgument(0, readTerm());
    if (this.iToken == 124)
    {
      readThis(124);
    }
    else
    {
      readThis(104);
      i = 1;
    }
    localFunction.setArgument(1, readOr());
    Expression localExpression = null;
    if ((i == 0) && (this.iToken == 123))
    {
      readThis(123);
      localExpression = readTerm();
    }
    else if ((i != 0) && (this.iToken == 104))
    {
      readThis(104);
      localExpression = readTerm();
    }
    localFunction.setArgument(2, localExpression);
    readThis(102);
    return new Expression(localFunction);
  }

  private Expression readSequenceExpression()
    throws HsqlException
  {
    this.tokenizer.getThis("VALUE");
    this.tokenizer.getThis("FOR");
    String str1 = this.tokenizer.getName();
    String str2 = this.tokenizer.getLongNameFirst();
    str2 = this.session.getSchemaName(str2);
    this.tokenizer.getString();
    NumberSequence localNumberSequence = this.database.schemaManager.getSequence(str1, str2);
    return new Expression(localNumberSequence);
  }

  private Expression readTrimExpression()
    throws HsqlException
  {
    read();
    readThis(101);
    String str1 = this.sToken;
    if (Expression.SQL_TRIM_SPECIFICATION.contains(str1))
      read();
    else
      str1 = "BOTH";
    String str2;
    if (this.sToken.length() == 1)
    {
      str2 = this.sToken;
      read();
    }
    else
    {
      str2 = " ";
    }
    readThis(124);
    Expression localExpression1 = new Expression(1, str2);
    Expression localExpression2;
    Expression localExpression3;
    if (str1.equals("LEADING"))
    {
      localExpression2 = new Expression(true);
      localExpression3 = new Expression(false);
    }
    else if (str1.equals("TRAILING"))
    {
      localExpression2 = new Expression(false);
      localExpression3 = new Expression(true);
    }
    else
    {
      localExpression2 = localExpression3 = new Expression(true);
    }
    Function localFunction = new Function("TRIM", "org.hsqldb.Library.trim", false);
    localFunction.setArgument(0, readOr());
    localFunction.setArgument(1, localExpression1);
    localFunction.setArgument(2, localExpression2);
    localFunction.setArgument(3, localExpression3);
    readThis(102);
    return new Expression(localFunction);
  }

  Expression readDefaultClause(int paramInt)
    throws HsqlException
  {
    Object localObject = null;
    read();
    String str3;
    Function localFunction;
    switch (this.iToken)
    {
    case 2:
      String str1 = this.sToken;
      str3 = (String)simpleFunctions.get(str1);
      if (str3 == null)
        break;
      localFunction = new Function(str1, str3, true);
      return new Expression(localFunction);
    case 10:
      int i = this.iToken;
      read();
      if (this.iToken != 1)
        break;
      this.oData = Column.convertObject(this.oData, paramInt);
      return new Expression(i, new Expression(paramInt, this.oData), null);
    case 1:
      String str2 = this.sToken.toUpperCase(Locale.ENGLISH);
      str3 = (String)simpleFunctions.get(str2);
      if ((Types.isDatetimeType(paramInt)) && (str3 != null))
      {
        localFunction = new Function(str2, str3, true);
        return new Expression(localFunction);
      }
      this.oData = Column.convertObject(this.oData, paramInt);
      return new Expression(paramInt, this.oData);
    }
    throw Trace.error(46, this.sToken);
  }

  private void read()
    throws HsqlException
  {
    this.sToken = this.tokenizer.getString();
    this.wasQuoted = this.tokenizer.wasQuotedIdentifier();
    if (this.tokenizer.wasValue())
    {
      this.iToken = 1;
      this.oData = this.tokenizer.getAsValue();
      this.iType = this.tokenizer.getType();
    }
    else if (this.tokenizer.wasSimpleName())
    {
      this.iToken = 2;
      this.sTable = null;
    }
    else if (this.tokenizer.wasLongName())
    {
      this.sSchema = this.tokenizer.getLongNamePre();
      this.sTable = this.tokenizer.getLongNameFirst();
      if (this.sToken.equals("*"))
        this.iToken = 13;
      else
        this.iToken = 2;
    }
    else if (this.tokenizer.wasParameter())
    {
      this.iToken = 9;
    }
    else if (this.sToken.length() == 0)
    {
      this.iToken = 108;
    }
    else
    {
      this.iToken = tokenSet.get(this.sToken, -1);
      if (this.iToken == -1)
        this.iToken = 108;
      switch (this.iToken)
      {
      case 9:
      case 10:
      case 14:
      case 15:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
      case 30:
      case 31:
      case 32:
      case 33:
      case 40:
      case 41:
      case 42:
      case 43:
      case 44:
      case 45:
      case 46:
      case 47:
      case 48:
      case 49:
      case 50:
      case 60:
      case 61:
      case 62:
      case 63:
      case 64:
      case 65:
      case 66:
      case 67:
      case 68:
      case 69:
      case 71:
      case 100:
      case 101:
      case 102:
      case 103:
      case 104:
      case 106:
      case 107:
      case 108:
      case 109:
      case 110:
      case 111:
      case 112:
      case 113:
      case 114:
      case 122:
      case 123:
      case 124:
      case 125:
      case 126:
      case 127:
        break;
      case 13:
        this.sTable = null;
        break;
      case 11:
      case 12:
      case 16:
      case 17:
      case 18:
      case 19:
      case 34:
      case 35:
      case 36:
      case 37:
      case 38:
      case 39:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
      case 58:
      case 59:
      case 70:
      case 72:
      case 73:
      case 74:
      case 75:
      case 76:
      case 77:
      case 78:
      case 79:
      case 80:
      case 81:
      case 82:
      case 83:
      case 84:
      case 85:
      case 86:
      case 87:
      case 88:
      case 89:
      case 90:
      case 91:
      case 92:
      case 93:
      case 94:
      case 95:
      case 96:
      case 97:
      case 98:
      case 99:
      case 105:
      case 115:
      case 116:
      case 117:
      case 118:
      case 119:
      case 120:
      case 121:
      default:
        this.iToken = 108;
      }
    }
  }

  private void readToken()
    throws HsqlException
  {
    this.sToken = this.tokenizer.getString();
    this.iToken = tokenSet.get(this.sToken, -1);
  }

  Expression[] getParameters()
  {
    Expression[] arrayOfExpression = this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
    this.parameters.clear();
    return arrayOfExpression;
  }

  void clearParameters()
  {
    this.parameters.clear();
  }

  void setAsView(View paramView)
  {
    for (int i = 0; i < this.subQueryList.size(); i++)
    {
      SubQuery localSubQuery = (SubQuery)this.subQueryList.get(i);
      if (localSubQuery.view != null)
        continue;
      localSubQuery.view = paramView;
    }
  }

  SubQuery[] getSortedSubqueries()
  {
    if (this.subQueryList.size() == 0)
      return noSubqueries;
    this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
    SubQuery[] arrayOfSubQuery = new SubQuery[this.subQueryList.size()];
    this.subQueryList.toArray(arrayOfSubQuery);
    this.subQueryList.clear();
    return arrayOfSubQuery;
  }

  CompiledStatement compileCallStatement()
    throws HsqlException
  {
    clearParameters();
    Expression localExpression = parseExpression();
    CompiledStatement localCompiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, localExpression, getSortedSubqueries(), getParameters());
    return localCompiledStatement;
  }

  CompiledStatement compileDeleteStatement()
    throws HsqlException
  {
    Expression localExpression = null;
    clearParameters();
    this.tokenizer.getThis("FROM");
    TableFilter localTableFilter = parseSimpleTableFilter(2);
    String str = this.tokenizer.getString();
    if (str.equals("WHERE"))
      localExpression = parseExpression();
    else
      this.tokenizer.back();
    CompiledStatement localCompiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, localTableFilter, localExpression, getSortedSubqueries(), getParameters());
    return localCompiledStatement;
  }

  private void getInsertColumnValueExpressions(Table paramTable, Expression[] paramArrayOfExpression, int paramInt)
    throws HsqlException
  {
    this.tokenizer.getThis("(");
    for (int i = 0; i < paramInt; i++)
    {
      Expression localExpression = parseExpression();
      localExpression.resolveTables(null);
      localExpression.resolveTypes(this.session);
      paramArrayOfExpression[i] = localExpression;
      String str = this.tokenizer.getSimpleToken();
      if (str.equals(","))
        continue;
      if (str.equals(")"))
      {
        if (i != paramInt - 1)
          break;
        return;
      }
      this.tokenizer.throwUnexpected();
    }
    throw Trace.error(5);
  }

  CompiledStatement compileInsertStatement()
    throws HsqlException
  {
    clearParameters();
    this.tokenizer.getThis("INTO");
    String str1 = this.tokenizer.getName();
    String str2 = this.session.getSchemaName(this.tokenizer.getLongNameFirst());
    Table localTable = this.database.schemaManager.getTable(this.session, str1, str2);
    checkTableWriteAccess(localTable, 4);
    HsqlArrayList localHsqlArrayList = null;
    boolean[] arrayOfBoolean = null;
    int[] arrayOfInt = localTable.getColumnMap();
    int i = localTable.getColumnCount();
    int j = parseOpenBrackets();
    str1 = this.tokenizer.getString();
    if ((j == 1) && (!this.tokenizer.wasThis("SELECT")))
    {
      j = 0;
      this.tokenizer.back();
      localHsqlArrayList = getColumnNames(this.database, localTable, this.tokenizer, false);
      if (localHsqlArrayList.size() > i)
        throw Trace.error(5);
      i = localHsqlArrayList.size();
      arrayOfBoolean = localTable.getNewColumnCheckList();
      arrayOfInt = new int[i];
      for (k = 0; k < i; k++)
      {
        int m = localTable.getColumnNr((String)localHsqlArrayList.get(k));
        arrayOfInt[k] = m;
        arrayOfBoolean[m] = true;
      }
      str1 = this.tokenizer.getSimpleToken();
    }
    else if (!this.tokenizer.wasSimpleToken())
    {
      this.tokenizer.throwUnexpected();
    }
    int k = Token.get(str1);
    Object localObject;
    CompiledStatement localCompiledStatement;
    switch (k)
    {
    case 226:
      localObject = new Expression[i];
      getInsertColumnValueExpressions(localTable, localObject, i);
      localCompiledStatement = new CompiledStatement(this.session.currentSchema, localTable, arrayOfInt, localObject, arrayOfBoolean, getSortedSubqueries(), getParameters());
      return localCompiledStatement;
    case 313:
      j = parseOpenBrackets() + 1;
      this.tokenizer.getThis("SELECT");
    case 193:
      localObject = parseSelect(j, true, false, true, true);
      if (i != ((Select)localObject).iResultLen)
        throw Trace.error(5);
      localCompiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, localTable, arrayOfInt, arrayOfBoolean, (Select)localObject, getSortedSubqueries(), getParameters());
      return localCompiledStatement;
    }
    throw Trace.error(11, str1);
  }

  CompiledStatement compileSelectStatement(int paramInt)
    throws HsqlException
  {
    clearParameters();
    Select localSelect = parseSelect(paramInt, true, true, false, true);
    if (localSelect.sIntoTable != null)
    {
      localObject = localSelect.sIntoTable.name;
      String str = localSelect.sIntoTable.schema.name;
      if (this.database.schemaManager.findUserTable(this.session, (String)localObject, str) != null)
        throw Trace.error(21, localObject);
    }
    Object localObject = new CompiledStatement(this.session, this.database, this.session.currentSchema, localSelect, getSortedSubqueries(), getParameters());
    return (CompiledStatement)localObject;
  }

  CompiledStatement compileUpdateStatement()
    throws HsqlException
  {
    clearParameters();
    TableFilter localTableFilter = parseSimpleTableFilter(8);
    Table localTable = localTableFilter.filterTable;
    this.tokenizer.getThis("SET");
    int[] arrayOfInt = localTable.getNewColumnMap();
    Expression[] arrayOfExpression = new Expression[arrayOfInt.length];
    int i = 0;
    String str1 = null;
    do
    {
      int j = localTable.getColumnNr(this.tokenizer.getName());
      String str2 = this.tokenizer.getLongNameFirst();
      if ((str2 != null) && (!localTableFilter.getName().equals(str2)))
        throw Trace.error(22);
      this.tokenizer.getThis("=");
      Expression localExpression1 = parseExpression();
      if (i == arrayOfInt.length)
        throw Trace.error(5);
      arrayOfInt[i] = j;
      arrayOfExpression[i] = localExpression1;
      str1 = this.tokenizer.getSimpleToken();
      i++;
    }
    while (str1.equals(","));
    Expression localExpression2 = null;
    if (str1.equals("WHERE"))
      localExpression2 = parseExpression();
    else
      this.tokenizer.back();
    arrayOfInt = (int[])ArrayUtil.resizeArray(arrayOfInt, i);
    arrayOfExpression = (Expression[])ArrayUtil.resizeArray(arrayOfExpression, i);
    CompiledStatement localCompiledStatement = new CompiledStatement(this.session, this.database, this.session.currentSchema, localTableFilter, arrayOfInt, arrayOfExpression, localExpression2, getSortedSubqueries(), getParameters());
    return localCompiledStatement;
  }

  int parseOpenBracketsSelect()
    throws HsqlException
  {
    int i = parseOpenBrackets();
    this.tokenizer.getThis("SELECT");
    return i;
  }

  int parseOpenBrackets()
    throws HsqlException
  {
    for (int i = 0; this.tokenizer.isGetThis("("); i++);
    return i;
  }

  int parseCloseBrackets(int paramInt)
    throws HsqlException
  {
    for (int i = 0; (i < paramInt) && (this.tokenizer.isGetThis(")")); i++);
    return i;
  }

  HashMappedList parseColumnList()
    throws HsqlException
  {
    return processColumnList(this.tokenizer, false);
  }

  static HashMappedList processColumnList(Tokenizer paramTokenizer, boolean paramBoolean)
    throws HsqlException
  {
    HashMappedList localHashMappedList = new HashMappedList();
    paramTokenizer.getThis("(");
    String str;
    do
    {
      str = paramTokenizer.getSimpleName();
      boolean bool = localHashMappedList.add(str, null);
      if (!bool)
        throw Trace.error(27, str);
      str = paramTokenizer.getSimpleToken();
      if ((!paramBoolean) || ((!str.equals("DESC")) && (!str.equals("ASC"))))
        continue;
      str = paramTokenizer.getSimpleToken();
    }
    while (str.equals(","));
    if (!str.equals(")"))
      throw Trace.error(11, str);
    return localHashMappedList;
  }

  static
  {
    simpleFunctions.put("CURRENT_DATE", "org.hsqldb.Library.curdate");
    simpleFunctions.put("CURRENT_TIME", "org.hsqldb.Library.curtime");
    simpleFunctions.put("CURRENT_TIMESTAMP", "org.hsqldb.Library.now");
    simpleFunctions.put("CURRENT_USER", "org.hsqldb.Library.user");
    simpleFunctions.put("SYSDATE", "org.hsqldb.Library.curdate");
    simpleFunctions.put("NOW", "org.hsqldb.Library.now");
    simpleFunctions.put("TODAY", "org.hsqldb.Library.curdate");
    tokenSet = new IntValueHashMap(37);
    tokenSet.put(",", 104);
    tokenSet.put("=", 21);
    tokenSet.put("!=", 26);
    tokenSet.put("<>", 26);
    tokenSet.put("<", 24);
    tokenSet.put(">", 23);
    tokenSet.put("<=", 25);
    tokenSet.put(">=", 22);
    tokenSet.put("AND", 28);
    tokenSet.put("NOT", 20);
    tokenSet.put("OR", 29);
    tokenSet.put("ALL", 32);
    tokenSet.put("ANY", 33);
    tokenSet.put("IN", 30);
    tokenSet.put("EXISTS", 31);
    tokenSet.put("BETWEEN", 106);
    tokenSet.put("+", 100);
    tokenSet.put("-", 10);
    tokenSet.put("*", 13);
    tokenSet.put("/", 14);
    tokenSet.put("||", 15);
    tokenSet.put("(", 101);
    tokenSet.put(")", 102);
    tokenSet.put("SELECT", 103);
    tokenSet.put("LIKE", 27);
    tokenSet.put("COUNT", 40);
    tokenSet.put("SUM", 41);
    tokenSet.put("MIN", 42);
    tokenSet.put("MAX", 43);
    tokenSet.put("AVG", 44);
    tokenSet.put("EVERY", 45);
    tokenSet.put("SOME", 46);
    tokenSet.put("STDDEV_POP", 47);
    tokenSet.put("STDDEV_SAMP", 48);
    tokenSet.put("VAR_POP", 49);
    tokenSet.put("VAR_SAMP", 50);
    tokenSet.put("IFNULL", 60);
    tokenSet.put("NVL", 60);
    tokenSet.put("NULLIF", 67);
    tokenSet.put("CONVERT", 61);
    tokenSet.put("CAST", 107);
    tokenSet.put("NEXT", 71);
    tokenSet.put("CASE", 68);
    tokenSet.put("WHEN", 110);
    tokenSet.put("THEN", 111);
    tokenSet.put("ELSE", 112);
    tokenSet.put("END", 113);
    tokenSet.put("CASEWHEN", 62);
    tokenSet.put("COALESCE", 69);
    tokenSet.put("EXTRACT", 63);
    tokenSet.put("POSITION", 64);
    tokenSet.put("FROM", 124);
    tokenSet.put("TRIM", 65);
    tokenSet.put("SUBSTRING", 66);
    tokenSet.put("FOR", 123);
    tokenSet.put("AS", 122);
    tokenSet.put("IS", 109);
    tokenSet.put("?", 9);
    noParameters = new Expression[0];
    noSubqueries = new SubQuery[0];
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.Parser
 * JD-Core Version:    0.6.0
 */