package org.hsqldb;

import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.StringConverter;

class TriggerDef extends Thread
{
  static final int NUM_TRIGGER_OPS = 3;
  static final int NUM_TRIGS = 12;
  HsqlNameManager.HsqlName name;
  String when;
  String operation;
  boolean forEachRow;
  boolean nowait;
  int maxRowsQueued;
  protected static int defaultQueueSize = 1024;
  Table table;
  Trigger trigger;
  String triggerClassName;
  int vectorIndex;
  protected HsqlDeque pendingQueue;
  protected int rowsQueued;
  protected boolean valid = true;
  protected volatile boolean keepGoing = true;

  public static int getDefaultQueueSize()
  {
    return defaultQueueSize;
  }

  public TriggerDef(HsqlNameManager.HsqlName paramHsqlName, String paramString1, String paramString2, boolean paramBoolean1, Table paramTable, String paramString3, boolean paramBoolean2, int paramInt, ClassLoader paramClassLoader)
    throws HsqlException
  {
    this.name = paramHsqlName;
    this.when = paramString1;
    this.operation = paramString2;
    this.forEachRow = paramBoolean1;
    this.nowait = paramBoolean2;
    this.maxRowsQueued = paramInt;
    this.table = paramTable;
    this.vectorIndex = SqlToIndex();
    this.triggerClassName = paramString3;
    this.rowsQueued = 0;
    this.pendingQueue = new HsqlDeque();
    if (this.vectorIndex < 0)
      throw Trace.error(11, 204);
    Class localClass;
    try
    {
      localClass = paramClassLoader == null ? Class.forName(paramString3) : paramClassLoader.loadClass(paramString3);
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      this.valid = false;
      localClass = DefaultTrigger.class;
    }
    try
    {
      this.trigger = ((Trigger)localClass.newInstance());
    }
    catch (Exception localException)
    {
      this.valid = false;
      localClass = DefaultTrigger.class;
    }
  }

  public StringBuffer getDDL()
  {
    StringBuffer localStringBuffer = new StringBuffer(256);
    localStringBuffer.append("CREATE").append(' ');
    localStringBuffer.append("TRIGGER").append(' ');
    localStringBuffer.append(this.name.statementName).append(' ');
    localStringBuffer.append(this.when).append(' ');
    localStringBuffer.append(this.operation).append(' ');
    localStringBuffer.append("ON").append(' ');
    localStringBuffer.append(this.table.getName().statementName).append(' ');
    if (this.forEachRow)
    {
      localStringBuffer.append("FOR").append(' ');
      localStringBuffer.append("EACH").append(' ');
      localStringBuffer.append("ROW").append(' ');
    }
    if (this.nowait)
      localStringBuffer.append("NOWAIT").append(' ');
    if (this.maxRowsQueued != getDefaultQueueSize())
    {
      localStringBuffer.append("QUEUE").append(' ');
      localStringBuffer.append(this.maxRowsQueued).append(' ');
    }
    localStringBuffer.append("CALL").append(' ');
    localStringBuffer.append(StringConverter.toQuotedString(this.triggerClassName, '"', false));
    return localStringBuffer;
  }

  public int SqlToIndex()
  {
    int i;
    if (this.operation.equals("INSERT"))
      i = 0;
    else if (this.operation.equals("DELETE"))
      i = 1;
    else if (this.operation.equals("UPDATE"))
      i = 2;
    else
      return -1;
    if (this.when.equals("BEFORE"))
      i += 3;
    else if (!this.when.equals("AFTER"))
      return -1;
    if (this.forEachRow)
      i += 6;
    return i;
  }

  public static int indexToRight(int paramInt)
  {
    switch (paramInt)
    {
    case 1:
    case 4:
    case 7:
    case 10:
      return 2;
    case 0:
    case 3:
    case 6:
    case 9:
      return 4;
    case 2:
    case 5:
    case 8:
    case 11:
      return 8;
    }
    return 0;
  }

  public void run()
  {
    while (this.keepGoing)
    {
      TriggerData localTriggerData = popPair();
      if ((localTriggerData == null) || (localTriggerData.username == null))
        continue;
      this.trigger.fire(this.vectorIndex, this.name.name, this.table.getName().name, localTriggerData.oldRow, localTriggerData.newRow);
    }
  }

  public synchronized void start()
  {
    if (this.maxRowsQueued != 0)
      super.start();
  }

  public synchronized void terminate()
  {
    this.keepGoing = false;
    notify();
  }

  synchronized TriggerData popPair()
  {
    if (this.rowsQueued == 0)
      try
      {
        wait();
      }
      catch (InterruptedException localInterruptedException)
      {
      }
    this.rowsQueued -= 1;
    notify();
    if (this.pendingQueue.size() == 0)
      return null;
    return (TriggerData)this.pendingQueue.removeFirst();
  }

  synchronized void pushPair(Session paramSession, Object[] paramArrayOfObject1, Object[] paramArrayOfObject2)
  {
    if (this.maxRowsQueued == 0)
    {
      this.trigger.fire(this.vectorIndex, this.name.name, this.table.getName().name, paramArrayOfObject1, paramArrayOfObject2);
      return;
    }
    if (this.rowsQueued >= this.maxRowsQueued)
    {
      if (this.nowait)
      {
        this.pendingQueue.removeLast();
      }
      else
      {
        try
        {
          wait();
        }
        catch (InterruptedException localInterruptedException)
        {
        }
        this.rowsQueued += 1;
      }
    }
    else
      this.rowsQueued += 1;
    this.pendingQueue.add(new TriggerData(paramSession, paramArrayOfObject1, paramArrayOfObject2));
    notify();
  }

  public boolean isBusy()
  {
    return this.rowsQueued != 0;
  }

  public boolean isValid()
  {
    return this.valid;
  }

  static class DefaultTrigger
    implements Trigger
  {
    public void fire(int paramInt, String paramString1, String paramString2, Object[] paramArrayOfObject1, Object[] paramArrayOfObject2)
    {
      throw new RuntimeException("Missing Trigger class!");
    }
  }

  class TriggerData
  {
    public Object[] oldRow;
    public Object[] newRow;
    public String username;

    public TriggerData(Session paramArrayOfObject1, Object[] paramArrayOfObject2, Object[] arg4)
    {
      this.oldRow = paramArrayOfObject2;
      Object localObject;
      this.newRow = localObject;
      this.username = paramArrayOfObject1.getUsername();
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.TriggerDef
 * JD-Core Version:    0.6.0
 */