package org.hsqldb;

import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;

class View extends Table
{
  Select viewSelect;
  SubQuery viewSubQuery;
  private String statement;
  private HsqlNameManager.HsqlName[] colList;
  HsqlNameManager.HsqlName compileTimeSchema;
  SubQuery[] viewSubqueries;

  View(Session paramSession, Database paramDatabase, HsqlNameManager.HsqlName paramHsqlName, String paramString, HsqlNameManager.HsqlName[] paramArrayOfHsqlName)
    throws HsqlException
  {
    super(paramDatabase, paramHsqlName, 7);
    this.isReadOnly = true;
    this.colList = paramArrayOfHsqlName;
    this.statement = trimStatement(paramString);
    this.compileTimeSchema = paramSession.getSchemaHsqlName(null);
    compile(paramSession);
    replaceAsterisksInStatement();
    HsqlNameManager.HsqlName[] arrayOfHsqlName = getSchemas();
    for (int i = 0; i < arrayOfHsqlName.length; i++)
    {
      if ((paramDatabase.schemaManager.isSystemSchema(arrayOfHsqlName[i])) || (arrayOfHsqlName[i].equals(paramHsqlName.schema)))
        continue;
      throw Trace.error(227);
    }
  }

  static String trimStatement(String paramString)
    throws HsqlException
  {
    Tokenizer localTokenizer = new Tokenizer(paramString);
    int i;
    String str;
    do
    {
      i = localTokenizer.getPosition();
      str = localTokenizer.getString();
    }
    while ((str.length() != 0) || (localTokenizer.wasValue()));
    return paramString.substring(0, i).trim();
  }

  void compile(Session paramSession)
    throws HsqlException
  {
    Parser localParser = new Parser(paramSession, this.database, new Tokenizer(this.statement));
    localParser.setCompilingView();
    int i = localParser.parseOpenBracketsSelect();
    this.viewSubQuery = localParser.parseSubquery(i, this.colList, true, 115);
    localParser.setAsView(this);
    this.viewSubqueries = localParser.getSortedSubqueries();
    this.viewSelect = this.viewSubQuery.select;
    this.viewSelect.prepareResult(paramSession);
    Result.ResultMetaData localResultMetaData = this.viewSelect.resultMetaData;
    int j = this.viewSelect.iResultLen;
    if (this.columnCount == 0)
      super.addColumns(localResultMetaData, j);
  }

  String getStatement()
  {
    return this.statement;
  }

  private void collectAsteriskPos(Select paramSelect, HsqlArrayList paramHsqlArrayList)
  {
    if (paramSelect.asteriskPositions == null)
      return;
    Iterator localIterator = paramSelect.asteriskPositions.keySet().iterator();
    while (localIterator.hasNext())
    {
      int i = localIterator.nextInt();
      paramHsqlArrayList.set(i, paramSelect.asteriskPositions.get(i));
    }
  }

  private void replaceAsterisksInStatement()
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    localHsqlArrayList.setSize(this.statement.length());
    for (int i = 0; i < this.viewSubqueries.length; i++)
    {
      Select localSelect = this.viewSubqueries[i].select;
      collectAsteriskPos(localSelect, localHsqlArrayList);
      if (localSelect.unionArray == null)
        continue;
      for (int k = 1; k < localSelect.unionArray.length; k++)
        collectAsteriskPos(localSelect.unionArray[k], localHsqlArrayList);
    }
    StringBuffer localStringBuffer = new StringBuffer(this.statement);
    for (int j = localHsqlArrayList.size() - 1; j >= 0; j--)
    {
      String str = (String)localHsqlArrayList.get(j);
      if (str == null)
        continue;
      localStringBuffer.replace(j, localStringBuffer.indexOf("*", j) + 1, str);
    }
    this.statement = localStringBuffer.toString();
  }

  void setDataReadOnly(boolean paramBoolean)
    throws HsqlException
  {
    throw Trace.error(55);
  }

  HsqlNameManager.HsqlName[] getSchemas()
  {
    HsqlArrayList localHsqlArrayList = new HsqlArrayList();
    for (int i = 0; i < this.viewSubqueries.length; i++)
      for (Select localSelect = this.viewSubqueries[i].select; localSelect != null; localSelect = localSelect.unionSelect)
      {
        TableFilter[] arrayOfTableFilter = localSelect.tFilter;
        for (int j = 0; j < arrayOfTableFilter.length; j++)
          localHsqlArrayList.add(arrayOfTableFilter[j].filterTable.tableName.schema);
      }
    return (HsqlNameManager.HsqlName[])localHsqlArrayList.toArray(new HsqlNameManager.HsqlName[localHsqlArrayList.size()]);
  }

  boolean hasView(View paramView)
  {
    if (paramView == this)
      return false;
    for (int i = 0; i < this.viewSubqueries.length; i++)
      if (this.viewSubqueries[i].view == paramView)
        return true;
    return false;
  }

  boolean hasTable(Table paramTable)
  {
    for (int i = 0; i < this.viewSubqueries.length; i++)
      for (Select localSelect = this.viewSubqueries[i].select; localSelect != null; localSelect = localSelect.unionSelect)
      {
        TableFilter[] arrayOfTableFilter = localSelect.tFilter;
        for (int j = 0; j < arrayOfTableFilter.length; j++)
          if (paramTable.equals(arrayOfTableFilter[j].filterTable.tableName))
            return true;
      }
    return false;
  }

  boolean hasColumn(Table paramTable, String paramString)
  {
    if (hasTable(paramTable))
    {
      Expression.Collector localCollector = new Expression.Collector();
      localCollector.addAll(this.viewSubqueries[(this.viewSubqueries.length - 1)].select, 2);
      Iterator localIterator = localCollector.iterator();
      while (localIterator.hasNext())
      {
        Expression localExpression = (Expression)localIterator.next();
        if ((paramString.equals(localExpression.getBaseColumnName())) && (paramTable.equals(localExpression.getTableHsqlName())))
          return true;
      }
    }
    return false;
  }

  boolean hasSequence(NumberSequence paramNumberSequence)
  {
    Expression.Collector localCollector = new Expression.Collector();
    localCollector.addAll(this.viewSubqueries[(this.viewSubqueries.length - 1)].select, 71);
    Iterator localIterator = localCollector.iterator();
    while (localIterator.hasNext())
    {
      Expression localExpression = (Expression)localIterator.next();
      if (localExpression.valueData == paramNumberSequence)
        return true;
    }
    return false;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.View
 * JD-Core Version:    0.6.0
 */