package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.lib.AsciiStringInputStream;

public final class jdbcClob
  implements Clob
{
  volatile String data;

  public jdbcClob(String paramString)
    throws SQLException
  {
    if (paramString == null)
      throw Util.sqlException(62, "null");
    this.data = paramString;
  }

  public long length()
    throws SQLException
  {
    String str = this.data;
    return str.length();
  }

  public String getSubString(long paramLong, int paramInt)
    throws SQLException
  {
    String str = this.data;
    int i = str.length();
    paramLong -= 1L;
    if ((paramLong < 0L) || (paramLong > i))
      Util.sqlException(62, "pos: " + (paramLong + 1L));
    if ((paramInt < 0) || (paramInt > i - paramLong))
      throw Util.sqlException(62, "length: " + paramInt);
    if ((paramLong == 0L) && (paramInt == i))
      return str;
    return str.substring((int)paramLong, (int)paramLong + paramInt);
  }

  public Reader getCharacterStream()
    throws SQLException
  {
    String str = this.data;
    return new StringReader(str);
  }

  public InputStream getAsciiStream()
    throws SQLException
  {
    String str = this.data;
    return new AsciiStringInputStream(str);
  }

  public long position(String paramString, long paramLong)
    throws SQLException
  {
    if ((paramString == null) || (paramLong > 2147483647L))
      return -1L;
    String str = this.data;
    int i = str.indexOf(paramString, (int)(--paramLong));
    return i + 1;
  }

  public long position(Clob paramClob, long paramLong)
    throws SQLException
  {
    if (paramClob == null)
      return -1L;
    String str1 = this.data;
    long l1 = str1.length();
    long l2 = paramClob.length();
    paramLong -= 1L;
    if (paramLong > l1 - l2)
      return -1L;
    String str2;
    if ((paramClob instanceof jdbcClob))
      str2 = ((jdbcClob)paramClob).data;
    else
      str2 = paramClob.getSubString(1L, (int)l2);
    int i = str1.indexOf(str2, (int)paramLong);
    return i + 1;
  }

  public int setString(long paramLong, String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public int setString(long paramLong, String paramString, int paramInt1, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public OutputStream setAsciiStream(long paramLong)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Writer setCharacterStream(long paramLong)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void truncate(long paramLong)
    throws SQLException
  {
    String str = this.data;
    long l1 = str.length();
    long l2 = paramLong >> 1;
    if (l2 != l1)
    {
      if ((paramLong < 0L) || (l2 > l1))
        throw Util.sqlException(62, Long.toString(paramLong));
      this.data = new String(str.substring(0, (int)l2));
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcClob
 * JD-Core Version:    0.6.0
 */