package org.hsqldb.jdbc;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.hsqldb.jdbcDriver;

public class jdbcDataSource
  implements Serializable, Referenceable, DataSource
{
  private int loginTimeout = 0;
  private transient PrintWriter logWriter;
  private String password = "";
  private String user = "";
  private String database = "";

  public Connection getConnection()
    throws SQLException
  {
    return getConnection(this.user, this.password);
  }

  public Connection getConnection(String paramString1, String paramString2)
    throws SQLException
  {
    Properties localProperties = new Properties();
    if (paramString1 != null)
      localProperties.put("user", paramString1);
    if (paramString2 != null)
      localProperties.put("password", paramString2);
    return jdbcDriver.getConnection(this.database, localProperties);
  }

  public String getDatabase()
  {
    return this.database;
  }

  public int getLoginTimeout()
    throws SQLException
  {
    return 0;
  }

  public PrintWriter getLogWriter()
    throws SQLException
  {
    return this.logWriter;
  }

  public Reference getReference()
    throws NamingException
  {
    String str = "org.hsqldb.jdbc.jdbcDataSourceFactory";
    Reference localReference = new Reference(getClass().getName(), str, null);
    localReference.add(new StringRefAddr("database", getDatabase()));
    localReference.add(new StringRefAddr("user", getUser()));
    localReference.add(new StringRefAddr("password", this.password));
    return localReference;
  }

  public String getUser()
  {
    return this.user;
  }

  public void setDatabase(String paramString)
  {
    this.database = paramString;
  }

  public void setLoginTimeout(int paramInt)
    throws SQLException
  {
    this.loginTimeout = 0;
  }

  public void setLogWriter(PrintWriter paramPrintWriter)
    throws SQLException
  {
    this.logWriter = paramPrintWriter;
  }

  public void setPassword(String paramString)
  {
    this.password = paramString;
  }

  public void setUser(String paramString)
  {
    this.user = paramString;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcDataSource
 * JD-Core Version:    0.6.0
 */