package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.lib.AsciiStringInputStream;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class jdbcResultSet
  implements ResultSet
{
  boolean autoClose;
  public Result rResult;
  private Record nCurrent;
  private int iCurrentRow;
  private int iUpdateCount;
  private boolean bInit;
  int iColumnCount;
  private boolean bWasNull;
  private ResultSetMetaData rsmd;
  private HsqlProperties connProperties;
  private boolean isNetConn;
  jdbcStatement sqlStatement;
  int rsType = 1003;
  public static final int FETCH_FORWARD = 1000;
  public static final int FETCH_REVERSE = 1001;
  public static final int FETCH_UNKNOWN = 1002;
  public static final int TYPE_FORWARD_ONLY = 1003;
  public static final int TYPE_SCROLL_INSENSITIVE = 1004;
  public static final int TYPE_SCROLL_SENSITIVE = 1005;
  public static final int CONCUR_READ_ONLY = 1007;
  public static final int CONCUR_UPDATABLE = 1008;
  public static final int HOLD_CURSORS_OVER_COMMIT = 1;
  public static final int CLOSE_CURSORS_AT_COMMIT = 2;

  public boolean next()
    throws SQLException
  {
    this.bWasNull = false;
    if ((this.rResult == null) || (this.rResult.isEmpty()))
      return false;
    if (!this.bInit)
    {
      this.nCurrent = this.rResult.rRoot;
      this.bInit = true;
      this.iCurrentRow = 1;
    }
    else
    {
      if (this.nCurrent == null)
        return false;
      this.nCurrent = this.nCurrent.next;
      this.iCurrentRow += 1;
    }
    if (this.nCurrent == null)
    {
      this.iCurrentRow = (this.rResult.getSize() + 1);
      return false;
    }
    return true;
  }

  public void close()
    throws SQLException
  {
    this.iUpdateCount = -1;
    this.rResult = null;
    if (this.autoClose)
      this.sqlStatement.close();
  }

  public boolean wasNull()
    throws SQLException
  {
    return this.bWasNull;
  }

  public String getString(int paramInt)
    throws SQLException
  {
    return (String)getColumnInType(paramInt, 1);
  }

  public boolean getBoolean(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, 16);
    return localObject == null ? false : ((Boolean)localObject).booleanValue();
  }

  public byte getByte(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, -6);
    return localObject == null ? 0 : ((Number)localObject).byteValue();
  }

  public short getShort(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, 5);
    return localObject == null ? 0 : ((Number)localObject).shortValue();
  }

  public int getInt(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, 4);
    return localObject == null ? 0 : ((Number)localObject).intValue();
  }

  public long getLong(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, -5);
    return localObject == null ? 0L : ((Number)localObject).longValue();
  }

  public float getFloat(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, 7);
    return localObject == null ? 0.0F : ((Number)localObject).floatValue();
  }

  public double getDouble(int paramInt)
    throws SQLException
  {
    Object localObject = getColumnInType(paramInt, 8);
    return localObject == null ? 0.0D : ((Number)localObject).doubleValue();
  }

  /** @deprecated */
  public BigDecimal getBigDecimal(int paramInt1, int paramInt2)
    throws SQLException
  {
    BigDecimal localBigDecimal = (BigDecimal)getColumnInType(paramInt1, 3);
    if (paramInt2 < 0)
      throw Util.sqlException(62);
    if (localBigDecimal != null)
      localBigDecimal = localBigDecimal.setScale(paramInt2, 5);
    return localBigDecimal;
  }

  public byte[] getBytes(int paramInt)
    throws SQLException
  {
    Object localObject = getObject(paramInt);
    if (localObject == null)
      return null;
    if ((localObject instanceof byte[]))
      return (byte[])localObject;
    if ((localObject instanceof String))
      return ((String)localObject).getBytes();
    localObject = getColumnInType(paramInt, -2);
    return (byte[])localObject;
  }

  public java.sql.Date getDate(int paramInt)
    throws SQLException
  {
    return (java.sql.Date)getColumnInType(paramInt, 91);
  }

  public Time getTime(int paramInt)
    throws SQLException
  {
    return (Time)getColumnInType(paramInt, 92);
  }

  public Timestamp getTimestamp(int paramInt)
    throws SQLException
  {
    return (Timestamp)getColumnInType(paramInt, 93);
  }

  public InputStream getAsciiStream(int paramInt)
    throws SQLException
  {
    String str = getString(paramInt);
    if (str == null)
      return null;
    return new AsciiStringInputStream(str);
  }

  /** @deprecated */
  public InputStream getUnicodeStream(int paramInt)
    throws SQLException
  {
    String str = getString(paramInt);
    if (str == null)
      return null;
    return new StringInputStream(str);
  }

  public InputStream getBinaryStream(int paramInt)
    throws SQLException
  {
    byte[] arrayOfByte = getBytes(paramInt);
    return wasNull() ? null : new ByteArrayInputStream(arrayOfByte);
  }

  public String getString(String paramString)
    throws SQLException
  {
    return getString(findColumn(paramString));
  }

  public boolean getBoolean(String paramString)
    throws SQLException
  {
    return getBoolean(findColumn(paramString));
  }

  public byte getByte(String paramString)
    throws SQLException
  {
    return getByte(findColumn(paramString));
  }

  public short getShort(String paramString)
    throws SQLException
  {
    return getShort(findColumn(paramString));
  }

  public int getInt(String paramString)
    throws SQLException
  {
    return getInt(findColumn(paramString));
  }

  public long getLong(String paramString)
    throws SQLException
  {
    return getLong(findColumn(paramString));
  }

  public float getFloat(String paramString)
    throws SQLException
  {
    return getFloat(findColumn(paramString));
  }

  public double getDouble(String paramString)
    throws SQLException
  {
    return getDouble(findColumn(paramString));
  }

  /** @deprecated */
  public BigDecimal getBigDecimal(String paramString, int paramInt)
    throws SQLException
  {
    return getBigDecimal(findColumn(paramString), paramInt);
  }

  public byte[] getBytes(String paramString)
    throws SQLException
  {
    return getBytes(findColumn(paramString));
  }

  public java.sql.Date getDate(String paramString)
    throws SQLException
  {
    return getDate(findColumn(paramString));
  }

  public Time getTime(String paramString)
    throws SQLException
  {
    return getTime(findColumn(paramString));
  }

  public Timestamp getTimestamp(String paramString)
    throws SQLException
  {
    return getTimestamp(findColumn(paramString));
  }

  public InputStream getAsciiStream(String paramString)
    throws SQLException
  {
    return getAsciiStream(findColumn(paramString));
  }

  /** @deprecated */
  public InputStream getUnicodeStream(String paramString)
    throws SQLException
  {
    return getUnicodeStream(findColumn(paramString));
  }

  public InputStream getBinaryStream(String paramString)
    throws SQLException
  {
    return getBinaryStream(findColumn(paramString));
  }

  public SQLWarning getWarnings()
    throws SQLException
  {
    return null;
  }

  public void clearWarnings()
    throws SQLException
  {
  }

  public String getCursorName()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public ResultSetMetaData getMetaData()
    throws SQLException
  {
    if (this.rsmd == null)
      this.rsmd = new jdbcResultSetMetaData(this, this.connProperties);
    return this.rsmd;
  }

  public Object getObject(int paramInt)
    throws SQLException
  {
    checkAvailable();
    Object localObject;
    int i;
    try
    {
      paramInt--;
      localObject = this.nCurrent.data[paramInt];
      i = this.rResult.metaData.colTypes[paramInt];
    }
    catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException)
    {
      paramInt++;
      throw Util.sqlException(28, String.valueOf(paramInt));
    }
    if (checkNull(localObject))
      return null;
    switch (i)
    {
    case 91:
      return new java.sql.Date(((java.sql.Date)localObject).getTime());
    case 92:
      return new Time(((Time)localObject).getTime());
    case 93:
      long l = ((Timestamp)localObject).getTime();
      int j = ((Timestamp)localObject).getNanos();
      Timestamp localTimestamp = new Timestamp(l);
      localTimestamp.setNanos(j);
      return localTimestamp;
    case 1111:
    case 2000:
      try
      {
        return ((JavaObject)localObject).getObject();
      }
      catch (HsqlException localHsqlException)
      {
        throw Util.sqlException(Trace.error(18));
      }
    case -4:
    case -3:
    case -2:
      return ((Binary)localObject).getClonedBytes();
    }
    return localObject;
  }

  public Object getObject(String paramString)
    throws SQLException
  {
    return getObject(findColumn(paramString));
  }

  public int findColumn(String paramString)
    throws SQLException
  {
    for (int i = 0; i < this.iColumnCount; i++)
    {
      String str = this.rResult.metaData.colLabels[i];
      if (paramString.equalsIgnoreCase(str))
        return i + 1;
    }
    throw Util.sqlException(28, paramString);
  }

  public Reader getCharacterStream(int paramInt)
    throws SQLException
  {
    String str = getString(paramInt);
    if (str == null)
      return null;
    return new StringReader(str);
  }

  public Reader getCharacterStream(String paramString)
    throws SQLException
  {
    return getCharacterStream(findColumn(paramString));
  }

  public BigDecimal getBigDecimal(int paramInt)
    throws SQLException
  {
    return (BigDecimal)getColumnInType(paramInt, 3);
  }

  public BigDecimal getBigDecimal(String paramString)
    throws SQLException
  {
    return getBigDecimal(findColumn(paramString));
  }

  public boolean isBeforeFirst()
    throws SQLException
  {
    checkClosed();
    return (this.rResult.rRoot != null) && (!this.bInit);
  }

  public boolean isAfterLast()
    throws SQLException
  {
    checkClosed();
    return (this.rResult.rRoot != null) && (this.bInit) && (this.nCurrent == null);
  }

  public boolean isFirst()
    throws SQLException
  {
    checkClosed();
    return this.iCurrentRow == 1;
  }

  public boolean isLast()
    throws SQLException
  {
    checkClosed();
    return (this.rResult.rRoot != null) && (this.bInit) && (this.nCurrent != null) && (this.nCurrent.next == null);
  }

  public void beforeFirst()
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    this.bInit = false;
    this.nCurrent = null;
    this.iCurrentRow = 0;
  }

  public void afterLast()
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    if ((this.rResult != null) && (this.rResult.rRoot != null))
    {
      this.bInit = true;
      this.iCurrentRow = (this.rResult.getSize() + 1);
      this.nCurrent = null;
    }
  }

  public boolean first()
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    if (this.rResult == null)
      return false;
    this.bInit = false;
    if (this.rResult.rRoot != null)
    {
      this.bInit = true;
      this.nCurrent = this.rResult.rRoot;
      this.iCurrentRow = 1;
    }
    return this.bInit;
  }

  public boolean last()
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    if (this.rResult == null)
      return false;
    if (this.rResult.rRoot == null)
      return false;
    if ((!this.bInit) || (this.nCurrent == null))
      first();
    while (this.nCurrent.next != null)
    {
      this.iCurrentRow += 1;
      this.nCurrent = this.nCurrent.next;
    }
    return true;
  }

  public int getRow()
    throws SQLException
  {
    checkClosed();
    return this.iCurrentRow;
  }

  public boolean absolute(int paramInt)
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    if (this.rResult == null)
      return false;
    if ((this.rResult.rRoot == null) || (paramInt == 0))
      return false;
    switch (paramInt)
    {
    case 1:
      return first();
    case -1:
      return last();
    }
    if (paramInt < 0)
    {
      last();
      paramInt = this.iCurrentRow + paramInt + 1;
      if (paramInt <= 0)
      {
        beforeFirst();
        return false;
      }
    }
    if ((paramInt < this.iCurrentRow) || (this.iCurrentRow == 0))
      beforeFirst();
    while (paramInt > this.iCurrentRow)
    {
      next();
      if (this.nCurrent != null)
        continue;
    }
    return this.nCurrent != null;
  }

  public boolean relative(int paramInt)
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    if (this.rResult == null)
      return false;
    if (this.rResult.rRoot == null)
      return false;
    if (paramInt < 0)
    {
      paramInt = this.iCurrentRow + paramInt;
      beforeFirst();
      if (paramInt <= 0)
        return false;
    }
    while (paramInt-- > 0)
    {
      next();
      if (this.nCurrent != null)
        continue;
    }
    return this.nCurrent != null;
  }

  public boolean previous()
    throws SQLException
  {
    checkClosed();
    if (getType() == 1003)
      throw Util.sqlException(51);
    if ((this.rResult == null) || (this.rResult.rRoot == null) || (this.iCurrentRow == 0))
      return false;
    if ((this.bInit) && (this.nCurrent == null))
      return last();
    int i = this.iCurrentRow - 1;
    if (i == 0)
    {
      beforeFirst();
      return false;
    }
    first();
    while (i != this.iCurrentRow)
    {
      this.nCurrent = this.nCurrent.next;
      this.iCurrentRow += 1;
    }
    return this.nCurrent != null;
  }

  public void setFetchDirection(int paramInt)
    throws SQLException
  {
    checkClosed();
    if ((this.rsType == 1003) && (paramInt != 1000))
      throw Util.notSupported();
  }

  public int getFetchDirection()
    throws SQLException
  {
    checkClosed();
    return 1000;
  }

  public void setFetchSize(int paramInt)
    throws SQLException
  {
    if (paramInt < 0)
      throw Util.sqlException(62);
  }

  public int getFetchSize()
    throws SQLException
  {
    checkClosed();
    return 1;
  }

  public int getType()
    throws SQLException
  {
    checkClosed();
    return this.rsType;
  }

  public int getConcurrency()
    throws SQLException
  {
    checkClosed();
    return 1007;
  }

  public boolean rowUpdated()
    throws SQLException
  {
    checkClosed();
    return false;
  }

  public boolean rowInserted()
    throws SQLException
  {
    checkClosed();
    return false;
  }

  public boolean rowDeleted()
    throws SQLException
  {
    checkClosed();
    return false;
  }

  public void updateNull(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateBoolean(int paramInt, boolean paramBoolean)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateByte(int paramInt, byte paramByte)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateShort(int paramInt, short paramShort)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateInt(int paramInt1, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateLong(int paramInt, long paramLong)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateFloat(int paramInt, float paramFloat)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateDouble(int paramInt, double paramDouble)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateBigDecimal(int paramInt, BigDecimal paramBigDecimal)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateString(int paramInt, String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateBytes(int paramInt, byte[] paramArrayOfByte)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateDate(int paramInt, java.sql.Date paramDate)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateTime(int paramInt, Time paramTime)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateTimestamp(int paramInt, Timestamp paramTimestamp)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateAsciiStream(int paramInt1, InputStream paramInputStream, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateBinaryStream(int paramInt1, InputStream paramInputStream, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateCharacterStream(int paramInt1, Reader paramReader, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateObject(int paramInt1, Object paramObject, int paramInt2)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateObject(int paramInt, Object paramObject)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateNull(String paramString)
    throws SQLException
  {
    updateNull(findColumn(paramString));
  }

  public void updateBoolean(String paramString, boolean paramBoolean)
    throws SQLException
  {
    updateBoolean(findColumn(paramString), paramBoolean);
  }

  public void updateByte(String paramString, byte paramByte)
    throws SQLException
  {
    updateByte(findColumn(paramString), paramByte);
  }

  public void updateShort(String paramString, short paramShort)
    throws SQLException
  {
    updateShort(findColumn(paramString), paramShort);
  }

  public void updateInt(String paramString, int paramInt)
    throws SQLException
  {
    updateInt(findColumn(paramString), paramInt);
  }

  public void updateLong(String paramString, long paramLong)
    throws SQLException
  {
    updateLong(findColumn(paramString), paramLong);
  }

  public void updateFloat(String paramString, float paramFloat)
    throws SQLException
  {
    updateFloat(findColumn(paramString), paramFloat);
  }

  public void updateDouble(String paramString, double paramDouble)
    throws SQLException
  {
    updateDouble(findColumn(paramString), paramDouble);
  }

  public void updateBigDecimal(String paramString, BigDecimal paramBigDecimal)
    throws SQLException
  {
    updateBigDecimal(findColumn(paramString), paramBigDecimal);
  }

  public void updateString(String paramString1, String paramString2)
    throws SQLException
  {
    updateString(findColumn(paramString1), paramString2);
  }

  public void updateBytes(String paramString, byte[] paramArrayOfByte)
    throws SQLException
  {
    updateBytes(findColumn(paramString), paramArrayOfByte);
  }

  public void updateDate(String paramString, java.sql.Date paramDate)
    throws SQLException
  {
    updateDate(findColumn(paramString), paramDate);
  }

  public void updateTime(String paramString, Time paramTime)
    throws SQLException
  {
    updateTime(findColumn(paramString), paramTime);
  }

  public void updateTimestamp(String paramString, Timestamp paramTimestamp)
    throws SQLException
  {
    updateTimestamp(findColumn(paramString), paramTimestamp);
  }

  public void updateAsciiStream(String paramString, InputStream paramInputStream, int paramInt)
    throws SQLException
  {
    updateAsciiStream(findColumn(paramString), paramInputStream, paramInt);
  }

  public void updateBinaryStream(String paramString, InputStream paramInputStream, int paramInt)
    throws SQLException
  {
    updateBinaryStream(findColumn(paramString), paramInputStream, paramInt);
  }

  public void updateCharacterStream(String paramString, Reader paramReader, int paramInt)
    throws SQLException
  {
    updateCharacterStream(findColumn(paramString), paramReader, paramInt);
  }

  public void updateObject(String paramString, Object paramObject, int paramInt)
    throws SQLException
  {
    updateObject(findColumn(paramString), paramObject, paramInt);
  }

  public void updateObject(String paramString, Object paramObject)
    throws SQLException
  {
    updateObject(findColumn(paramString), paramObject);
  }

  public void insertRow()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateRow()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void deleteRow()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void refreshRow()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void cancelRowUpdates()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void moveToInsertRow()
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void moveToCurrentRow()
    throws SQLException
  {
  }

  public Statement getStatement()
    throws SQLException
  {
    return this.sqlStatement;
  }

  public Object getObject(int paramInt, Map paramMap)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Ref getRef(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Blob getBlob(int paramInt)
    throws SQLException
  {
    byte[] arrayOfByte = getBytes(paramInt);
    return arrayOfByte == null ? null : new jdbcBlob(arrayOfByte);
  }

  public Clob getClob(int paramInt)
    throws SQLException
  {
    String str = getString(paramInt);
    return str == null ? null : new jdbcClob(str);
  }

  public Array getArray(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public Object getObject(String paramString, Map paramMap)
    throws SQLException
  {
    return getObject(findColumn(paramString), paramMap);
  }

  public Ref getRef(String paramString)
    throws SQLException
  {
    return getRef(findColumn(paramString));
  }

  public Blob getBlob(String paramString)
    throws SQLException
  {
    return getBlob(findColumn(paramString));
  }

  public Clob getClob(String paramString)
    throws SQLException
  {
    return getClob(findColumn(paramString));
  }

  public Array getArray(String paramString)
    throws SQLException
  {
    return getArray(findColumn(paramString));
  }

  public java.sql.Date getDate(int paramInt, Calendar paramCalendar)
    throws SQLException
  {
    java.sql.Date localDate = getDate(paramInt);
    if (localDate == null)
      return null;
    if (paramCalendar == null)
      return localDate;
    paramCalendar.setTime(localDate);
    HsqlDateTime.resetToDate(paramCalendar);
    return new java.sql.Date(paramCalendar.getTime().getTime());
  }

  public java.sql.Date getDate(String paramString, Calendar paramCalendar)
    throws SQLException
  {
    return getDate(findColumn(paramString), paramCalendar);
  }

  public Time getTime(int paramInt, Calendar paramCalendar)
    throws SQLException
  {
    Time localTime = getTime(paramInt);
    if (localTime == null)
      return null;
    if (paramCalendar == null)
      return localTime;
    paramCalendar.setTime(localTime);
    HsqlDateTime.resetToTime(paramCalendar);
    return new Time(paramCalendar.getTime().getTime());
  }

  public Time getTime(String paramString, Calendar paramCalendar)
    throws SQLException
  {
    return getTime(findColumn(paramString), paramCalendar);
  }

  public Timestamp getTimestamp(int paramInt, Calendar paramCalendar)
    throws SQLException
  {
    Timestamp localTimestamp = getTimestamp(paramInt);
    if ((paramCalendar != null) && (localTimestamp != null))
      localTimestamp.setTime(HsqlDateTime.getTimeInMillis(localTimestamp, null, paramCalendar));
    return localTimestamp;
  }

  public Timestamp getTimestamp(String paramString, Calendar paramCalendar)
    throws SQLException
  {
    return getTimestamp(findColumn(paramString), paramCalendar);
  }

  public URL getURL(int paramInt)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public URL getURL(String paramString)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateRef(int paramInt, Ref paramRef)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateRef(String paramString, Ref paramRef)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateBlob(int paramInt, Blob paramBlob)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateBlob(String paramString, Blob paramBlob)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateClob(int paramInt, Clob paramClob)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateClob(String paramString, Clob paramClob)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateArray(int paramInt, Array paramArray)
    throws SQLException
  {
    throw Util.notSupported();
  }

  public void updateArray(String paramString, Array paramArray)
    throws SQLException
  {
    throw Util.notSupported();
  }

  private void checkAvailable()
    throws SQLException
  {
    if ((this.rResult == null) || (!this.bInit) || (this.nCurrent == null))
      throw Util.sqlException(35);
  }

  private void checkClosed()
    throws SQLException
  {
    if ((this.rResult == null) || ((this.sqlStatement != null) && (this.sqlStatement.isClosed)))
      throw Util.sqlException(158);
  }

  void checkColumn(int paramInt)
    throws SQLException
  {
    if ((paramInt < 1) || (paramInt > this.iColumnCount))
      throw Util.sqlException(28, String.valueOf(paramInt));
  }

  private boolean checkNull(Object paramObject)
  {
    if (paramObject == null)
    {
      this.bWasNull = true;
      return true;
    }
    this.bWasNull = false;
    return false;
  }

  private Object getColumnInType(int paramInt1, int paramInt2)
    throws SQLException
  {
    checkAvailable();
    int i;
    Object localObject;
    try
    {
      paramInt1--;
      i = this.rResult.metaData.colTypes[paramInt1];
      localObject = this.nCurrent.data[paramInt1];
    }
    catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException)
    {
      paramInt1++;
      throw Util.sqlException(28, String.valueOf(paramInt1));
    }
    if (checkNull(localObject))
      return null;
    if (i != paramInt2)
    {
      if (((localObject instanceof Binary)) && (paramInt2 != 1))
        throw Util.sqlException(16);
      try
      {
        localObject = Column.convertObject(localObject, paramInt2);
      }
      catch (Exception localException)
      {
        String str = "type: " + Types.getTypeString(i) + " (" + i + ") expected: " + Types.getTypeString(paramInt2) + " value: " + localObject.toString();
        throw Util.sqlException(16, str);
      }
    }
    switch (paramInt2)
    {
    case 91:
      return new java.sql.Date(((java.sql.Date)localObject).getTime());
    case 92:
      return new Time(((Time)localObject).getTime());
    case 93:
      long l = ((Timestamp)localObject).getTime();
      int j = ((Timestamp)localObject).getNanos();
      Timestamp localTimestamp = new Timestamp(l);
      localTimestamp.setNanos(j);
      return localTimestamp;
    }
    return localObject;
  }

  jdbcResultSet(jdbcStatement paramjdbcStatement, Result paramResult, HsqlProperties paramHsqlProperties, boolean paramBoolean)
    throws SQLException
  {
    this.sqlStatement = paramjdbcStatement;
    this.connProperties = paramHsqlProperties;
    this.isNetConn = paramBoolean;
    if (paramResult.mode == 1)
    {
      this.iUpdateCount = paramResult.getUpdateCount();
    }
    else if (paramResult.isError())
    {
      Util.throwError(paramResult);
    }
    else
    {
      if (paramjdbcStatement != null)
        this.rsType = paramjdbcStatement.rsType;
      this.iUpdateCount = -1;
      this.rResult = paramResult;
      this.iColumnCount = paramResult.getColumnCount();
    }
    this.bWasNull = false;
  }

  int getUpdateCount()
  {
    return this.iUpdateCount;
  }

  boolean isResult()
  {
    return this.rResult != null;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.jdbc.jdbcResultSet
 * JD-Core Version:    0.6.0
 */