package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UTFDataFormatException;

public class StringConverter
{
  private static final byte[] HEXBYTES = { 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102 };
  private static final String HEXINDEX = "0123456789abcdef0123456789ABCDEF";

  byte[] stringToFullByteArray(String paramString)
  {
    int i = paramString.length();
    byte[] arrayOfByte = new byte[i * 2];
    for (int k = 0; k < i; k++)
    {
      int j = paramString.charAt(k);
      arrayOfByte[(k * 2)] = (byte)((j & 0xFF00) >> 8);
      arrayOfByte[(k * 2 + 1)] = (byte)(j & 0xFF);
    }
    return arrayOfByte;
  }

  public static byte[] hexToByte(String paramString)
    throws IOException
  {
    int i = paramString.length() / 2;
    byte[] arrayOfByte = new byte[i];
    int j = 0;
    if (paramString.length() % 2 != 0)
      throw new IOException("hexadecimal string with odd number of characters");
    for (int k = 0; k < i; k++)
    {
      int m = paramString.charAt(j++);
      int n = "0123456789abcdef0123456789ABCDEF".indexOf(m);
      if (n == -1)
        throw new IOException("hexadecimal string contains non hex character");
      int i1 = (n & 0xF) << 4;
      m = paramString.charAt(j++);
      n = "0123456789abcdef0123456789ABCDEF".indexOf(m);
      i1 += (n & 0xF);
      arrayOfByte[k] = (byte)i1;
    }
    return arrayOfByte;
  }

  public static String byteToHex(byte[] paramArrayOfByte)
  {
    int i = paramArrayOfByte.length;
    char[] arrayOfChar = new char[i * 2];
    int j = 0;
    int k = 0;
    while (j < i)
    {
      int m = paramArrayOfByte[j] & 0xFF;
      arrayOfChar[(k++)] = (char)HEXBYTES[(m >> 4 & 0xF)];
      arrayOfChar[(k++)] = (char)HEXBYTES[(m & 0xF)];
      j++;
    }
    return new String(arrayOfChar);
  }

  public static void writeHex(byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2)
  {
    int i = paramArrayOfByte2.length;
    for (int j = 0; j < i; j++)
    {
      int k = paramArrayOfByte2[j] & 0xFF;
      paramArrayOfByte1[(paramInt++)] = HEXBYTES[(k >> 4 & 0xF)];
      paramArrayOfByte1[(paramInt++)] = HEXBYTES[(k & 0xF)];
    }
  }

  public static String byteToString(byte[] paramArrayOfByte, String paramString)
  {
    try
    {
      return paramString == null ? new String(paramArrayOfByte) : new String(paramArrayOfByte, paramString);
    }
    catch (Exception localException)
    {
    }
    return null;
  }

  public static String unicodeToHexString(String paramString)
  {
    HsqlByteArrayOutputStream localHsqlByteArrayOutputStream = new HsqlByteArrayOutputStream();
    writeUTF(paramString, localHsqlByteArrayOutputStream);
    return byteToHex(localHsqlByteArrayOutputStream.toByteArray());
  }

  public static int unicodeToAscii(HsqlByteArrayOutputStream paramHsqlByteArrayOutputStream, String paramString, boolean paramBoolean)
  {
    int i = 0;
    if ((paramString == null) || (paramString.length() == 0))
      return 0;
    int j = paramString.length();
    for (int k = 0; k < j; k++)
    {
      int m = paramString.charAt(k);
      if (m == 92)
      {
        if ((k < j - 1) && (paramString.charAt(k + 1) == 'u'))
        {
          paramHsqlByteArrayOutputStream.write(m);
          paramHsqlByteArrayOutputStream.write(117);
          paramHsqlByteArrayOutputStream.write(48);
          paramHsqlByteArrayOutputStream.write(48);
          paramHsqlByteArrayOutputStream.write(53);
          paramHsqlByteArrayOutputStream.write(99);
          i += 6;
        }
        else
        {
          paramHsqlByteArrayOutputStream.write(m);
          i++;
        }
      }
      else if ((m >= 32) && (m <= 127))
      {
        paramHsqlByteArrayOutputStream.write(m);
        i++;
        if ((m != 39) || (!paramBoolean))
          continue;
        paramHsqlByteArrayOutputStream.write(m);
        i++;
      }
      else
      {
        paramHsqlByteArrayOutputStream.write(92);
        paramHsqlByteArrayOutputStream.write(117);
        paramHsqlByteArrayOutputStream.write(HEXBYTES[(m >> 12 & 0xF)]);
        paramHsqlByteArrayOutputStream.write(HEXBYTES[(m >> 8 & 0xF)]);
        paramHsqlByteArrayOutputStream.write(HEXBYTES[(m >> 4 & 0xF)]);
        paramHsqlByteArrayOutputStream.write(HEXBYTES[(m & 0xF)]);
        i += 6;
      }
    }
    return i;
  }

  public static String asciiToUnicode(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
  {
    if (paramInt2 == 0)
      return "";
    char[] arrayOfChar = new char[paramInt2];
    int i = 0;
    for (int j = 0; j < paramInt2; j++)
    {
      int k = paramArrayOfByte[(paramInt1 + j)];
      if ((k == 92) && (j < paramInt2 - 5))
      {
        int m = paramArrayOfByte[(paramInt1 + j + 1)];
        if (m == 117)
        {
          j++;
          j++;
          int n = "0123456789abcdef0123456789ABCDEF".indexOf(paramArrayOfByte[(paramInt1 + j)]) << 12;
          j++;
          n += ("0123456789abcdef0123456789ABCDEF".indexOf(paramArrayOfByte[(paramInt1 + j)]) << 8);
          j++;
          n += ("0123456789abcdef0123456789ABCDEF".indexOf(paramArrayOfByte[(paramInt1 + j)]) << 4);
          j++;
          n += "0123456789abcdef0123456789ABCDEF".indexOf(paramArrayOfByte[(paramInt1 + j)]);
          arrayOfChar[(i++)] = (char)n;
        }
        else
        {
          arrayOfChar[(i++)] = (char)k;
        }
      }
      else
      {
        arrayOfChar[(i++)] = (char)k;
      }
    }
    return new String(arrayOfChar, 0, i);
  }

  public static String asciiToUnicode(String paramString)
  {
    if ((paramString == null) || (paramString.indexOf("\\u") == -1))
      return paramString;
    int i = paramString.length();
    char[] arrayOfChar = new char[i];
    int j = 0;
    for (int k = 0; k < i; k++)
    {
      int m = paramString.charAt(k);
      if ((m == 92) && (k < i - 5))
      {
        int n = paramString.charAt(k + 1);
        if (n == 117)
        {
          k++;
          k++;
          int i1 = "0123456789abcdef0123456789ABCDEF".indexOf(paramString.charAt(k)) << 12;
          k++;
          i1 += ("0123456789abcdef0123456789ABCDEF".indexOf(paramString.charAt(k)) << 8);
          k++;
          i1 += ("0123456789abcdef0123456789ABCDEF".indexOf(paramString.charAt(k)) << 4);
          k++;
          i1 += "0123456789abcdef0123456789ABCDEF".indexOf(paramString.charAt(k));
          arrayOfChar[(j++)] = (char)i1;
        }
        else
        {
          arrayOfChar[(j++)] = m;
        }
      }
      else
      {
        arrayOfChar[(j++)] = m;
      }
    }
    return new String(arrayOfChar, 0, j);
  }

  public static String readUTF(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
    throws IOException
  {
    char[] arrayOfChar = new char[paramInt2];
    return readUTF(paramArrayOfByte, paramInt1, paramInt2, arrayOfChar);
  }

  public static String readUTF(byte[] paramArrayOfByte, int paramInt1, int paramInt2, char[] paramArrayOfChar)
    throws IOException
  {
    int i = 0;
    int n = 0;
    while (n < paramInt2)
    {
      int j = paramArrayOfByte[(paramInt1 + n)];
      if (i == paramArrayOfChar.length)
        paramArrayOfChar = (char[])ArrayUtil.resizeArray(paramArrayOfChar, paramInt2);
      if (j > 0)
      {
        n++;
        paramArrayOfChar[(i++)] = (char)j;
        continue;
      }
      j &= 255;
      int k;
      switch (j >> 4)
      {
      case 12:
      case 13:
        n += 2;
        if (n > paramInt2)
          throw new UTFDataFormatException();
        k = paramArrayOfByte[(paramInt1 + n - 1)];
        if ((k & 0xC0) != 128)
          throw new UTFDataFormatException();
        paramArrayOfChar[(i++)] = (char)((j & 0x1F) << 6 | k & 0x3F);
        break;
      case 14:
        n += 3;
        if (n > paramInt2)
          throw new UTFDataFormatException();
        k = paramArrayOfByte[(paramInt1 + n - 2)];
        int m = paramArrayOfByte[(paramInt1 + n - 1)];
        if (((k & 0xC0) != 128) || ((m & 0xC0) != 128))
          throw new UTFDataFormatException();
        paramArrayOfChar[(i++)] = (char)((j & 0xF) << 12 | (k & 0x3F) << 6 | (m & 0x3F) << 0);
        break;
      default:
        throw new UTFDataFormatException();
      }
    }
    return new String(paramArrayOfChar, 0, i);
  }

  public static int writeUTF(String paramString, HsqlByteArrayOutputStream paramHsqlByteArrayOutputStream)
  {
    int i = paramString.length();
    int k = 0;
    for (int m = 0; m < i; m++)
    {
      int j = paramString.charAt(m);
      if ((j >= 1) && (j <= 127))
      {
        paramHsqlByteArrayOutputStream.write(j);
        k++;
      }
      else if (j > 2047)
      {
        paramHsqlByteArrayOutputStream.write(0xE0 | j >> 12 & 0xF);
        paramHsqlByteArrayOutputStream.write(0x80 | j >> 6 & 0x3F);
        paramHsqlByteArrayOutputStream.write(0x80 | j >> 0 & 0x3F);
        k += 3;
      }
      else
      {
        paramHsqlByteArrayOutputStream.write(0xC0 | j >> 6 & 0x1F);
        paramHsqlByteArrayOutputStream.write(0x80 | j >> 0 & 0x3F);
        k += 2;
      }
    }
    return k;
  }

  public static int getUTFSize(String paramString)
  {
    int i = paramString == null ? 0 : paramString.length();
    int j = 0;
    for (int k = 0; k < i; k++)
    {
      int m = paramString.charAt(k);
      if ((m >= 1) && (m <= 127))
        j++;
      else if (m > 2047)
        j += 3;
      else
        j += 2;
    }
    return j;
  }

  public static String inputStreamToString(InputStream paramInputStream, int paramInt)
    throws IOException
  {
    InputStreamReader localInputStreamReader = new InputStreamReader(paramInputStream);
    StringWriter localStringWriter = new StringWriter();
    int i = 8192;
    char[] arrayOfChar = new char[i];
    int j = paramInt;
    while (j > 0)
    {
      int k = localInputStreamReader.read(arrayOfChar, 0, j > i ? i : j);
      if (k == -1)
        break;
      localStringWriter.write(arrayOfChar, 0, k);
      j -= k;
    }
    localStringWriter.close();
    return localStringWriter.toString();
  }

  public static String toQuotedString(String paramString, char paramChar, boolean paramBoolean)
  {
    if (paramString == null)
      return null;
    int i = paramBoolean ? count(paramString, paramChar) : 0;
    int j = paramString.length();
    char[] arrayOfChar = new char[2 + i + j];
    int k = 0;
    int m = 0;
    arrayOfChar[(m++)] = paramChar;
    while (k < j)
    {
      char c = paramString.charAt(k);
      arrayOfChar[(m++)] = c;
      if ((paramBoolean) && (c == paramChar))
        arrayOfChar[(m++)] = c;
      k++;
    }
    arrayOfChar[m] = paramChar;
    return new String(arrayOfChar);
  }

  static int count(String paramString, char paramChar)
  {
    int i = 0;
    int j = 0;
    if (paramString != null)
      while ((i = paramString.indexOf(paramChar, i)) > -1)
      {
        j++;
        i++;
      }
    return j;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.lib.StringConverter
 * JD-Core Version:    0.6.0
 */