package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.Trace;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Sort;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.store.ObjectCacheHashMap;
import org.hsqldb.store.ObjectCacheHashMap.ObjectCacheIterator;

public class Cache
{
  final DataFileCache dataFileCache;
  private int capacity;
  private long bytesCapacity;
  private final CachedObjectComparator rowComparator;
  private CachedObject[] rowTable;
  private final ObjectCacheHashMap cacheMap;
  long cacheBytesLength;
  StopWatch saveAllTimer = new StopWatch(false);
  StopWatch makeRowTimer = new StopWatch(false);
  StopWatch sortTimer = new StopWatch(false);
  int makeRowCount = 0;
  int saveRowCount = 0;

  Cache(DataFileCache paramDataFileCache)
  {
    this.dataFileCache = paramDataFileCache;
    this.capacity = paramDataFileCache.capacity();
    this.bytesCapacity = paramDataFileCache.bytesCapacity();
    this.rowComparator = new CachedObjectComparator();
    this.rowTable = new CachedObject[this.capacity];
    this.cacheMap = new ObjectCacheHashMap(this.capacity);
    this.cacheBytesLength = 0L;
  }

  void init(int paramInt, long paramLong)
  {
  }

  int size()
  {
    return this.cacheMap.size();
  }

  long getTotalCachedBlockSize()
  {
    return this.cacheBytesLength;
  }

  synchronized CachedObject get(int paramInt)
  {
    return (CachedObject)this.cacheMap.get(paramInt);
  }

  synchronized void put(int paramInt, CachedObject paramCachedObject)
    throws IOException
  {
    int i = paramCachedObject.getStorageSize();
    if ((this.cacheMap.size() >= this.capacity) || (i + this.cacheBytesLength > this.bytesCapacity))
      cleanUp();
    this.cacheMap.put(paramInt, paramCachedObject);
    this.cacheBytesLength += i;
  }

  synchronized CachedObject release(int paramInt)
  {
    CachedObject localCachedObject = (CachedObject)this.cacheMap.remove(paramInt);
    if (localCachedObject == null)
      return null;
    this.cacheBytesLength -= localCachedObject.getStorageSize();
    return localCachedObject;
  }

  private synchronized void cleanUp()
    throws IOException
  {
    int i = this.cacheMap.size() / 2;
    int j = this.cacheMap.getAccessCountCeiling(i, i / 8);
    ObjectCacheHashMap.ObjectCacheIterator localObjectCacheIterator = this.cacheMap.iterator();
    int k = 0;
    while (localObjectCacheIterator.hasNext())
    {
      CachedObject localCachedObject = (CachedObject)localObjectCacheIterator.next();
      if ((localObjectCacheIterator.getAccessCount() > j) || (localCachedObject.isKeepInMemory()))
        continue;
      if (localCachedObject.hasChanged())
        this.rowTable[(k++)] = localCachedObject;
      localObjectCacheIterator.remove();
      this.cacheBytesLength -= localCachedObject.getStorageSize();
    }
    this.cacheMap.setAccessCountFloor(j);
    saveRows(k);
  }

  private synchronized void saveRows(int paramInt)
    throws IOException
  {
    if (paramInt == 0)
      return;
    this.rowComparator.setType(1);
    this.sortTimer.start();
    Sort.sort(this.rowTable, this.rowComparator, 0, paramInt - 1);
    this.sortTimer.stop();
    this.saveAllTimer.start();
    this.dataFileCache.saveRows(this.rowTable, 0, paramInt);
    this.saveRowCount += paramInt;
    this.saveAllTimer.stop();
  }

  synchronized void saveAll()
    throws IOException
  {
    ObjectCacheHashMap.ObjectCacheIterator localObjectCacheIterator = this.cacheMap.iterator();
    int i = 0;
    while (localObjectCacheIterator.hasNext())
    {
      CachedObject localCachedObject = (CachedObject)localObjectCacheIterator.next();
      if (!localCachedObject.hasChanged())
        continue;
      this.rowTable[(i++)] = localCachedObject;
    }
    saveRows(i);
    Trace.printSystemOut(this.saveAllTimer.elapsedTimeToMessage("Cache.saveRow() total row save time"));
    Trace.printSystemOut("Cache.saveRow() total row save count = " + this.saveRowCount);
    Trace.printSystemOut(this.makeRowTimer.elapsedTimeToMessage("Cache.makeRow() total row load time"));
    Trace.printSystemOut("Cache.makeRow() total row load count = " + this.makeRowCount);
    Trace.printSystemOut(this.sortTimer.elapsedTimeToMessage("Cache.sort() total time"));
  }

  synchronized void clear()
  {
    this.cacheMap.clear();
    this.cacheBytesLength = 0L;
  }

  static class CachedObjectComparator
    implements ObjectComparator
  {
    static final int COMPARE_LAST_ACCESS = 0;
    static final int COMPARE_POSITION = 1;
    static final int COMPARE_SIZE = 2;
    private int compareType;

    void setType(int paramInt)
    {
      this.compareType = paramInt;
    }

    public int compare(Object paramObject1, Object paramObject2)
    {
      switch (this.compareType)
      {
      case 1:
        return ((CachedObject)paramObject1).getPos() - ((CachedObject)paramObject2).getPos();
      case 2:
        return ((CachedObject)paramObject1).getStorageSize() - ((CachedObject)paramObject2).getStorageSize();
      }
      return 0;
    }
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.Cache
 * JD-Core Version:    0.6.0
 */