package org.hsqldb.persist;

import java.io.IOException;
import org.hsqldb.rowio.RowInputInterface;

public abstract interface PersistentStore
{
  public static final int INT_STORE_SIZE = 4;
  public static final int LONG_STORE_SIZE = 8;

  public abstract CachedObject get(int paramInt);

  public abstract CachedObject getKeep(int paramInt);

  public abstract int getStorageSize(int paramInt);

  public abstract void add(CachedObject paramCachedObject)
    throws IOException;

  public abstract void restore(CachedObject paramCachedObject)
    throws IOException;

  public abstract CachedObject get(RowInputInterface paramRowInputInterface)
    throws IOException;

  public abstract CachedObject getNewInstance(int paramInt)
    throws IOException;

  public abstract void removePersistence(int paramInt);

  public abstract void remove(int paramInt);

  public abstract void release(int paramInt);

  public abstract void commit(CachedObject paramCachedObject);
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.persist.PersistentStore
 * JD-Core Version:    0.6.0
 */