package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.Binary;
import org.hsqldb.types.JavaObject;

public class RowOutputTextLog extends RowOutputBase
{
  static final byte[] BYTES_NULL = "NULL".getBytes();
  static final byte[] BYTES_TRUE = "TRUE".getBytes();
  static final byte[] BYTES_FALSE = "FALSE".getBytes();
  static final byte[] BYTES_AND = " AND ".getBytes();
  static final byte[] BYTES_IS = " IS ".getBytes();
  public static final int MODE_DELETE = 1;
  public static final int MODE_INSERT = 0;
  private boolean isWritten;
  private int logMode;

  public void setMode(int paramInt)
  {
    this.logMode = paramInt;
  }

  protected void writeFieldPrefix()
  {
    if ((this.logMode == 1) && (this.isWritten))
      write(BYTES_AND);
  }

  protected void writeChar(String paramString, int paramInt)
  {
    write(39);
    StringConverter.unicodeToAscii(this, paramString, true);
    write(39);
  }

  protected void writeReal(Double paramDouble, int paramInt)
  {
    writeBytes(Column.createSQLString(paramDouble.doubleValue()));
  }

  protected void writeSmallint(Number paramNumber)
  {
    writeBytes(paramNumber.toString());
  }

  public void writeEnd()
  {
  }

  protected void writeTime(Time paramTime)
  {
    write(39);
    writeBytes(paramTime.toString());
    write(39);
  }

  protected void writeBinary(Binary paramBinary, int paramInt)
  {
    ensureRoom(paramBinary.getBytesLength() * 2 + 2);
    write(39);
    StringConverter.writeHex(getBuffer(), this.count, paramBinary.getBytes());
    this.count += paramBinary.getBytesLength() * 2;
    write(39);
  }

  public void writeType(int paramInt)
  {
  }

  public void writeSize(int paramInt)
  {
  }

  protected void writeDate(Date paramDate)
  {
    write(39);
    writeBytes(paramDate.toString());
    write(39);
  }

  public int getSize(CachedRow paramCachedRow)
  {
    return 0;
  }

  protected void writeInteger(Number paramNumber)
  {
    writeBytes(paramNumber.toString());
  }

  protected void writeBigint(Number paramNumber)
  {
    writeBytes(paramNumber.toString());
  }

  protected void writeNull(int paramInt)
  {
    if (this.logMode == 1)
      write(BYTES_IS);
    else if (this.isWritten)
      write(44);
    this.isWritten = true;
    write(BYTES_NULL);
  }

  protected void writeOther(JavaObject paramJavaObject)
  {
    ensureRoom(paramJavaObject.getBytesLength() * 2 + 2);
    write(39);
    StringConverter.writeHex(getBuffer(), this.count, paramJavaObject.getBytes());
    this.count += paramJavaObject.getBytesLength() * 2;
    write(39);
  }

  public void writeString(String paramString)
  {
    StringConverter.unicodeToAscii(this, paramString, false);
  }

  protected void writeBit(Boolean paramBoolean)
  {
    write(paramBoolean.booleanValue() ? BYTES_TRUE : BYTES_FALSE);
  }

  protected void writeDecimal(BigDecimal paramBigDecimal)
  {
    writeBytes(paramBigDecimal.toString());
  }

  protected void writeFieldType(int paramInt)
  {
    if (this.logMode == 1)
      write(61);
    else if (this.isWritten)
      write(44);
    this.isWritten = true;
  }

  public void writeLongData(long paramLong)
  {
    writeBytes(Long.toString(paramLong));
  }

  public void writeIntData(int paramInt1, int paramInt2)
  {
  }

  protected void writeTimestamp(Timestamp paramTimestamp)
  {
    write(39);
    writeBytes(HsqlDateTime.getTimestampString(paramTimestamp));
    write(39);
  }

  public void writeShortData(short paramShort)
  {
    writeBytes(Integer.toString(paramShort));
  }

  public void writeIntData(int paramInt)
  {
    writeBytes(Integer.toString(paramInt));
  }

  public void reset()
  {
    super.reset();
    this.isWritten = false;
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.rowio.RowOutputTextLog
 * JD-Core Version:    0.6.0
 */