package org.hsqldb.scriptio;

import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager.HsqlName;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.rowio.RowOutputTextLog;

public class ScriptWriterText extends ScriptWriterBase
{
  RowOutputTextLog rowOut;
  public static final byte[] BYTES_LINE_SEP;
  static final byte[] BYTES_COMMIT;
  static final byte[] BYTES_INSERT_INTO;
  static final byte[] BYTES_VALUES;
  static final byte[] BYTES_TERM;
  static final byte[] BYTES_DELETE_FROM;
  static final byte[] BYTES_WHERE;
  static final byte[] BYTES_SEQUENCE;
  static final byte[] BYTES_SEQUENCE_MID;
  static final byte[] BYTES_C_ID_INIT;
  static final byte[] BYTES_C_ID_TERM;
  static final byte[] BYTES_SCHEMA;

  ScriptWriterText()
  {
  }

  public ScriptWriterText(Database paramDatabase, String paramString, boolean paramBoolean1, boolean paramBoolean2, boolean paramBoolean3)
    throws HsqlException
  {
    super(paramDatabase, paramString, paramBoolean1, paramBoolean2, paramBoolean3);
  }

  protected void initBuffers()
  {
    this.rowOut = new RowOutputTextLog();
  }

  protected void writeDataTerm()
    throws IOException
  {
  }

  protected void addSessionId(Session paramSession)
    throws IOException
  {
    if (paramSession == null)
      return;
    if (paramSession != this.currentSession)
    {
      this.rowOut.write(BYTES_C_ID_INIT);
      this.rowOut.writeIntData(paramSession.getId());
      this.rowOut.write(BYTES_C_ID_TERM);
      this.currentSession = paramSession;
    }
    if (this.schemaToLog != paramSession.loggedSchema)
    {
      writeSchemaStatement(this.schemaToLog);
      paramSession.loggedSchema = this.schemaToLog;
    }
  }

  private void writeSchemaStatement(HsqlNameManager.HsqlName paramHsqlName)
  {
    this.rowOut.write(BYTES_SCHEMA);
    this.rowOut.writeString(paramHsqlName.statementName);
    this.rowOut.write(BYTES_LINE_SEP);
  }

  public void writeLogStatement(Session paramSession, String paramString)
    throws IOException, HsqlException
  {
    this.schemaToLog = paramSession.currentSchema;
    this.busyWriting = true;
    this.rowOut.reset();
    addSessionId(paramSession);
    this.rowOut.writeString(paramString);
    this.rowOut.write(BYTES_LINE_SEP);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.byteCount += this.rowOut.size();
    this.needsSync = true;
    this.busyWriting = false;
    if ((this.forceSync) || (this.writeDelay == 0))
      sync();
  }

  protected void writeRow(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException
  {
    this.busyWriting = true;
    this.rowOut.reset();
    this.rowOut.setMode(0);
    addSessionId(paramSession);
    this.rowOut.write(BYTES_INSERT_INTO);
    this.rowOut.writeString(paramTable.getName().statementName);
    this.rowOut.write(BYTES_VALUES);
    this.rowOut.writeData(paramArrayOfObject, paramTable);
    this.rowOut.write(BYTES_TERM);
    this.rowOut.write(BYTES_LINE_SEP);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.byteCount += this.rowOut.size();
    this.needsSync |= paramSession.isAutoCommit();
    this.busyWriting = false;
    if ((this.forceSync) || (this.writeDelay == 0))
      sync();
  }

  protected void writeTableInit(Table paramTable)
    throws HsqlException, IOException
  {
    if (paramTable.isEmpty(this.currentSession))
      return;
    if (this.schemaToLog == this.currentSession.loggedSchema)
      return;
    this.rowOut.reset();
    writeSchemaStatement(paramTable.getName().schema);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.currentSession.loggedSchema = this.schemaToLog;
  }

  public void writeInsertStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException
  {
    this.schemaToLog = paramTable.getName().schema;
    writeRow(paramSession, paramTable, paramArrayOfObject);
  }

  public void writeDeleteStatement(Session paramSession, Table paramTable, Object[] paramArrayOfObject)
    throws HsqlException, IOException
  {
    this.schemaToLog = paramTable.getName().schema;
    this.busyWriting = true;
    this.rowOut.reset();
    this.rowOut.setMode(1);
    addSessionId(paramSession);
    this.rowOut.write(BYTES_DELETE_FROM);
    this.rowOut.writeString(paramTable.getName().statementName);
    this.rowOut.write(BYTES_WHERE);
    this.rowOut.writeData(paramTable.getColumnCount(), paramTable.getColumnTypes(), paramArrayOfObject, paramTable.columnList, paramTable.getPrimaryKey());
    this.rowOut.write(BYTES_LINE_SEP);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.byteCount += this.rowOut.size();
    this.needsSync |= paramSession.isAutoCommit();
    this.busyWriting = false;
    if ((this.forceSync) || (this.writeDelay == 0))
      sync();
  }

  public void writeSequenceStatement(Session paramSession, NumberSequence paramNumberSequence)
    throws HsqlException, IOException
  {
    this.schemaToLog = paramNumberSequence.getName().schema;
    this.busyWriting = true;
    this.rowOut.reset();
    addSessionId(paramSession);
    this.rowOut.write(BYTES_SEQUENCE);
    this.rowOut.writeString(paramNumberSequence.getName().statementName);
    this.rowOut.write(BYTES_SEQUENCE_MID);
    this.rowOut.writeLongData(paramNumberSequence.peek());
    this.rowOut.write(BYTES_LINE_SEP);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.byteCount += this.rowOut.size();
    this.needsSync = true;
    this.busyWriting = false;
    if ((this.forceSync) || (this.writeDelay == 0))
      sync();
  }

  public void writeCommitStatement(Session paramSession)
    throws HsqlException, IOException
  {
    this.busyWriting = true;
    this.rowOut.reset();
    addSessionId(paramSession);
    this.rowOut.write(BYTES_COMMIT);
    this.rowOut.write(BYTES_LINE_SEP);
    this.fileStreamOut.write(this.rowOut.getBuffer(), 0, this.rowOut.size());
    this.byteCount += this.rowOut.size();
    this.needsSync = true;
    this.busyWriting = false;
    if ((this.forceSync) || (this.writeDelay == 0))
      sync();
  }

  protected void finalize()
  {
    sync();
  }

  static
  {
    String str = System.getProperty("line.separator", "\n");
    BYTES_LINE_SEP = str.getBytes();
    BYTES_COMMIT = "COMMIT".getBytes();
    BYTES_INSERT_INTO = "INSERT INTO ".getBytes();
    BYTES_VALUES = " VALUES(".getBytes();
    BYTES_TERM = ")".getBytes();
    BYTES_DELETE_FROM = "DELETE FROM ".getBytes();
    BYTES_WHERE = " WHERE ".getBytes();
    BYTES_SEQUENCE = "ALTER SEQUENCE ".getBytes();
    BYTES_SEQUENCE_MID = " RESTART WITH ".getBytes();
    BYTES_C_ID_INIT = "/*C".getBytes();
    BYTES_C_ID_TERM = "*/".getBytes();
    BYTES_SCHEMA = "SET SCHEMA ".getBytes();
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.scriptio.ScriptWriterText
 * JD-Core Version:    0.6.0
 */