package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.hsqldb.lib.java.JavaSystem;

public class ScriptTool
{
  private static Properties pProperties = new Properties();
  private Connection cConn;
  private Statement sStatement;
  private boolean BATCH = true;
  private String EKW = new String("go");
  private boolean EOF = false;
  private int ln = 0;

  public static void main(String[] paramArrayOfString)
  {
    for (int i = 0; i < paramArrayOfString.length; i++)
    {
      String str = paramArrayOfString[i];
      if (!str.equals("-?"))
        continue;
      printHelp();
      System.exit(0);
    }
    ScriptTool localScriptTool = new ScriptTool();
    localScriptTool.execute(paramArrayOfString);
    System.exit(0);
  }

  public void execute(String[] paramArrayOfString)
  {
    for (int i = 0; i < paramArrayOfString.length; i++)
    {
      localObject = paramArrayOfString[i];
      if (((String)localObject).charAt(0) != '-')
        continue;
      pProperties.put(((String)localObject).substring(1), paramArrayOfString[(i + 1)]);
      i++;
    }
    this.ln = 0;
    this.EOF = false;
    BufferedReader localBufferedReader = null;
    Object localObject = pProperties;
    String str1 = ((Properties)localObject).getProperty("driver", "org.hsqldb.jdbcDriver");
    String str2 = ((Properties)localObject).getProperty("url", "jdbc:hsqldb:");
    String str3 = ((Properties)localObject).getProperty("database", "test");
    String str4 = ((Properties)localObject).getProperty("user", "sa");
    String str5 = ((Properties)localObject).getProperty("password", "");
    String str6 = ((Properties)localObject).getProperty("script", "st.sql");
    boolean bool = ((Properties)localObject).getProperty("log", "false").equalsIgnoreCase("true");
    this.BATCH = ((Properties)localObject).getProperty("batch", "true").equalsIgnoreCase("true");
    try
    {
      if (bool)
      {
        trace("driver   = " + str1);
        trace("url      = " + str2);
        trace("database = " + str3);
        trace("user     = " + str4);
        trace("password = " + str5);
        trace("script   = " + str6);
        trace("log      = " + bool);
        trace("batch    = " + this.BATCH);
        JavaSystem.setLogToSystem(true);
      }
      Class.forName(str1).newInstance();
      this.cConn = DriverManager.getConnection(str2 + str3, str4, str5);
      localBufferedReader = new BufferedReader(new FileReader(str6));
    }
    catch (Exception localException1)
    {
      System.out.println("ScriptTool.init error: " + localException1.getMessage());
      localException1.printStackTrace();
    }
    try
    {
      this.sStatement = this.cConn.createStatement();
      String str7;
      while ((str7 = fileToString(localBufferedReader)) != null)
      {
        if (str7.length() == 1)
          continue;
        if (bool)
          trace("SQL (" + this.ln + ") : " + str7.substring(0, str7.length() - 2));
        this.sStatement.execute(str7);
        ResultSet localResultSet = this.sStatement.getResultSet();
        int j = this.sStatement.getUpdateCount();
        if (j == -1)
        {
          trace(toString(localResultSet));
          continue;
        }
        trace("update count " + j);
      }
    }
    catch (SQLException localSQLException)
    {
      System.out.println("SQL Error at line " + this.ln + ": " + localSQLException);
    }
    try
    {
      this.cConn.close();
      localBufferedReader.close();
    }
    catch (Exception localException2)
    {
    }
  }

  private String toString(ResultSet paramResultSet)
  {
    try
    {
      if (paramResultSet == null)
        return "No Result";
      ResultSetMetaData localResultSetMetaData = paramResultSet.getMetaData();
      int i = localResultSetMetaData.getColumnCount();
      StringBuffer localStringBuffer = new StringBuffer();
      for (int j = 1; j <= i; j++)
        localStringBuffer = localStringBuffer.append(localResultSetMetaData.getColumnLabel(j) + "\t");
      for (localStringBuffer = localStringBuffer.append("\n"); paramResultSet.next(); localStringBuffer = localStringBuffer.append("\n"))
        for (j = 1; j <= i; j++)
        {
          localStringBuffer = localStringBuffer.append(paramResultSet.getString(j) + "\t");
          if (!paramResultSet.wasNull())
            continue;
          localStringBuffer = localStringBuffer.append("(null)\t");
        }
      return localStringBuffer.toString();
    }
    catch (SQLException localSQLException)
    {
    }
    return null;
  }

  private String fileToString(BufferedReader paramBufferedReader)
  {
    if (this.EOF)
      return null;
    this.EOF = true;
    StringBuffer localStringBuffer = new StringBuffer();
    try
    {
      String str;
      while ((str = paramBufferedReader.readLine()) != null)
      {
        this.ln += 1;
        if (this.BATCH)
        {
          if (str.startsWith("print "))
          {
            trace("\n" + str.substring(5));
            continue;
          }
          if (str.equalsIgnoreCase(this.EKW))
          {
            this.EOF = false;
            break;
          }
        }
        localStringBuffer.append(str);
        localStringBuffer.append('\n');
      }
      localStringBuffer.append('\n');
      return localStringBuffer.toString();
    }
    catch (Exception localException)
    {
      localException.printStackTrace();
    }
    throw new RuntimeException(localException.getMessage());
  }

  private void trace(String paramString)
  {
    System.out.println(paramString);
  }

  private static void printHelp()
  {
    System.out.println("Usage: java ScriptTool [-options]\nwhere options include:\n    -driver <classname>     name of the driver class\n    -url <name>             first part of the jdbc url\n    -database <name>        second part of the jdbc url\n    -user <name>            username used for connection\n    -password <name>        password for this user\n    -log <true/false>       write log to system out\n    -batch <true/false>     allow go/print pseudo statements\n    -script <script file>   reads from script file\n");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.ScriptTool
 * JD-Core Version:    0.6.0
 */