package org.hsqldb.util;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.hsqldb.persist.HsqlProperties;

public class ShutdownServer
{
  public static void main(String[] paramArrayOfString)
  {
    String str1 = "org.hsqldb.jdbcDriver";
    if (paramArrayOfString.length > 0)
    {
      localObject = paramArrayOfString[0];
      if ((localObject != null) && (((String)localObject).startsWith("-?")))
      {
        printHelp();
        return;
      }
    }
    Object localObject = HsqlProperties.argArrayToProps(paramArrayOfString, "server");
    boolean bool = ((HsqlProperties)localObject).isPropertyTrue("server.webserver", false);
    String str5 = bool ? "jdbc:hsqldb:http://localhost" : "jdbc:hsqldb:hsql://localhost";
    int j = bool ? 80 : 9001;
    int i = ((HsqlProperties)localObject).getIntegerProperty("server.port", j);
    String str2 = ((HsqlProperties)localObject).getProperty("server.url", str5 + ":" + i);
    String str3 = ((HsqlProperties)localObject).getProperty("server.user", "sa");
    String str4 = ((HsqlProperties)localObject).getProperty("server.password", "");
    String str6 = ((HsqlProperties)localObject).getProperty("server.shutdownarg", "");
    try
    {
      Class.forName(str1);
      Connection localConnection = DriverManager.getConnection(str2, str3, str4);
      Statement localStatement = localConnection.createStatement();
      localStatement.execute("SHUTDOWN " + str6);
    }
    catch (ClassNotFoundException localClassNotFoundException)
    {
      System.err.println(localClassNotFoundException);
    }
    catch (SQLException localSQLException)
    {
      System.err.println(localSQLException);
    }
  }

  static void printHelp()
  {
    System.out.print("Usage: java ShutdownServer [-options]\nwhere options include:\n    -port <nr>               port where the server is listening\n    -user <name>             username of admin user\n    -password <value>        password of admin user\n    -webserver <true/false>  whether it's a web server\n    -url <value>             server url (overrides -webserver and -port options)\n    -shutdownarg <value>     IMMEDIATELY or COMPACT are allowed\nThe command line arguments override the default values.");
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.ShutdownServer
 * JD-Core Version:    0.6.0
 */