package org.hsqldb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;

public class SqlToolSprayer
{
  public static String LS = System.getProperty("line.separator");
  private static String SYNTAX_MSG = "SYNTAX:  java [-D...] SqlToolSprayer 'SQL;' [urlid1 urlid2...]\nSystem properties you may use [default values]:\n    sqltoolsprayer.period (in ms.) [500]\n    sqltoolsprayer.maxtime (in ms.) [0]\n    sqltoolsprayer.monfile (filepath) [none]\n    sqltoolsprayer.rcfile (filepath) [none.  SqlTool default used.]\n    sqltoolsprayer.propfile (filepath) [none]";

  public static void main(String[] paramArrayOfString)
  {
    if (paramArrayOfString.length < 1)
    {
      System.err.println(SYNTAX_MSG);
      System.exit(4);
    }
    long l1 = System.getProperty("sqltoolsprayer.period") == null ? 500 : Integer.parseInt(System.getProperty("sqltoolsprayer.period"));
    long l2 = System.getProperty("sqltoolsprayer.maxtime") == null ? 0 : Integer.parseInt(System.getProperty("sqltoolsprayer.maxtime"));
    String str1 = System.getProperty("sqltoolsprayer.rcfile");
    String str2 = System.getProperty("sqltoolsprayer.propfile");
    File localFile = System.getProperty("sqltoolsprayer.monfile") == null ? null : new File(System.getProperty("sqltoolsprayer.monfile"));
    ArrayList localArrayList1 = new ArrayList();
    if (str2 != null)
      try
      {
        getUrlsFromPropFile(str2, localArrayList1);
      }
      catch (Exception localException)
      {
        System.err.println("Failed to load property file '" + str2 + "':  " + localException);
        System.exit(3);
      }
    for (int i = 1; i < paramArrayOfString.length; i++)
      localArrayList1.add(paramArrayOfString[i]);
    boolean[] arrayOfBoolean = new boolean[localArrayList1.size()];
    for (int j = 0; j < arrayOfBoolean.length; j++)
      arrayOfBoolean[j] = false;
    String[] arrayOfString1 = { "--sql", paramArrayOfString[0], "--rcfile", str1, null };
    String[] arrayOfString2 = { "--sql", paramArrayOfString[0], null };
    String[] arrayOfString3 = str1 == null ? arrayOfString2 : arrayOfString1;
    int k = 0;
    long l3 = new Date().getTime();
    while (true)
    {
      if ((localFile != null) && (!localFile.exists()))
      {
        System.err.println("Required file is gone:  " + localFile);
        System.exit(2);
      }
      k = 0;
      for (int m = 0; m < arrayOfBoolean.length; m++)
      {
        if (arrayOfBoolean[m] != 0)
          continue;
        arrayOfString3[(arrayOfString3.length - 1)] = ((String)localArrayList1.get(m));
        try
        {
          new SqlTool();
          SqlTool.objectMain(arrayOfString3);
          arrayOfBoolean[m] = true;
          System.err.println("Success for instance '" + localArrayList1.get(m) + "'");
        }
        catch (SqlTool.SqlToolException localSqlToolException)
        {
          k = 1;
        }
      }
      if ((k == 0) || (l2 == 0L) || (new Date().getTime() > l3 + l2))
        break;
      try
      {
        Thread.sleep(l1);
      }
      catch (InterruptedException localInterruptedException)
      {
      }
    }
    ArrayList localArrayList2 = new ArrayList();
    for (int n = 0; n < arrayOfBoolean.length; n++)
    {
      if (arrayOfBoolean[n] == 1)
        continue;
      localArrayList2.add(localArrayList1.get(n));
    }
    if (localArrayList2.size() > 0)
    {
      System.err.println("Failed instances:   " + localArrayList2);
      System.exit(1);
    }
    System.exit(0);
  }

  private static void getUrlsFromPropFile(String paramString, ArrayList paramArrayList)
    throws Exception
  {
    Properties localProperties = new Properties();
    localProperties.load(new FileInputStream(paramString));
    int i = -1;
    while (true)
    {
      i++;
      String str = localProperties.getProperty("server.urlid." + i);
      if (str == null)
        return;
      paramArrayList.add(str);
    }
  }

  static
  {
    if (!LS.equals("\n"))
      SYNTAX_MSG = SYNTAX_MSG.replaceAll("\n", LS);
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.SqlToolSprayer
 * JD-Core Version:    0.6.0
 */