package org.hsqldb.util;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ValidatingResourceBundle
{
  protected boolean validated = false;
  public static final int THROW_BEHAVIOR = 0;
  public static final int EMPTYSTRING_BEHAVIOR = 1;
  public static final int NOOP_BEHAVIOR = 2;
  protected RefCapablePropertyResourceBundle wrappedRCPRB = RefCapablePropertyResourceBundle.getBundle(paramString, getClass().getClassLoader());
  private int missingPropertyBehavior = 0;
  private int missingPosValueBehavior = 0;

  protected abstract Map getKeyIdToString();

  protected ValidatingResourceBundle(String paramString)
  {
  }

  public String getString(int paramInt)
  {
    return this.wrappedRCPRB.getString((String)getKeyIdToString().get(new Integer(paramInt)));
  }

  public String getString(int paramInt, String[] paramArrayOfString)
  {
    return this.wrappedRCPRB.getString((String)getKeyIdToString().get(new Integer(paramInt)), paramArrayOfString, this.missingPosValueBehavior);
  }

  public String getExpandedString(int paramInt)
  {
    return this.wrappedRCPRB.getExpandedString((String)getKeyIdToString().get(new Integer(paramInt)), this.missingPropertyBehavior);
  }

  public String getExpandedString(int paramInt, String[] paramArrayOfString)
  {
    return this.wrappedRCPRB.getExpandedString((String)getKeyIdToString().get(new Integer(paramInt)), paramArrayOfString, this.missingPropertyBehavior, this.missingPosValueBehavior);
  }

  public void setMissingPropertyBehavior(int paramInt)
  {
    this.missingPropertyBehavior = paramInt;
  }

  public void setMissingPosValueBehavior(int paramInt)
  {
    this.missingPosValueBehavior = paramInt;
  }

  public int getMissingPropertyBehavior()
  {
    return this.missingPropertyBehavior;
  }

  public int getMissingPosValueBehavior()
  {
    return this.missingPosValueBehavior;
  }

  public int getSize()
  {
    if (!this.validated)
      throw new RuntimeException("Method SqltoolRB.getSize() may only be called after calling SqltoolRB.validate()");
    return getKeyIdToString().size();
  }

  public void validate()
  {
    if (this.validated)
      return;
    this.validated = true;
    HashSet localHashSet = new HashSet(getKeyIdToString().values());
    if (localHashSet.size() < getKeyIdToString().values().size())
    {
      localObject = getKeyIdToString().values();
      Iterator localIterator = localHashSet.iterator();
      while (localIterator.hasNext())
        ((Collection)localObject).remove(localIterator.next());
      throw new RuntimeException("Duplicate property key(s) string in keyIdToString map: " + localObject);
    }
    Object localObject = this.wrappedRCPRB.getKeys();
    while (((Enumeration)localObject).hasMoreElements())
    {
      String str = (String)((Enumeration)localObject).nextElement();
      this.wrappedRCPRB.getString(str);
      localHashSet.remove(str);
    }
    if (localHashSet.size() > 0)
      throw new RuntimeException("Resource Bundle pre-validation failed.  Following property key(s) not mapped.\n" + localHashSet);
  }

  public String getString(int paramInt, String paramString)
  {
    return getString(paramInt, new String[] { paramString });
  }

  public String getString(int paramInt, String paramString1, String paramString2)
  {
    return getString(paramInt, new String[] { paramString1, paramString2 });
  }

  public String getString(int paramInt, String paramString1, String paramString2, String paramString3)
  {
    return getString(paramInt, new String[] { paramString1, paramString2, paramString3 });
  }

  public String getString(int paramInt1, int paramInt2)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2) });
  }

  public String getString(int paramInt1, int paramInt2, int paramInt3)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2), Integer.toString(paramInt3) });
  }

  public String getString(int paramInt1, int paramInt2, int paramInt3, int paramInt4)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2), Integer.toString(paramInt3), Integer.toString(paramInt4) });
  }

  public String getString(int paramInt1, int paramInt2, String paramString)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2), paramString });
  }

  public String getString(int paramInt1, String paramString, int paramInt2)
  {
    return getString(paramInt1, new String[] { paramString, Integer.toString(paramInt2) });
  }

  public String getString(int paramInt1, int paramInt2, int paramInt3, String paramString)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2), Integer.toString(paramInt3), paramString });
  }

  public String getString(int paramInt1, int paramInt2, String paramString, int paramInt3)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2), paramString, Integer.toString(paramInt3) });
  }

  public String getString(int paramInt1, String paramString, int paramInt2, int paramInt3)
  {
    return getString(paramInt1, new String[] { paramString, Integer.toString(paramInt2), Integer.toString(paramInt3) });
  }

  public String getString(int paramInt1, int paramInt2, String paramString1, String paramString2)
  {
    return getString(paramInt1, new String[] { Integer.toString(paramInt2), paramString1, paramString2 });
  }

  public String getString(int paramInt1, String paramString1, String paramString2, int paramInt2)
  {
    return getString(paramInt1, new String[] { paramString1, paramString2, Integer.toString(paramInt2) });
  }

  public String getString(int paramInt1, String paramString1, int paramInt2, String paramString2)
  {
    return getString(paramInt1, new String[] { paramString1, Integer.toString(paramInt2), paramString2 });
  }
}

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.hsqldb.util.ValidatingResourceBundle
 * JD-Core Version:    0.6.0
 */