/*     */ package org.quartz;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.ArrayList;
/*     */ 
/*     */ public class JobDetail
/*     */   implements Cloneable, Serializable
/*     */ {
/*     */   private String name;
/*  67 */   private String group = "DEFAULT";
/*     */   private String description;
/*     */   private Class jobClass;
/*     */   private JobDataMap jobDataMap;
/*  75 */   private boolean volatility = false;
/*     */ 
/*  77 */   private boolean durability = false;
/*     */ 
/*  79 */   private boolean shouldRecover = false;
/*     */ 
/*  81 */   private ArrayList jobListeners = new ArrayList(2);
/*     */ 
/*     */   public JobDetail()
/*     */   {
/*     */   }
/*     */ 
/*     */   public JobDetail(String name, String group, Class jobClass)
/*     */   {
/* 119 */     setName(name);
/* 120 */     setGroup(group);
/* 121 */     setJobClass(jobClass);
/*     */   }
/*     */ 
/*     */   public JobDetail(String name, String group, Class jobClass, boolean volatility, boolean durability, boolean recover)
/*     */   {
/* 137 */     setName(name);
/* 138 */     setGroup(group);
/* 139 */     setJobClass(jobClass);
/* 140 */     setVolatility(volatility);
/* 141 */     setDurability(durability);
/* 142 */     setRequestsRecovery(recover);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */   {
/* 159 */     return this.name;
/*     */   }
/*     */ 
/*     */   public void setName(String name)
/*     */   {
/* 171 */     if ((name == null) || (name.trim().length() == 0)) {
/* 172 */       throw new IllegalArgumentException("Job name cannot be empty.");
/*     */     }
/* 174 */     this.name = name;
/*     */   }
/*     */ 
/*     */   public String getGroup()
/*     */   {
/* 183 */     return this.group;
/*     */   }
/*     */ 
/*     */   public void setGroup(String group)
/*     */   {
/* 197 */     if ((group != null) && (group.trim().length() == 0)) {
/* 198 */       throw new IllegalArgumentException("Group name cannot be empty.");
/*     */     }
/*     */ 
/* 201 */     if (group == null) {
/* 202 */       group = "DEFAULT";
/*     */     }
/* 204 */     this.group = group;
/*     */   }
/*     */ 
/*     */   public String getFullName()
/*     */   {
/* 214 */     return this.group + "." + this.name;
/*     */   }
/*     */ 
/*     */   public String getDescription()
/*     */   {
/* 226 */     return this.description;
/*     */   }
/*     */ 
/*     */   public void setDescription(String description)
/*     */   {
/* 237 */     this.description = description;
/*     */   }
/*     */ 
/*     */   public Class getJobClass()
/*     */   {
/* 246 */     return this.jobClass;
/*     */   }
/*     */ 
/*     */   public void setJobClass(Class jobClass)
/*     */   {
/* 258 */     if (jobClass == null) {
/* 259 */       throw new IllegalArgumentException("Job class cannot be null.");
/*     */     }
/* 261 */     if (!Job.class.isAssignableFrom(jobClass)) {
/* 262 */       throw new IllegalArgumentException("Job class must implement the Job interface.");
/*     */     }
/*     */ 
/* 265 */     this.jobClass = jobClass;
/*     */   }
/*     */ 
/*     */   public JobDataMap getJobDataMap()
/*     */   {
/* 274 */     if (this.jobDataMap == null) this.jobDataMap = new JobDataMap();
/* 275 */     return this.jobDataMap;
/*     */   }
/*     */ 
/*     */   public void setJobDataMap(JobDataMap jobDataMap)
/*     */   {
/* 284 */     this.jobDataMap = jobDataMap;
/*     */   }
/*     */ 
/*     */   public void validate()
/*     */     throws SchedulerException
/*     */   {
/* 297 */     if (this.name == null) {
/* 298 */       throw new SchedulerException("Job's name cannot be null", 100);
/*     */     }
/*     */ 
/* 301 */     if (this.group == null) {
/* 302 */       throw new SchedulerException("Job's group cannot be null", 100);
/*     */     }
/*     */ 
/* 305 */     if (this.jobClass == null)
/* 306 */       throw new SchedulerException("Job's class cannot be null", 100);
/*     */   }
/*     */ 
/*     */   public void setVolatility(boolean volatility)
/*     */   {
/* 322 */     this.volatility = volatility;
/*     */   }
/*     */ 
/*     */   public void setDurability(boolean durability)
/*     */   {
/* 336 */     this.durability = durability;
/*     */   }
/*     */ 
/*     */   public void setRequestsRecovery(boolean shouldRecover)
/*     */   {
/* 354 */     this.shouldRecover = shouldRecover;
/*     */   }
/*     */ 
/*     */   public boolean isVolatile()
/*     */   {
/* 372 */     return this.volatility;
/*     */   }
/*     */ 
/*     */   public boolean isDurable()
/*     */   {
/* 389 */     return this.durability;
/*     */   }
/*     */ 
/*     */   public boolean isStateful()
/*     */   {
/* 398 */     if (this.jobClass == null) {
/* 399 */       return false;
/*     */     }
/* 401 */     return StatefulJob.class.isAssignableFrom(this.jobClass);
/*     */   }
/*     */ 
/*     */   public boolean requestsRecovery()
/*     */   {
/* 419 */     return this.shouldRecover;
/*     */   }
/*     */ 
/*     */   public void addJobListener(String name)
/*     */   {
/* 429 */     this.jobListeners.add(name);
/*     */   }
/*     */ 
/*     */   public boolean removeJobListener(String name)
/*     */   {
/* 441 */     return this.jobListeners.remove(name);
/*     */   }
/*     */ 
/*     */   public String[] getJobListenerNames()
/*     */   {
/* 452 */     return (String[])this.jobListeners.toArray(new String[this.jobListeners.size()]);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 461 */     return "JobDetail '" + getFullName() + "':  jobClass: '" + (getJobClass() == null ? null : getJobClass().getName()) + " isStateful: " + isStateful() + " isVolatile: " + isVolatile() + " isDurable: " + isDurable() + " requestsRecovers: " + requestsRecovery();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/*     */     try
/*     */     {
/* 471 */       JobDetail copy = (JobDetail)super.clone();
/* 472 */       copy.jobListeners = ((ArrayList)this.jobListeners.clone());
/* 473 */       if (this.jobDataMap != null)
/* 474 */         copy.jobDataMap = ((JobDataMap)this.jobDataMap.clone());
/*     */     } catch (CloneNotSupportedException ex) {
/* 476 */       throw new IncompatibleClassChangeError("Not Cloneable.");
/*     */     }
/*     */     JobDetail copy;
/* 479 */     return copy;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.JobDetail
 * JD-Core Version:    0.6.0
 */