/*      */ package org.quartz.core;
/*      */ 
/*      */ import java.util.ArrayList;
/*      */ import java.util.Collections;
/*      */ import java.util.HashMap;
/*      */ import java.util.List;
/*      */ import org.quartz.JobExecutionContext;
/*      */ import org.quartz.JobExecutionException;
/*      */ import org.quartz.JobListener;
/*      */ import org.quartz.Trigger;
/*      */ 
/*      */ class ExecutingJobsManager
/*      */   implements JobListener
/*      */ {
/* 2030 */   HashMap executingJobs = new HashMap();
/*      */ 
/* 2032 */   int numJobsFired = 0;
/*      */ 
/*      */   public String getName()
/*      */   {
/* 2038 */     return getClass().getName();
/*      */   }
/*      */ 
/*      */   public int getNumJobsCurrentlyExecuting() {
/* 2042 */     synchronized (this.executingJobs) {
/* 2043 */       return this.executingJobs.size();
/*      */     }
/*      */   }
/*      */ 
/*      */   public void jobToBeExecuted(JobExecutionContext context) {
/* 2048 */     this.numJobsFired += 1;
/*      */ 
/* 2050 */     synchronized (this.executingJobs) {
/* 2051 */       this.executingJobs.put(context.getTrigger().getFireInstanceId(), context);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException)
/*      */   {
/* 2058 */     synchronized (this.executingJobs) {
/* 2059 */       this.executingJobs.remove(context.getTrigger().getFireInstanceId());
/*      */     }
/*      */   }
/*      */ 
/*      */   public int getNumJobsFired() {
/* 2064 */     return this.numJobsFired;
/*      */   }
/*      */ 
/*      */   public List getExecutingJobs() {
/* 2068 */     synchronized (this.executingJobs) {
/* 2069 */       return Collections.unmodifiableList(new ArrayList(this.executingJobs.values()));
/*      */     }
/*      */   }
/*      */ 
/*      */   public void jobExecutionVetoed(JobExecutionContext context)
/*      */   {
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.core.ExecutingJobsManager
 * JD-Core Version:    0.6.0
 */