/*     */ package org.quartz.ee.servlet;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import javax.servlet.ServletContext;
/*     */ import javax.servlet.ServletContextEvent;
/*     */ import javax.servlet.ServletContextListener;
/*     */ import org.quartz.Scheduler;
/*     */ import org.quartz.impl.StdSchedulerFactory;
/*     */ 
/*     */ public class QuartzInitializerListener
/*     */   implements ServletContextListener
/*     */ {
/*     */   public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
/* 101 */   private boolean performShutdown = true;
/*     */ 
/* 103 */   private Scheduler scheduler = null;
/*     */ 
/*     */   public void contextInitialized(ServletContextEvent sce)
/*     */   {
/* 115 */     System.out.println("Quartz Initializer Servlet loaded, initializing Scheduler...");
/*     */ 
/* 117 */     ServletContext servletContext = sce.getServletContext();
/*     */     try
/*     */     {
/* 121 */       String configFile = servletContext.getInitParameter("config-file");
/* 122 */       String shutdownPref = servletContext.getInitParameter("shutdown-on-unload");
/*     */ 
/* 124 */       if (shutdownPref != null)
/* 125 */         this.performShutdown = Boolean.valueOf(shutdownPref).booleanValue();
/*     */       StdSchedulerFactory factory;
/*     */       StdSchedulerFactory factory;
/* 128 */       if (configFile != null)
/* 129 */         factory = new StdSchedulerFactory(configFile);
/*     */       else {
/* 131 */         factory = new StdSchedulerFactory();
/*     */       }
/*     */ 
/* 135 */       String startOnLoad = servletContext.getInitParameter("start-scheduler-on-load");
/*     */ 
/* 142 */       if ((startOnLoad == null) || (Boolean.valueOf(startOnLoad).booleanValue()))
/*     */       {
/* 144 */         this.scheduler = factory.getScheduler();
/* 145 */         this.scheduler.start();
/* 146 */         System.out.println("Scheduler has been started...");
/*     */       } else {
/* 148 */         System.out.println("Scheduler has not been started. Use scheduler.start()");
/*     */       }
/*     */ 
/* 151 */       System.out.println("Storing the Quartz Scheduler Factory in the servlet context at key: org.quartz.impl.StdSchedulerFactory.KEY");
/*     */ 
/* 153 */       servletContext.setAttribute("org.quartz.impl.StdSchedulerFactory.KEY", factory);
/*     */     }
/*     */     catch (Exception e) {
/* 156 */       System.out.println("Quartz Scheduler failed to initialize: " + e.toString());
/* 157 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void contextDestroyed(ServletContextEvent sce)
/*     */   {
/* 163 */     if (!this.performShutdown)
/* 164 */       return;
/*     */     try
/*     */     {
/* 167 */       if (this.scheduler != null)
/* 168 */         this.scheduler.shutdown();
/*     */     } catch (Exception e) {
/* 170 */       System.out.println("Quartz Scheduler failed to shutdown cleanly: " + e.toString());
/* 171 */       e.printStackTrace();
/*     */     }
/*     */ 
/* 174 */     System.out.println("Quartz Scheduler successful shutdown.");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.ee.servlet.QuartzInitializerListener
 * JD-Core Version:    0.6.0
 */