/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import org.apache.commons.logging.Log;
/*     */ 
/*     */ public class HSQLDBDelegate extends StdJDBCDelegate
/*     */ {
/*     */   public HSQLDBDelegate(Log log, String tablePrefix, String instanceId)
/*     */   {
/*  51 */     super(log, tablePrefix, instanceId);
/*     */   }
/*     */ 
/*     */   public HSQLDBDelegate(Log log, String tablePrefix, String instanceId, Boolean useProperties)
/*     */   {
/*  68 */     super(log, tablePrefix, instanceId, useProperties);
/*     */   }
/*     */ 
/*     */   protected Object getObjectFromBlob(ResultSet rs, String colName)
/*     */     throws ClassNotFoundException, IOException, SQLException
/*     */   {
/*  94 */     InputStream binaryInput = rs.getBinaryStream(colName);
/*     */ 
/*  96 */     if (binaryInput == null) {
/*  97 */       return null;
/*     */     }
/*  99 */     ObjectInputStream in = new ObjectInputStream(binaryInput);
/* 100 */     Object obj = in.readObject();
/* 101 */     in.close();
/*     */ 
/* 103 */     return obj;
/*     */   }
/*     */ 
/*     */   protected Object getJobDetailFromBlob(ResultSet rs, String colName) throws ClassNotFoundException, IOException, SQLException
/*     */   {
/* 108 */     if (canUseProperties()) {
/* 109 */       InputStream binaryInput = rs.getBinaryStream(colName);
/* 110 */       return binaryInput;
/*     */     }
/* 112 */     return getObjectFromBlob(rs, colName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.HSQLDBDelegate
 * JD-Core Version:    0.6.0
 */