/*     */ package org.quartz.impl.jdbcjobstore;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.util.HashSet;
/*     */ import org.apache.commons.logging.Log;
/*     */ import org.apache.commons.logging.LogFactory;
/*     */ 
/*     */ public class StdRowLockSemaphore
/*     */   implements Semaphore, Constants, StdJDBCConstants
/*     */ {
/*     */   public static final String SELECT_FOR_LOCK = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";
/*  61 */   ThreadLocal lockOwners = new ThreadLocal();
/*     */ 
/*  64 */   private String selectWithLockSQL = "SELECT * FROM {0}LOCKS WHERE LOCK_NAME = ? FOR UPDATE";
/*     */   private String tablePrefix;
/*     */ 
/*     */   public StdRowLockSemaphore(String tablePrefix, String selectWithLockSQL)
/*     */   {
/*  77 */     this.tablePrefix = tablePrefix;
/*     */ 
/*  79 */     if ((selectWithLockSQL != null) && (selectWithLockSQL.trim().length() != 0)) {
/*  80 */       this.selectWithLockSQL = selectWithLockSQL;
/*     */     }
/*  82 */     this.selectWithLockSQL = Util.rtp(this.selectWithLockSQL, tablePrefix);
/*     */   }
/*     */ 
/*     */   Log getLog()
/*     */   {
/*  94 */     return LogFactory.getLog(getClass());
/*     */   }
/*     */ 
/*     */   private HashSet getThreadLocks()
/*     */   {
/*  99 */     HashSet threadLocks = (HashSet)this.lockOwners.get();
/* 100 */     if (threadLocks == null) {
/* 101 */       threadLocks = new HashSet();
/* 102 */       this.lockOwners.set(threadLocks);
/*     */     }
/* 104 */     return threadLocks;
/*     */   }
/*     */ 
/*     */   public boolean obtainLock(Connection conn, String lockName)
/*     */     throws LockException
/*     */   {
/* 116 */     lockName = lockName.intern();
/*     */ 
/* 118 */     Log log = getLog();
/*     */ 
/* 120 */     if (log.isDebugEnabled()) {
/* 121 */       log.debug("Lock '" + lockName + "' is desired by: " + Thread.currentThread().getName());
/*     */     }
/*     */ 
/* 124 */     if (!isLockOwner(conn, lockName))
/*     */     {
/* 126 */       PreparedStatement ps = null;
/* 127 */       ResultSet rs = null;
/*     */       try {
/* 129 */         ps = conn.prepareStatement(this.selectWithLockSQL);
/* 130 */         ps.setString(1, lockName);
/*     */ 
/* 133 */         if (log.isDebugEnabled()) {
/* 134 */           log.debug("Lock '" + lockName + "' is being obtained: " + Thread.currentThread().getName());
/*     */         }
/*     */ 
/* 137 */         rs = ps.executeQuery();
/* 138 */         if (!rs.next()) {
/* 139 */           throw new SQLException(Util.rtp("No row exists in table {0}LOCKS for lock named: " + lockName, this.tablePrefix));
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (SQLException sqle)
/*     */       {
/* 151 */         if (log.isDebugEnabled()) {
/* 152 */           log.debug("Lock '" + lockName + "' was not obtained by: " + Thread.currentThread().getName());
/*     */         }
/*     */ 
/* 155 */         throw new LockException("Failure obtaining db row lock: " + sqle.getMessage(), sqle);
/*     */       }
/*     */       finally {
/* 158 */         if (rs != null) try {
/* 159 */             rs.close();
/*     */           }
/*     */           catch (Exception ignore) {
/*     */           } if (ps != null) try {
/* 163 */             ps.close();
/*     */           }
/*     */           catch (Exception ignore) {
/*     */           } 
/*     */       }
/* 167 */       if (log.isDebugEnabled()) {
/* 168 */         log.debug("Lock '" + lockName + "' given to: " + Thread.currentThread().getName());
/*     */       }
/*     */ 
/* 171 */       getThreadLocks().add(lockName);
/*     */     }
/* 175 */     else if (log.isDebugEnabled()) {
/* 176 */       log.debug("Lock '" + lockName + "' Is already owned by: " + Thread.currentThread().getName());
/*     */     }
/*     */ 
/* 180 */     return true;
/*     */   }
/*     */ 
/*     */   public void releaseLock(Connection conn, String lockName)
/*     */   {
/* 189 */     lockName = lockName.intern();
/*     */ 
/* 191 */     if (isLockOwner(conn, lockName)) {
/* 192 */       if (getLog().isDebugEnabled()) {
/* 193 */         getLog().debug("Lock '" + lockName + "' returned by: " + Thread.currentThread().getName());
/*     */       }
/*     */ 
/* 196 */       getThreadLocks().remove(lockName);
/*     */     }
/* 199 */     else if (getLog().isDebugEnabled()) {
/* 200 */       getLog().warn("Lock '" + lockName + "' attempt to retun by: " + Thread.currentThread().getName() + " -- but not owner!", new Exception("stack-trace of wrongful returner"));
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean isLockOwner(Connection conn, String lockName)
/*     */   {
/* 214 */     lockName = lockName.intern();
/*     */ 
/* 216 */     return getThreadLocks().contains(lockName);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/thirdparty-all.jar
 * Qualified Name:     org.quartz.impl.jdbcjobstore.StdRowLockSemaphore
 * JD-Core Version:    0.6.0
 */