/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStore;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.arjuna.utils.Utility;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;

public class TransactionStatusManagerItem {
    private Uid _pidUid;
    private static String _typeName = "/Recovery/TransactionStatusManager";
    private String _host;
    private int _port;
    private static ObjectStore _objectStore = null;
    private static TransactionStatusManagerItem _singularItem = null;
    private Date _deadTime;
    private boolean _markedDead;

    public static boolean createAndSave(int port) {
        boolean ret_status = true;
        if (_singularItem == null) {
            _singularItem = new TransactionStatusManagerItem(port);
            ret_status = _singularItem.saveThis();
        }
        return ret_status;
    }

    public static ObjectStore getStore() {
        if (_objectStore == null) {
            _objectStore = TxControl.getStore();
        }
        return _objectStore;
    }

    public String host() {
        return this._host;
    }

    public int port() {
        return this._port;
    }

    public void markAsDead() {
        if (!this._markedDead) {
            this._markedDead = true;
            this._deadTime = new Date();
            this.saveThis();
        }
    }

    public Date getDeadTime() {
        return this._deadTime;
    }

    public static TransactionStatusManagerItem get() {
        return _singularItem;
    }

    public static TransactionStatusManagerItem recreate(Uid uid) {
        TransactionStatusManagerItem theItem = new TransactionStatusManagerItem(uid);
        if (theItem.restoreThis()) {
            return theItem;
        }
        return null;
    }

    public static boolean removeThis(Uid pidUid) {
        boolean ret_status;
        block2: {
            ret_status = false;
            try {
                ret_status = TransactionStatusManagerItem.getStore().remove_committed(pidUid, _typeName);
            }
            catch (ObjectStoreException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block2;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_1", new Object[]{ex});
            }
        }
        return ret_status;
    }

    public static String typeName() {
        return _typeName;
    }

    private boolean restoreThis() {
        boolean ret_status;
        block3: {
            ret_status = false;
            try {
                InputObjectState objstate = TransactionStatusManagerItem.getStore().read_committed(this._pidUid, _typeName);
                if (this.restore_state(objstate)) {
                    ret_status = true;
                    return true;
                }
            }
            catch (ObjectStoreException ex) {
                ret_status = false;
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_2", new Object[]{ex});
            }
        }
        return ret_status;
    }

    private boolean restore_state(InputObjectState objstate) {
        boolean ret_status;
        block3: {
            ret_status = false;
            try {
                this._host = objstate.unpackString();
                this._port = objstate.unpackInt();
                this._markedDead = objstate.unpackBoolean();
                if (this._markedDead) {
                    long deadtime = objstate.unpackLong();
                    this._deadTime = new Date(deadtime);
                }
                ret_status = true;
            }
            catch (IOException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_3", new Object[]{ex});
            }
        }
        return ret_status;
    }

    private boolean save_state(OutputObjectState objstate) {
        boolean ret_status;
        block3: {
            ret_status = false;
            try {
                objstate.packString(this._host);
                objstate.packInt(this._port);
                objstate.packBoolean(this._markedDead);
                if (this._markedDead) {
                    objstate.packLong(this._deadTime.getTime());
                }
                ret_status = true;
            }
            catch (IOException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_2", new Object[]{ex});
            }
        }
        return ret_status;
    }

    private boolean saveThis() {
        boolean ret_status;
        block3: {
            ret_status = false;
            try {
                OutputObjectState objstate = new OutputObjectState();
                if (this.save_state(objstate)) {
                    ret_status = TransactionStatusManagerItem.getStore().write_committed(this._pidUid, _typeName, objstate);
                }
            }
            catch (ObjectStoreException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_2", new Object[]{ex});
            }
        }
        return ret_status;
    }

    private TransactionStatusManagerItem(int port) {
        block3: {
            this._deadTime = null;
            this._markedDead = false;
            this._pidUid = Utility.getProcessUid();
            this._port = port;
            try {
                this._host = InetAddress.getLocalHost().getHostAddress();
                if (tsLogger.arjLogger.isInfoEnabled()) {
                    tsLogger.arjLogger.info("TransactionStatusManagerItem - host: " + this._host + " port: " + this._port);
                }
            }
            catch (UnknownHostException ex) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block3;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem_4", new Object[]{ex});
            }
        }
    }

    private TransactionStatusManagerItem(Uid uid) {
        this._deadTime = null;
        this._markedDead = false;
        this._pidUid = new Uid(uid);
    }
}

