/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.instrument;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CodeConverter;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMember;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.SerialVersionUID;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.annotation.Annotation;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.annotation.compiler.AnnotationInfoCreator;
import org.jboss.aop.classpool.AOPClassPool;
import org.jboss.aop.classpool.AOPClassPoolRepository;
import org.jboss.aop.instrument.CallerTransformer;
import org.jboss.aop.instrument.ConstructionTransformer;
import org.jboss.aop.instrument.ConstructorExecutionTransformer;
import org.jboss.aop.instrument.DeclareChecker;
import org.jboss.aop.instrument.DynamicTransformationObserver;
import org.jboss.aop.instrument.FieldAccessTransformer;
import org.jboss.aop.instrument.HotSwapper;
import org.jboss.aop.instrument.JoinpointClassifier;
import org.jboss.aop.instrument.JoinpointStatusUpdate;
import org.jboss.aop.instrument.MethodExecutionTransformer;
import org.jboss.aop.instrument.TransformationException;
import org.jboss.aop.introduction.AnnotationIntroduction;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.util.Advisable;
import org.jboss.aop.util.CtConstructorComparator;
import org.jboss.aop.util.CtFieldComparator;
import org.jboss.aop.util.JavassistMethodHashing;

public abstract class Instrumentor {
    public static final String AOP_PACKAGE = Advised.class.getPackage().getName();
    public static final String ASPECT_MANAGER_CLASS_NAME = AOP_PACKAGE + ".AspectManager";
    public static final String HELPER_FIELD_NAME = "aop$classAdvisor$aop";
    protected AOPClassPool classPool;
    protected boolean basicsSet = false;
    protected CodeConverter converter;
    protected AspectManager manager;
    protected JoinpointClassifier joinpointClassifier;
    protected static Collection processedClasses = new ArrayList();
    MethodExecutionTransformer methodExecutionTransformer;
    ConstructorExecutionTransformer constructorExecutionTransformer;
    ConstructionTransformer constructionTransformer;
    FieldAccessTransformer fieldAccessTransformer;
    CallerTransformer callerTransformer;
    DynamicTransformationObserver dynamicTransformationObserver;

    protected Instrumentor(AOPClassPool pool, AspectManager manager, JoinpointClassifier joinpointClassifier, DynamicTransformationObserver observer) {
        this.classPool = pool;
        this.converter = new CodeConverter();
        this.manager = manager;
        this.joinpointClassifier = joinpointClassifier;
        this.dynamicTransformationObserver = observer;
        this.intitialiseTransformers();
    }

    protected Instrumentor(AspectManager manager, JoinpointClassifier joinpointClassifier) {
        this(null, manager, joinpointClassifier, null);
    }

    protected abstract void intitialiseTransformers();

    public ClassPool getClassPool() {
        return this.classPool;
    }

    CodeConverter getCodeConverter() {
        return this.converter;
    }

    public boolean isAdvised(CtClass clazz) throws NotFoundException {
        CtClass[] interfaces = clazz.getInterfaces();
        CtClass advised = this.forName(AOP_PACKAGE + ".Advised");
        for (int i = 0; i < interfaces.length; ++i) {
            if (interfaces[i].equals(advised)) {
                return true;
            }
            if (!interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) continue;
            return true;
        }
        return false;
    }

    public static boolean implementsAdvised(CtClass clazz) throws NotFoundException {
        CtClass[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(AOP_PACKAGE + ".Advised")) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransformable(CtClass clazz) throws NotFoundException {
        CtClass[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(AOP_PACKAGE + ".instrument.Untransformable")) continue;
            return false;
        }
        return true;
    }

    protected boolean isBaseClass(CtClass clazz) throws NotFoundException {
        if (clazz.getSuperclass() != null) {
            return !this.isAdvised(clazz.getSuperclass());
        }
        return true;
    }

    protected static String mixinFieldName(CtClass mixinClass) {
        StringBuffer buf = new StringBuffer("_");
        buf.append(mixinClass.getName().replace('.', '$'));
        buf.append("$aop$mixin");
        return buf.toString();
    }

    private void addMixinMethod(Advisor advisor, CtMethod method, CtClass clazz, CtMethod delegate, long hash) throws Exception {
        CtClass[] exceptions = method.getExceptionTypes();
        CtMethod newMethod = CtNewMethod.wrapped((CtClass)method.getReturnType(), (String)method.getName(), (CtClass[])method.getParameterTypes(), (CtClass[])exceptions, (CtMethod)delegate, (CtMethod.ConstParameter)CtMethod.ConstParameter.integer((long)hash), (CtClass)clazz);
        newMethod.setModifiers(1);
        clazz.addMethod(newMethod);
    }

    private void addMixin(CtClass clazz, InterfaceIntroduction pointcut, InterfaceIntroduction.Mixin mixin, HashMap baseMethods) throws Exception {
        CtClass mixinClass = this.classPool.get(mixin.getClassName());
        if (pointcut.getConstructorClass() != null) {
            CtClass type = this.forName(pointcut.getConstructorClass());
            CtMethod[] methods = type.getDeclaredMethods();
            boolean correct = false;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(pointcut.getConstructorMethod()) || methods[i].getParameterTypes().length != 1 || !clazz.subclassOf(methods[i].getParameterTypes()[0])) continue;
                correct = true;
            }
            if (!correct) {
                throw new RuntimeException("Could not find a method named '" + pointcut.getConstructorMethod() + "' on class " + pointcut.getConstructorClass() + " that receives " + clazz.getName() + " or one of its superclasses as parameter.");
            }
        }
        String initializer = null;
        if (mixin.getConstruction() == null) {
            if (mixinClass.getConstructor("()V") == null) {
                throw new RuntimeException("Default constructor of mixin class '" + mixinClass + "' not found.");
            }
            initializer = "new " + mixinClass.getName() + "()";
        } else {
            initializer = mixin.getConstruction();
        }
        CtClass type = this.forName(mixinClass.getName());
        CtField field = new CtField(type, Instrumentor.mixinFieldName(mixinClass), clazz);
        int modifiers = 2;
        if (mixin.isTransient()) {
            modifiers |= 0x80;
        }
        field.setModifiers(modifiers);
        clazz.addField(field, CtField.Initializer.byExpr((String)initializer));
        HashSet<Long> addedMethods = new HashSet<Long>();
        String[] interfaces = mixin.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            CtClass intf = this.classPool.get(interfaces[i]);
            if (clazz.subtypeOf(intf)) continue;
            clazz.addInterface(intf);
            HashMap intfMap = JavassistMethodHashing.getMethodMap(intf);
            for (Map.Entry entry : intfMap.entrySet()) {
                Long hash = (Long)entry.getKey();
                CtMethod method = (CtMethod)entry.getValue();
                CtMethod baseMethod = (CtMethod)baseMethods.get(hash);
                if (baseMethod != null && !addedMethods.contains(hash)) {
                    String msg = "Mixin " + mixinClass.getName() + " of pointcut " + pointcut.getName() + " is trying to apply an already existing method" + method.getName() + " for class " + clazz.getName();
                    if (baseMethod.getDeclaringClass().equals(clazz)) {
                        throw new RuntimeException(msg);
                    }
                    if (AspectManager.verbose) {
                        System.out.println("[warn] " + msg);
                    }
                }
                if (addedMethods.contains(hash)) continue;
                try {
                    this.createMixinInvokeMethod(clazz, mixinClass, initializer, method, hash);
                }
                catch (CannotCompileException e) {
                    String generatedCode = "class " + clazz.getName() + "\n{\n   ...\n" + "   private " + type.getName() + " = " + initializer + ";\n" + "   ...\n}";
                    throw new RuntimeException("Mixin construction expression '" + initializer + "' may have sintax error:\n" + generatedCode, e);
                }
                baseMethods.put(hash, method);
                addedMethods.add(hash);
            }
        }
    }

    private void addIntroductionPointcutInterface(CtClass clazz, Advisor advisor, String intf, HashMap baseMethods) throws Exception {
        CtClass iface = this.classPool.get(intf);
        if (!clazz.subtypeOf(iface) && !clazz.subclassOf(iface)) {
            clazz.addInterface(iface);
        }
        CtMethod mixinInvokeMethod = this.createInvokeMethod(clazz);
        HashMap intfMap = JavassistMethodHashing.getMethodMap(iface);
        for (Map.Entry entry : intfMap.entrySet()) {
            Long hash = (Long)entry.getKey();
            if (baseMethods.containsKey(hash)) continue;
            CtMethod method = (CtMethod)entry.getValue();
            this.addMixinMethod(advisor, method, clazz, mixinInvokeMethod, hash);
            baseMethods.put(hash, method);
        }
    }

    private void instrumentIntroductions(CtClass clazz, Advisor advisor) throws Exception {
        int i;
        ArrayList pointcuts = advisor.getInterfaceIntroductions();
        if (pointcuts.size() == 0) {
            return;
        }
        HashMap baseMethods = JavassistMethodHashing.getDeclaredMethodMap(clazz);
        Iterator it = pointcuts.iterator();
        if (it.hasNext()) {
            this.setupBasics(clazz);
        }
        while (it.hasNext()) {
            InterfaceIntroduction pointcut = (InterfaceIntroduction)it.next();
            ArrayList mixins = pointcut.getMixins();
            for (i = 0; i < mixins.size(); ++i) {
                InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixins.get(i);
                this.addMixin(clazz, pointcut, mixin, baseMethods);
            }
        }
        for (InterfaceIntroduction pointcut : pointcuts) {
            String[] interfaces = pointcut.getInterfaces();
            if (interfaces == null) continue;
            for (i = 0; i < interfaces.length; ++i) {
                this.addIntroductionPointcutInterface(clazz, advisor, interfaces[i], baseMethods);
            }
        }
    }

    private boolean instrumentAnnotationIntroductions(CtClass clazz, ClassAdvisor advisor) throws Exception {
        boolean changed = false;
        for (AnnotationIntroduction introduction : advisor.getManager().getAnnotationIntroductions()) {
            if (AspectManager.verbose) {
                System.out.println("**** " + introduction.getOriginalAnnotationExpr() + " invisible: " + introduction.isInvisible() + " expr: " + introduction.getOriginalExpression());
            }
            if (introduction.matches((Advisor)advisor, clazz)) {
                if (AspectManager.verbose) {
                    System.out.println(introduction.getAnnotation() + " binds to " + clazz.getName());
                }
                Annotation info = AnnotationInfoCreator.createAnnotationInfo((ClassPool)this.classPool, clazz.getClassFile2().getConstPool(), introduction.getAnnotation());
                if (introduction.isInvisible()) {
                    AnnotationsAttribute invisible = (AnnotationsAttribute)clazz.getClassFile2().getAttribute("RuntimeInvisibleAnnotations");
                    if (invisible == null) {
                        invisible = new AnnotationsAttribute(clazz.getClassFile2().getConstPool(), "RuntimeInvisibleAnnotations");
                        clazz.getClassFile2().addAttribute((AttributeInfo)invisible);
                    }
                    changed = true;
                    invisible.addAnnotation(info);
                } else {
                    AnnotationsAttribute visible = (AnnotationsAttribute)clazz.getClassFile2().getAttribute("RuntimeVisibleAnnotations");
                    if (visible == null) {
                        visible = new AnnotationsAttribute(clazz.getClassFile2().getConstPool(), "RuntimeVisibleAnnotations");
                        clazz.getClassFile2().addAttribute((AttributeInfo)visible);
                    }
                    changed = true;
                    visible.addAnnotation(info);
                }
            }
            CtMethod[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!introduction.matches((Advisor)advisor, methods[i])) continue;
                Annotation info = AnnotationInfoCreator.createAnnotationInfo((ClassPool)this.classPool, methods[i].getMethodInfo2().getConstPool(), introduction.getAnnotation());
                MethodInfo mi = methods[i].getMethodInfo2();
                if (introduction.isInvisible()) {
                    AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
                    if (invisible == null) {
                        invisible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeInvisibleAnnotations");
                        mi.addAttribute((AttributeInfo)invisible);
                    }
                    changed = true;
                    invisible.addAnnotation(info);
                    continue;
                }
                AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
                if (visible == null) {
                    visible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeVisibleAnnotations");
                    mi.addAttribute((AttributeInfo)visible);
                }
                changed = true;
                visible.addAnnotation(info);
            }
            CtConstructor[] cons = clazz.getDeclaredConstructors();
            for (int i = 0; i < cons.length; ++i) {
                if (!introduction.matches((Advisor)advisor, cons[i])) continue;
                Annotation info = AnnotationInfoCreator.createAnnotationInfo((ClassPool)this.classPool, cons[i].getMethodInfo2().getConstPool(), introduction.getAnnotation());
                MethodInfo mi = cons[i].getMethodInfo2();
                if (introduction.isInvisible()) {
                    AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
                    if (invisible == null) {
                        invisible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeInvisibleAnnotations");
                        mi.addAttribute((AttributeInfo)invisible);
                    }
                    changed = true;
                    invisible.addAnnotation(info);
                    continue;
                }
                AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
                if (visible == null) {
                    visible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeVisibleAnnotations");
                    mi.addAttribute((AttributeInfo)visible);
                }
                changed = true;
                visible.addAnnotation(info);
            }
            CtField[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!introduction.matches((Advisor)advisor, fields[i])) continue;
                Annotation info = AnnotationInfoCreator.createAnnotationInfo((ClassPool)this.classPool, fields[i].getFieldInfo2().getConstPool(), introduction.getAnnotation());
                FieldInfo mi = fields[i].getFieldInfo2();
                if (introduction.isInvisible()) {
                    AnnotationsAttribute invisible = (AnnotationsAttribute)mi.getAttribute("RuntimeInvisibleAnnotations");
                    if (invisible == null) {
                        invisible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeInvisibleAnnotations");
                        mi.addAttribute((AttributeInfo)invisible);
                    }
                    changed = true;
                    invisible.addAnnotation(info);
                    continue;
                }
                AnnotationsAttribute visible = (AnnotationsAttribute)mi.getAttribute("RuntimeVisibleAnnotations");
                if (visible == null) {
                    visible = new AnnotationsAttribute(mi.getConstPool(), "RuntimeVisibleAnnotations");
                    mi.addAttribute((AttributeInfo)visible);
                }
                changed = true;
                visible.addAnnotation(info);
            }
        }
        return changed;
    }

    private boolean instrumentAnnotationOverrides(CtClass clazz, ClassAdvisor advisor) throws Exception {
        boolean changed = false;
        for (AnnotationIntroduction introduction : advisor.getManager().getAnnotationOverrides()) {
            if (introduction.matches((Advisor)advisor, clazz)) {
                advisor.getAnnotations().addClassAnnotation(introduction.getAnnotation().getIdentifier(), introduction.getOriginalAnnotationExpr());
            }
            CtMethod[] methods = clazz.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!introduction.matches((Advisor)advisor, methods[i])) continue;
                advisor.getAnnotations().addAnnotation((CtMember)methods[i], introduction.getAnnotation().getIdentifier());
            }
            CtConstructor[] cons = clazz.getDeclaredConstructors();
            for (int i = 0; i < cons.length; ++i) {
                if (!introduction.matches((Advisor)advisor, cons[i])) continue;
                advisor.getAnnotations().addAnnotation((CtMember)cons[i], introduction.getAnnotation().getIdentifier());
            }
            CtField[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!introduction.matches((Advisor)advisor, fields[i])) continue;
                advisor.getAnnotations().addAnnotation((CtMember)fields[i], introduction.getAnnotation().getIdentifier());
            }
        }
        return changed;
    }

    public boolean applyCallerPointcuts(CtClass clazz, ClassAdvisor advisor) throws CannotCompileException {
        return this.callerTransformer.applyCallerPointcuts(clazz, advisor);
    }

    protected boolean convertReferences(CtClass clazz) throws Exception {
        boolean converted = false;
        String ref = null;
        try {
            AOPClassPool pool = AOPClassPool.createAOPClassPool(clazz.getClassPool(), AOPClassPoolRepository.getInstance());
            ReferenceClassIterator it = new ReferenceClassIterator(clazz.getRefClasses());
            while (it.hasNext()) {
                ref = it.next();
                if (!this.manager.getInterceptionMarkers().convertReference(ref) || this.manager.isNonAdvisableClassName(ref) || ref.startsWith("java.") || ref.startsWith("javax.") || ref.startsWith("[")) continue;
                CtClass ctRef = null;
                try {
                    ctRef = pool.get(ref);
                }
                catch (NotFoundException e) {
                    if (AspectManager.suppressReferenceErrors) {
                        System.err.println("[warn] Could not find class " + ref + " that " + clazz.getName() + " references.  It may not be in your classpath and you may not be getting field and constructor weaving for this class.");
                        if (!AspectManager.verbose) continue;
                        e.printStackTrace();
                        continue;
                    }
                    throw e;
                }
                if (!Instrumentor.isTransformable(ctRef)) continue;
                it.addSuperClass(ctRef);
                ClassAdvisor advisor = this.manager.getTempClassAdvisor(ctRef);
                if (!this.manager.getInterceptionMarkers().shouldSkipFieldAccess(ref) && !ref.equals(clazz.getName())) {
                    List fields = Instrumentor.getAdvisableFields(ctRef);
                    if (this.fieldAccessTransformer.replaceFieldAccess(fields, ctRef, advisor)) {
                        this.manager.getInterceptionMarkers().addFieldInterceptionMarker(ref);
                        converted = true;
                    } else {
                        this.manager.getInterceptionMarkers().skipFieldAccess(ref);
                    }
                }
                if (!this.manager.getInterceptionMarkers().shouldSkipConstruction(ref)) {
                    if (this.constructorExecutionTransformer.replaceConstructorAccess(advisor, ctRef)) {
                        this.manager.getInterceptionMarkers().addConstructionInterceptionMarker(ref);
                        converted = true;
                    } else {
                        this.manager.getInterceptionMarkers().skipConstruction(ref);
                    }
                }
                if (!converted) {
                    this.manager.getInterceptionMarkers().skipReference(ref);
                }
                ref = null;
            }
        }
        catch (Exception ex) {
            if (ref != null) {
                throw new TransformationException("Failed to aspectize class " + clazz.getName() + ".  Could not find class it references " + ref + "  It may not be in your classpath and you may not be getting field and constructor weaving for this class.");
            }
            throw ex;
        }
        return converted;
    }

    protected boolean shouldNotTransform(CtClass clazz) throws NotFoundException {
        return clazz.isInterface() || clazz.isFrozen() || clazz.isArray() || clazz.getName().startsWith("org.jboss.aop") || this.isAdvised(clazz) || !Instrumentor.isTransformable(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transform(CtClass clazz, ClassAdvisor advisor) {
        try {
            if (this.shouldNotTransform(clazz)) {
                return false;
            }
            if (AspectManager.verbose) {
                System.out.println("[trying to transform] " + clazz.getName());
            }
            DeclareChecker.checkDeclares(this.manager, clazz, advisor);
            boolean converted = this.instrumentAnnotationIntroductions(clazz, advisor);
            converted = this.instrumentAnnotationOverrides(clazz, advisor) || converted;
            boolean constructorAccessConverted = false;
            converted = this.applyCallerPointcuts(clazz, advisor) || converted;
            this.methodExecutionTransformer.instrument(clazz, advisor);
            boolean constructionTransformation = this.constructionTransformer.insertConstructionInterception(clazz, advisor);
            constructorAccessConverted = this.constructorExecutionTransformer.transform(clazz, advisor);
            String classname = clazz.getName();
            if (constructorAccessConverted) {
                this.manager.getInterceptionMarkers().addConstructionInterceptionMarker(classname);
            } else {
                this.manager.getInterceptionMarkers().skipConstruction(classname);
            }
            converted = converted || constructorAccessConverted;
            this.instrumentIntroductions(clazz, advisor);
            boolean bl = converted = this.convertReferences(clazz) || converted;
            if (converted || this.basicsSet) {
                clazz.instrument(this.converter);
            }
            this.fieldAccessTransformer.buildFieldWrappers(clazz, advisor);
            if (constructorAccessConverted) {
                this.constructorExecutionTransformer.codeConverted();
            } else if (this.manager.getInterceptionMarkers().shouldSkipFieldAccess(classname)) {
                this.manager.getInterceptionMarkers().skipReference(classname);
            }
            this.dynamicTransformationObserver.transformationFinished(clazz, this.converter);
            Collection collection = processedClasses;
            synchronized (collection) {
                processedClasses.add(clazz);
            }
            if (AspectManager.verbose) {
                System.out.println("[debug] was " + clazz.getName() + " converted: " + (this.basicsSet || converted));
            }
            return this.basicsSet || converted;
        }
        catch (Throwable e) {
            if (AspectManager.suppressTransformationErrors) {
                System.err.println("[warn] AOP Instrumentor failed to transform " + clazz.getName());
                e.printStackTrace();
                return false;
            }
            if (e instanceof TransformationException) {
                throw (TransformationException)e;
            }
            e.printStackTrace();
            throw new RuntimeException("failed to transform: " + clazz.getName(), e);
        }
    }

    public List getConstructors(CtClass clazz) {
        ArrayList<CtConstructor> list2 = new ArrayList<CtConstructor>();
        CtConstructor[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            list2.add(constructors[i]);
        }
        Collections.sort(list2, CtConstructorComparator.INSTANCE);
        return list2;
    }

    public static List getAdvisableFields(CtClass clazz) throws NotFoundException {
        ArrayList<CtField> list2 = new ArrayList<CtField>();
        CtField[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!Advisable.isAdvisable(fields[i])) continue;
            list2.add(fields[i]);
        }
        Collections.sort(list2, CtFieldComparator.INSTANCE);
        return list2;
    }

    private CtMethod createInvokeMethod(CtClass clazz) throws CannotCompileException {
        return CtNewMethod.make((String)"public java.lang.Object invoke(java.lang.Object[] args, long i)       throws java.lang.Throwable {   return ((org.jboss.aop.ClassAdvisor)this._getAdvisor()).invokeMethod(this, i, args);}", (CtClass)clazz);
    }

    public CtClass forName(String name) throws NotFoundException {
        return this.classPool.get(name);
    }

    public CtClass forName(ClassPool pool, String name) throws NotFoundException {
        return pool.get(name);
    }

    protected CtField addStaticField(CtClass clazz, String name, String typeName, CtField.Initializer initializer) throws CannotCompileException, NotFoundException {
        CtClass type = this.forName(typeName);
        CtField field = new CtField(type, name, clazz);
        field.setModifiers(10);
        clazz.addField(field, initializer);
        return field;
    }

    protected CtField addProtectedField(CtClass clazz, String name, String typeName, CtField.Initializer initializer) throws CannotCompileException, NotFoundException {
        CtClass type = this.forName(typeName);
        CtField field = new CtField(type, name, clazz);
        field.setModifiers(132);
        if (initializer != null) {
            clazz.addField(field, initializer);
        } else {
            clazz.addField(field);
        }
        return field;
    }

    public void setupBasics(CtClass clazz) throws CannotCompileException, NotFoundException {
        if (this.basicsSet) {
            return;
        }
        this.basicsSet = true;
        SerialVersionUID.setSerialVersionUID((CtClass)clazz);
        clazz.addInterface(this.forName(AOP_PACKAGE + ".Advised"));
        this.doSetupBasics(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void interceptorChainsUpdated(Collection joinpointUpdates, HotSwapper hotSwapper) {
        this.converter = new CodeConverter();
        HashSet<CtClass> classes = new HashSet<CtClass>();
        try {
            Object clazz;
            for (JoinpointStatusUpdate update : joinpointUpdates) {
                clazz = update.clazz;
                JoinpointStatusUpdate.ClassJoinpoints wrapTargets = update.newlyAdvisedJoinpoints;
                JoinpointStatusUpdate.ClassJoinpoints unwrapTargets = update.newlyUnadvisedJoinpoints;
                clazz.defrost();
                this.fieldAccessTransformer.wrap((CtClass)clazz, wrapTargets.fieldReads, wrapTargets.fieldWrites);
                this.fieldAccessTransformer.unwrap((CtClass)clazz, unwrapTargets.fieldReads, unwrapTargets.fieldWrites);
                this.constructorExecutionTransformer.wrap((CtClass)clazz, wrapTargets.constructorExecutions);
                this.constructorExecutionTransformer.unwrap((CtClass)clazz, unwrapTargets.constructorExecutions);
                this.methodExecutionTransformer.wrap((CtClass)clazz, wrapTargets.methodExecutions);
                this.methodExecutionTransformer.unwrap((CtClass)clazz, unwrapTargets.methodExecutions);
                if (update.isEmpty()) continue;
                clazz.instrument(this.converter);
                classes.add((CtClass)clazz);
            }
            Instrumentor instrumentor = this;
            Collection classPools = instrumentor.manager.getRegisteredCLs().values();
            HashSet conversionsRegistered = new HashSet();
            clazz = processedClasses;
            synchronized (clazz) {
                for (CtClass clazz2 : processedClasses) {
                    if (this.manager.isNonAdvisableClassName(clazz2.getName()) || !Instrumentor.isTransformable(clazz2) || classes.contains(clazz2)) continue;
                    clazz2.defrost();
                    byte[] previousByteCode = clazz2.toBytecode();
                    clazz2.defrost();
                    clazz2.instrument(this.converter);
                    if (!Arrays.equals(clazz2.toBytecode(), previousByteCode)) {
                        classes.add(clazz2);
                    }
                    clazz2.defrost();
                }
            }
            this.fieldAccessTransformer.codeConverted();
            this.constructorExecutionTransformer.codeConverted();
            for (CtClass clazz3 : classes) {
                AOPClassPool classPool = (AOPClassPool)clazz3.getClassPool();
                clazz3.defrost();
                hotSwapper.registerChange(classPool.getClassLoader().loadClass(clazz3.getName()), clazz3.toBytecode());
            }
            hotSwapper.hotSwap();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (AspectManager.suppressTransformationErrors) {
                System.err.println("[warn] AOP Instrumentor failed to updated wrapping status.");
                e.printStackTrace();
            }
            if (e instanceof TransformationException) {
                throw (TransformationException)e;
            }
            throw new RuntimeException("failed to update wrapping status", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void convertProcessedClasses(HotSwapper hotSwapper, CtClass clazz, Collection fieldReads, Collection fieldWrites, boolean constructor) {
        AOPClassPool classPool = (AOPClassPool)clazz.getClassPool();
        CodeConverter codeConverter = new CodeConverter();
        for (CtField field : fieldReads) {
            codeConverter.replaceFieldRead(field, clazz, FieldAccessTransformer.fieldRead(field.getName()));
        }
        for (CtField field : fieldWrites) {
            codeConverter.replaceFieldWrite(field, clazz, FieldAccessTransformer.fieldWrite(field.getName()));
        }
        if (constructor) {
            codeConverter.replaceNew(clazz, clazz, ConstructorExecutionTransformer.constructorFactory(clazz.getSimpleName()));
        }
        Collection collection = processedClasses;
        synchronized (collection) {
            for (CtClass processedClass : processedClasses) {
                if (processedClass == clazz || processedClass.getRefClasses() == null || !clazz.getRefClasses().contains(clazz.getName())) continue;
                try {
                    processedClass.defrost();
                    byte[] previousByteCode = processedClass.toBytecode();
                    processedClass.defrost();
                    processedClass.instrument(codeConverter);
                    byte[] updatedByteCode = processedClass.toBytecode();
                    if (!Arrays.equals(updatedByteCode, previousByteCode)) {
                        hotSwapper.registerChange(classPool.getClassLoader().loadClass(processedClass.getName()), updatedByteCode);
                    }
                    processedClass.defrost();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (AspectManager.suppressTransformationErrors) {
                        System.err.println("[warn] AOP Instrumentor failed to updated wrapping status.");
                        e.printStackTrace();
                        continue;
                    }
                    if (e instanceof TransformationException) {
                        throw (TransformationException)e;
                    }
                    throw new RuntimeException("failed to update wrapping status", e);
                }
            }
        }
        hotSwapper.hotSwap();
    }

    protected abstract void doSetupBasics(CtClass var1) throws CannotCompileException, NotFoundException;

    protected abstract CtMethod createMixinInvokeMethod(CtClass var1, CtClass var2, String var3, CtMethod var4, long var5) throws CannotCompileException, NotFoundException, Exception;

    AspectManager getManager() {
        return this.manager;
    }

    private static class ReferenceClassIterator {
        int size;
        int current;
        ArrayList classes;
        HashSet handledClasses;
        String currentEntry;

        public ReferenceClassIterator(Collection refClasses) {
            this.size = refClasses.size();
            this.classes = new ArrayList(refClasses.size());
            this.classes.addAll(refClasses);
            this.handledClasses = new HashSet(refClasses.size());
        }

        boolean hasNext() {
            while (this.current < this.size) {
                String s;
                if (this.handledClasses.contains(s = (String)this.classes.get(this.current++))) continue;
                this.handledClasses.add(s);
                this.currentEntry = s;
                return true;
            }
            return false;
        }

        String next() {
            return this.currentEntry;
        }

        void addSuperClass(CtClass clazz) throws NotFoundException {
            String name;
            CtClass superClass;
            if (clazz != null && (superClass = clazz.getSuperclass()) != null && !this.handledClasses.contains(name = superClass.getName())) {
                this.classes.add(name);
                ++this.size;
            }
        }
    }
}

