/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployer;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.deployers.plugins.structure.ComponentDeploymentContext;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.deployers.spi.classloader.ClassLoaderFactory;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployers.spi.structure.DeploymentContext;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractDeploymentUnit
implements DeploymentUnit,
Serializable {
    private static final Logger log = Logger.getLogger(AbstractDeploymentUnit.class);
    private static final long serialVersionUID = 1L;
    private DeploymentContext deploymentContext;

    public AbstractDeploymentUnit(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            throw new IllegalArgumentException("Null deployment context");
        }
        this.deploymentContext = deploymentContext;
    }

    @Override
    public String getName() {
        return this.deploymentContext.getName();
    }

    @Override
    public String getSimpleName() {
        return this.deploymentContext.getSimpleName();
    }

    @Override
    public String getRelativePath() {
        return this.deploymentContext.getRelativePath();
    }

    @Override
    public Set<String> getTypes() {
        return this.deploymentContext.getTypes();
    }

    @Override
    public VirtualFile getFile(String name) {
        VirtualFile file;
        block2: {
            VirtualFile root = this.deploymentContext.getRoot();
            file = null;
            try {
                file = root.findChild(name);
            }
            catch (Exception e) {
                if (!log.isTraceEnabled()) break block2;
                log.trace("Failed to find: " + name, e);
            }
        }
        return file;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader cl = this.deploymentContext.getClassLoader();
        if (cl == null) {
            throw new IllegalStateException("ClassLoader has not been set");
        }
        this.deploymentContext.deployed();
        return cl;
    }

    @Override
    public boolean createClassLoader(ClassLoaderFactory factory) throws DeploymentException {
        return this.deploymentContext.createClassLoader(factory);
    }

    @Override
    public VirtualFile getMetaDataFile(String name) {
        return this.deploymentContext.getMetaDataFile(name);
    }

    @Override
    public List<VirtualFile> getMetaDataFiles(String name, String suffix) {
        return this.deploymentContext.getMetaDataFiles(name, suffix);
    }

    @Override
    public DeploymentUnit addComponent(String name) {
        ComponentDeploymentContext component = new ComponentDeploymentContext(name, this.deploymentContext);
        AbstractDeploymentUnit unit = new AbstractDeploymentUnit(component);
        component.setDeploymentUnit(unit);
        this.deploymentContext.addComponent(component);
        return unit;
    }

    @Override
    public boolean removeComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        for (DeploymentContext component : this.deploymentContext.getComponents()) {
            if (!name.equals(component.getName())) continue;
            return this.deploymentContext.removeComponent(component);
        }
        return false;
    }

    @Override
    public Map<String, Object> getAllMetaData() {
        DeploymentContext parent = this.deploymentContext.getParent();
        if (!this.deploymentContext.isComponent()) {
            parent = null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (parent != null) {
            result.putAll(parent.getTransientAttachments().getAttachments());
        }
        result.putAll(this.deploymentContext.getTransientAttachments().getAttachments());
        if (parent != null) {
            result.putAll(parent.getTransientManagedObjects().getAttachments());
        }
        result.putAll(this.deploymentContext.getTransientManagedObjects().getAttachments());
        if (parent != null) {
            result.putAll(parent.getPredeterminedManagedObjects().getAttachments());
        }
        result.putAll(this.deploymentContext.getPredeterminedManagedObjects().getAttachments());
        if (!result.isEmpty()) {
            this.deploymentContext.deployed();
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    public Object addAttachment(String name, Object attachment) {
        this.deploymentContext.deployed();
        Object prevAttachment = this.deploymentContext.getTransientAttachments().addAttachment(name, attachment);
        return prevAttachment;
    }

    @Override
    public <T> T addAttachment(Class<T> type, T attachment) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.addAttachment(type.getName(), attachment, type);
    }

    @Override
    public <T> T addAttachment(String name, T attachment, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.addAttachment(name, attachment);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T getAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(name);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T getAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.getAttachment(type.getName(), type);
    }

    @Override
    public Attachments getAttachments() {
        return null;
    }

    @Override
    public Attachments getTransientAttachments() {
        return this.deploymentContext.getTransientAttachments();
    }

    @Override
    public Object getAttachment(String name) {
        Object result;
        DeploymentContext parent = this.deploymentContext.getParent();
        if (!this.deploymentContext.isComponent()) {
            parent = null;
        }
        if ((result = this.deploymentContext.getPredeterminedManagedObjects().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getPredeterminedManagedObjects().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        result = this.deploymentContext.getTransientManagedObjects().getAttachment(name);
        if (result != null) {
            this.deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getTransientManagedObjects().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        result = this.deploymentContext.getTransientAttachments().getAttachment(name);
        if (result != null) {
            this.deploymentContext.deployed();
            return result;
        }
        if (parent != null && (result = parent.getTransientAttachments().getAttachment(name)) != null) {
            this.deploymentContext.deployed();
            return result;
        }
        return null;
    }

    public boolean isAttachmentPresent(String name) {
        DeploymentContext parent = this.deploymentContext.getParent();
        if (!this.deploymentContext.isComponent()) {
            parent = null;
        }
        if (this.deploymentContext.getPredeterminedManagedObjects().isAttachmentPresent(name)) {
            this.deploymentContext.deployed();
            return true;
        }
        if (parent != null && parent.getPredeterminedManagedObjects().isAttachmentPresent(name)) {
            this.deploymentContext.deployed();
            return true;
        }
        if (this.deploymentContext.getTransientManagedObjects().isAttachmentPresent(name)) {
            this.deploymentContext.deployed();
            return true;
        }
        if (parent != null && parent.getTransientAttachments().isAttachmentPresent(name)) {
            this.deploymentContext.deployed();
            return true;
        }
        if (this.deploymentContext.getTransientAttachments().isAttachmentPresent(name)) {
            this.deploymentContext.deployed();
            return true;
        }
        if (parent != null && parent.getTransientAttachments().isAttachmentPresent(name)) {
            this.deploymentContext.deployed();
            return true;
        }
        return false;
    }

    @Override
    public <T> T removeAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.removeAttachment(name);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T removeAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.removeAttachment(type.getName(), type);
    }

    @Override
    public Object removeAttachment(String name) {
        Object attachment = null;
        if (this.deploymentContext.getTransientManagedObjects().isAttachmentPresent(name)) {
            attachment = this.deploymentContext.getTransientManagedObjects().removeAttachment(name);
        }
        if (this.deploymentContext.getTransientAttachments().isAttachmentPresent(name)) {
            Object ta = this.deploymentContext.getTransientAttachments().removeAttachment(name);
            if (attachment == null) {
                attachment = ta;
            }
        }
        return attachment;
    }

    @Override
    public Attachments getTransientManagedObjects() {
        return this.deploymentContext.getTransientManagedObjects();
    }

    public boolean hasAttachments() {
        boolean hasAttachments = false;
        DeploymentContext parent = this.deploymentContext.getParent();
        if (!this.deploymentContext.isComponent()) {
            parent = null;
        }
        if (parent != null) {
            hasAttachments = parent.getTransientAttachments().hasAttachments();
        }
        if (!(hasAttachments |= this.deploymentContext.getTransientAttachments().hasAttachments())) {
            if (parent != null) {
                hasAttachments |= parent.getTransientManagedObjects().hasAttachments();
            }
            hasAttachments |= this.deploymentContext.getTransientManagedObjects().hasAttachments();
            if (parent != null) {
                hasAttachments |= parent.getPredeterminedManagedObjects().hasAttachments();
            }
            hasAttachments |= this.deploymentContext.getPredeterminedManagedObjects().hasAttachments();
        }
        return hasAttachments;
    }

    public int getChangeCount() {
        int count = this.deploymentContext.getTransientAttachments().getChangeCount() + this.deploymentContext.getTransientManagedObjects().getChangeCount();
        return count;
    }

    public void clearChangeCount() {
        this.deploymentContext.getTransientAttachments().clearChangeCount();
        this.deploymentContext.getTransientManagedObjects().clearChangeCount();
    }

    @Override
    public <T> Set<? extends T> getAllMetaData(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        HashSet<Object> result = new HashSet<Object>();
        Map<String, Object> attachments = this.getAllMetaData();
        for (Object object : attachments.values()) {
            if (!type.isInstance(object)) continue;
            result.add(object);
        }
        if (!result.isEmpty()) {
            this.deploymentContext.deployed();
        }
        return result;
    }

    @Override
    public DeploymentUnit getParent() {
        DeploymentContext parentCtx = this.deploymentContext.getParent();
        DeploymentUnit parent = null;
        if (parentCtx != null) {
            parent = parentCtx.getDeploymentUnit();
        }
        return parent;
    }

    @Override
    @Deprecated
    public DeploymentContext getDeploymentContext() {
        this.deploymentContext.deployed();
        return this.deploymentContext;
    }
}

