/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.io.InputStream;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.jboss.deployers.plugins.deployers.helpers.JAXPDeployer;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.util.xml.DOMWriter;
import org.jboss.util.xml.JBossErrorHandler;
import org.jboss.virtual.VirtualFile;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XSLDeployer<T>
extends JAXPDeployer<T> {
    protected String xslPath;
    private Templates templates;

    public XSLDeployer(Class<T> deploymentType) {
        super(deploymentType);
    }

    public String getXSLPath() {
        return this.xslPath;
    }

    public void setXSLPath(String xslPath) {
        this.xslPath = xslPath;
    }

    public Templates getTemplates() {
        if (this.templates == null) {
            throw new IllegalStateException("Templates have not been constructed");
        }
        return this.templates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create() throws Exception {
        super.create();
        TransformerFactory tf = TransformerFactory.newInstance();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.xslPath);
        try {
            StreamSource ss = new StreamSource(is);
            ss.setSystemId(this.xslPath);
            this.templates = tf.newTemplates(ss);
            this.log.debug("Created templates: " + this.templates);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.templates = null;
    }

    @Override
    protected T parse(DeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        Document document = this.doParse(unit, file);
        Transformer trans = this.getTemplates().newTransformer();
        trans.setErrorListener(new JBossErrorHandler(file.getPathName(), null));
        DOMSource s = new DOMSource(document);
        DOMResult r = new DOMResult();
        this.setParameters(trans);
        trans.transform(s, r);
        document = (Document)r.getNode();
        String docStr = DOMWriter.printNode(document, true);
        this.log.debug("Transformed " + file.getPathName() + " into " + docStr);
        return this.parse(unit, file, document);
    }

    protected void setParameters(Transformer trans) throws Exception {
    }

    @Override
    protected abstract T parse(DeploymentUnit var1, VirtualFile var2, Document var3) throws Exception;
}

