/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import javax.management.ObjectName;
import org.jboss.deployers.plugins.deployers.helpers.ObjectModelFactoryDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.EARDeployment;
import org.jboss.deployment.J2eeApplicationMetaData;
import org.jboss.deployment.JBossApplicationObjectFactory;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.xb.binding.ObjectModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAppParsingDeployer
extends ObjectModelFactoryDeployer<J2eeApplicationMetaData> {
    private String appXmlPath = "jboss-app.xml";
    private boolean isolated = false;
    private boolean callByValue = false;

    public JBossAppParsingDeployer() {
        super(J2eeApplicationMetaData.class);
        this.setRelativeOrder(2001);
    }

    public String getAppXmlPath() {
        return this.appXmlPath;
    }

    public void setAppXmlPath(String appXmlPath) {
        this.appXmlPath = appXmlPath;
    }

    public boolean isIsolated() {
        return this.isolated;
    }

    public void setIsolated(boolean isolated) {
        this.isolated = isolated;
    }

    public boolean isCallByValue() {
        return this.callByValue;
    }

    public void setCallByValue(boolean callByValue) {
        this.callByValue = callByValue;
    }

    @Override
    protected boolean allowsReparse() {
        return true;
    }

    @Override
    protected ObjectModelFactory getObjectModelFactory(J2eeApplicationMetaData root) {
        return new JBossApplicationObjectFactory();
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        this.createMetaData(unit, this.appXmlPath, null);
        J2eeApplicationMetaData earMetaData = unit.getAttachment(J2eeApplicationMetaData.class);
        if (earMetaData != null) {
            LoaderRepositoryFactory.LoaderRepositoryConfig loaderCfg = earMetaData.getLoaderCfg();
            if (loaderCfg == null && this.isolated) {
                loaderCfg = this.initLoaderRepository(earMetaData, unit);
            }
            if (loaderCfg != null) {
                unit.addAttachment(LoaderRepositoryFactory.LoaderRepositoryConfig.class, loaderCfg);
            }
        }
        if (this.callByValue) {
            unit.addAttachment("EAR.callByValue", Boolean.TRUE, Boolean.class);
        }
    }

    protected LoaderRepositoryFactory.LoaderRepositoryConfig initLoaderRepository(J2eeApplicationMetaData metaData, DeploymentUnit unit) throws DeploymentException {
        try {
            String name = EARDeployment.getJMXName(metaData, unit) + ",extension=LoaderRepository";
            ObjectName objectName = new ObjectName(name);
            LoaderRepositoryFactory.LoaderRepositoryConfig config = new LoaderRepositoryFactory.LoaderRepositoryConfig();
            config.repositoryName = objectName;
            return config;
        }
        catch (Exception e) {
            throw new DeploymentException("Failed to create LoaderRepositoryConfig", e);
        }
    }
}

