/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContextException;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.SecurityIdentityMetaData;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityRolesAssociation;
import org.jboss.security.Util;
import org.jboss.security.audit.AuditEvent;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.audit.SecurityAuditManager;
import org.jboss.security.authorization.EJBResource;
import org.jboss.system.Registry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityInterceptor
extends AbstractInterceptor {
    protected AuthenticationManager securityManager;
    protected AuthorizationManager authorizationManager;
    protected RealmMapping realmMapping;
    protected RunAsIdentity runAsIdentity;
    protected Map securityRoles;
    protected Map deploymentRoles;
    protected AuthenticationObserver authenticationObserver;
    protected Method ejbTimeout;
    protected String ejbName = null;
    protected CodeSource ejbCS = null;
    protected String appSecurityDomain = null;
    protected String defaultAuthorizationSecurityDomain = "jboss-ejb-policy";
    protected boolean isUseCallerIdentity = false;

    @Override
    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.securityRoles = assemblyDescriptor.getSecurityRoles();
            this.deploymentRoles = assemblyDescriptor.getPrincipalVersusRolesMap();
            SecurityIdentityMetaData secMetaData = beanMetaData.getSecurityIdentityMetaData();
            if (secMetaData != null && !secMetaData.getUseCallerIdentity()) {
                String roleName = secMetaData.getRunAsRoleName();
                String principalName = secMetaData.getRunAsPrincipalName();
                Set extraRoleNames = assemblyDescriptor.getSecurityRoleNamesByPrincipal(principalName);
                this.runAsIdentity = new RunAsIdentity(roleName, principalName, extraRoleNames);
            }
            if (secMetaData != null && secMetaData.getUseCallerIdentity()) {
                this.isUseCallerIdentity = true;
            }
            this.securityManager = container.getSecurityManager();
            this.realmMapping = container.getRealmMapping();
            this.authorizationManager = container.getAuthorizationManager();
            try {
                this.ejbTimeout = TimedObject.class.getMethod("ejbTimeout", Timer.class);
            }
            catch (NoSuchMethodException ignore) {
                // empty catch block
            }
            if (this.securityManager != null) {
                this.appSecurityDomain = this.securityManager.getSecurityDomain();
                this.appSecurityDomain = Util.unprefixSecurityDomain(this.appSecurityDomain);
            }
            this.ejbName = beanMetaData.getEjbName();
            this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
        }
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.authenticationObserver = (AuthenticationObserver)Registry.lookup("SecurityInterceptor.AuthenticationObserver");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invokeHome(Invocation mi) throws Exception {
        RunAsIdentity callerRunAsIdentity;
        this.checkSecurityAssociation(mi);
        if (SecurityActions.getSecurityContext() == null) {
            SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), this.appSecurityDomain);
        }
        if ((callerRunAsIdentity = this.getCallerRunAsIdentity(mi)) != null && this.isUseCallerIdentity) {
            this.runAsIdentity = callerRunAsIdentity;
        }
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invokeHome(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
            SecurityActions.clearSecurityContext(this.appSecurityDomain);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Invocation mi) throws Exception {
        RunAsIdentity callerRunAsIdentity;
        this.checkSecurityAssociation(mi);
        if (SecurityActions.getSecurityContext() == null) {
            SecurityActions.createAndSetSecurityContext(mi.getPrincipal(), mi.getCredential(), this.appSecurityDomain);
        }
        if ((callerRunAsIdentity = this.getCallerRunAsIdentity(mi)) != null && this.isUseCallerIdentity) {
            this.runAsIdentity = callerRunAsIdentity;
        }
        SecurityActions.pushRunAsIdentity(this.runAsIdentity);
        try {
            Object returnValue;
            Object object = returnValue = this.getNext().invoke(mi);
            return object;
        }
        finally {
            SecurityActions.popRunAsIdentity();
            SecurityActions.popSubjectContext();
            SecurityActions.clearSecurityContext(this.appSecurityDomain);
        }
    }

    protected boolean isTrustedCaller(Invocation inv) {
        RunAsIdentity callerRunAsIdentity;
        boolean trusted = false;
        SecurityContext callerSC = this.getInvocationSecurityContext(inv);
        if (callerSC != null && (callerRunAsIdentity = this.getCallerRunAsIdentity(inv)) != null) {
            Boolean intervm = (Boolean)inv.getAsIsPayload().get(InvocationKey.INTERVM);
            trusted = intervm == null || intervm == Boolean.FALSE || inv.isSecure() != false;
        }
        return trusted;
    }

    private SecurityContext getInvocationSecurityContext(Invocation inv) {
        return (SecurityContext)inv.getAsIsPayload().get(InvocationKey.SECURITY_CONTEXT);
    }

    private void checkSecurityAssociation(Invocation mi) throws Exception {
        boolean containerMethod;
        Principal principal = mi.getPrincipal();
        Object credential = mi.getCredential();
        boolean trace = this.log.isTraceEnabled();
        Method m = mi.getMethod();
        boolean bl = containerMethod = m == null || m.equals(this.ejbTimeout);
        if (containerMethod || this.securityManager == null || this.container == null) {
            SecurityActions.pushSubjectContext(principal, credential, null);
            return;
        }
        if (this.realmMapping == null) {
            throw new SecurityException("Role mapping manager has not been set");
        }
        if (!this.isTrustedCaller(mi)) {
            Subject subject = new Subject();
            if (!this.securityManager.isValid(principal, credential, subject)) {
                if (this.authenticationObserver != null) {
                    this.authenticationObserver.authenticationFailed();
                }
                Exception ex = SecurityActions.getContextException();
                this.audit("Error", this.getContextMap(principal, m.getName()), ex);
                if (ex != null) {
                    throw ex;
                }
                String msg = "Authentication exception, principal=" + principal;
                SecurityException e = new SecurityException(msg);
                this.audit("Failure", this.getContextMap(principal, m.getName()), null);
                throw e;
            }
            SecurityActions.pushSubjectContext(principal, credential, subject);
            this.establishSecurityContext(this.securityManager.getSecurityDomain(), principal, credential, subject);
            this.audit("Success", this.getContextMap(principal, m.getName()), null);
            if (trace) {
                this.log.trace("Authenticated  principal=" + principal);
            }
        } else {
            SecurityActions.dupSubjectContext();
            this.establishSecurityContext(this.securityManager.getSecurityDomain(), principal, credential, null);
        }
        Method ejbMethod = mi.getMethod();
        if (ejbMethod == null) {
            return;
        }
        Subject caller = this.getContextCallerSubject();
        SecurityRolesAssociation.setSecurityRoles(this.deploymentRoles);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ejb.name", this.ejbName);
        map.put("ejb.method", ejbMethod);
        map.put("ejb.principal", mi.getPrincipal());
        map.put("ejb.methodInterface", mi.getType().toInterfaceString());
        map.put("ejb.codeSource", this.ejbCS);
        map.put("caller.subject", caller);
        map.put("authorizationManager", this.authorizationManager);
        map.put("runAsIdentity", this.getCallerRunAsIdentity(mi));
        map.put("ejb.methodRoles", this.container.getMethodPermissions(ejbMethod, mi.getType()));
        EJBResource ejbResource = new EJBResource(map);
        boolean isAuthorized = false;
        try {
            int check = this.authorizationManager.authorize(ejbResource);
            isAuthorized = check == 1;
            this.authorizationAudit(isAuthorized ? "Success" : "Failure", ejbResource, null);
        }
        catch (Exception e) {
            isAuthorized = false;
            if (trace) {
                this.log.trace("Error in authorization:", e);
            }
            this.authorizationAudit("Error", ejbResource, e);
        }
        String msg = "Denied: caller=" + caller;
        if (!isAuthorized) {
            throw new SecurityException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Subject getContextCallerSubject() throws PolicyContextException {
        Subject caller = null;
        caller = SecurityActions.getContextSubject();
        return caller;
    }

    private RunAsIdentity getCallerRunAsIdentity(Invocation inv) {
        RunAsIdentity callerRAI = null;
        SecurityContext callerSC = (SecurityContext)inv.getAsIsPayload().get(InvocationKey.SECURITY_CONTEXT);
        if (callerSC != null) {
            callerRAI = (RunAsIdentity)callerSC.getUtil().get(callerSC, "RunAsIdentity");
        }
        return callerRAI;
    }

    private void audit(String level, Map<String, Object> contextMap, Exception e) {
        contextMap.put("Source", this.getClass().getName());
        AuditEvent ae = new AuditEvent(level);
        ae.setContextMap(contextMap);
        ae.setUnderlyingException(e);
        String secDomain = this.securityManager.getSecurityDomain();
        SecurityContext sc = SecurityActions.getSecurityContext(secDomain);
        if (sc != null) {
            SecurityAuditManager sam = sc.getAuditManager();
            sam.audit(ae);
        } else {
            AuditManager.getAuditContext(secDomain).audit(ae);
        }
    }

    private void authorizationAudit(String level, EJBResource resource, Exception e) {
        String exceptionMessage = e != null ? e.getLocalizedMessage() : "";
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.putAll(resource.getMap());
        cmap.put("Exception:", exceptionMessage);
        this.audit(level, cmap, null);
    }

    private Map<String, Object> getContextMap(Principal principal, String methodName) {
        HashMap<String, Object> cmap = new HashMap<String, Object>();
        cmap.put("principal", principal);
        cmap.put("method", methodName);
        return cmap;
    }

    private void establishSecurityContext(String domain, Principal p, Object cred, Subject subject) {
        SecurityActions.createAndSetSecurityContext(p, cred, domain, subject);
    }

    public static interface AuthenticationObserver {
        public static final String KEY = "SecurityInterceptor.AuthenticationObserver";

        public void authenticationFailed();
    }
}

