/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc2;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.ejb.FinderException;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.jdbc.EJBQLToSQL92Compiler;
import org.jboss.ejb.plugins.cmp.jdbc.QueryParameter;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCDynamicQLQueryMetaData;
import org.jboss.ejb.plugins.cmp.jdbc2.AbstractQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.JDBCStoreManager2;
import org.jboss.ejb.plugins.cmp.jdbc2.QueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCCMPFieldBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.bridge.JDBCEntityBridge2;
import org.jboss.ejb.plugins.cmp.jdbc2.schema.Schema;
import org.jboss.logging.Logger;

public class DynamicQueryCommand
implements QueryCommand {
    private Logger log;
    private JDBCEntityBridge2 entity;
    private JDBCDynamicQLQueryMetaData metadata;
    private AbstractQueryCommand.CollectionFactory collectionFactory;

    public DynamicQueryCommand(JDBCEntityBridge2 entity, JDBCDynamicQLQueryMetaData metadata) {
        this.log = Logger.getLogger(this.getClass().getName() + "." + entity.getEntityName() + "#" + metadata.getMethod().getName());
        this.entity = entity;
        this.metadata = metadata;
        Class<?> returnType = metadata.getMethod().getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            this.collectionFactory = Set.class.isAssignableFrom(returnType) ? AbstractQueryCommand.SET_FACTORY : AbstractQueryCommand.COLLECTION_FACTORY;
        }
    }

    public JDBCStoreManager2 getStoreManager() {
        return (JDBCStoreManager2)this.entity.getManager();
    }

    public Collection fetchCollection(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("executing dynamic-ql: " + args[0]);
        }
        JDBCStoreManager2 manager = (JDBCStoreManager2)this.entity.getManager();
        EJBQLToSQL92Compiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
        try {
            compiler.compileJBossQL((String)args[0], this.metadata.getMethod().getReturnType(), DynamicQueryCommand.getParamTypes(args), this.metadata);
        }
        catch (Throwable t) {
            this.log.error("Error compiling JBossQL statement '" + args[0] + "'", t);
            throw new FinderException("Error compiling JBossQL statement '" + args[0] + "'");
        }
        String sql = compiler.getSQL();
        AbstractQueryCommand.ResultReader resultReader = !compiler.isSelectEntity() ? (compiler.isSelectField() ? new AbstractQueryCommand.FieldReader((JDBCCMPFieldBridge2)compiler.getSelectField()) : new AbstractQueryCommand.FunctionReader(compiler.getSelectFunction())) : new AbstractQueryCommand.EntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
        return AbstractQueryCommand.fetchCollection(this.entity, sql, DynamicQueryCommand.toArray(compiler.getInputParameters()), new AbstractQueryCommand.EagerCollectionStrategy(this.collectionFactory, resultReader, this.log), schema, factory, (Object[])args[1], this.log);
    }

    public Object fetchOne(Schema schema, GenericEntityObjectFactory factory, Object[] args) throws FinderException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("executing dynamic-ql: " + args[0]);
        }
        JDBCStoreManager2 manager = (JDBCStoreManager2)this.entity.getManager();
        EJBQLToSQL92Compiler compiler = new EJBQLToSQL92Compiler(manager.getCatalog());
        try {
            compiler.compileJBossQL((String)args[0], this.metadata.getMethod().getReturnType(), DynamicQueryCommand.getParamTypes(args), this.metadata);
        }
        catch (Throwable t) {
            this.log.error("Error compiling JBossQL statement '" + args[0] + "'", t);
            throw new FinderException("Error compiling JBossQL statement '" + args[0] + "'");
        }
        String sql = compiler.getSQL();
        AbstractQueryCommand.ResultReader resultReader = !compiler.isSelectEntity() ? (compiler.isSelectField() ? new AbstractQueryCommand.FieldReader((JDBCCMPFieldBridge2)compiler.getSelectField()) : new AbstractQueryCommand.FunctionReader(compiler.getSelectFunction())) : new AbstractQueryCommand.EntityReader((JDBCEntityBridge2)compiler.getSelectEntity(), compiler.isSelectDistinct());
        return AbstractQueryCommand.fetchOne(this.entity, sql, DynamicQueryCommand.toArray(compiler.getInputParameters()), resultReader, (Object[])args[1], factory, this.log);
    }

    private static Class[] getParamTypes(Object[] args) throws FinderException {
        Class[] parameterTypes;
        Object[] parameters = (Object[])args[1];
        if (parameters == null) {
            parameterTypes = new Class[]{};
        } else {
            parameterTypes = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i] == null) {
                    throw new FinderException("Parameter[" + i + "] is null");
                }
                parameterTypes[i] = parameters[i].getClass();
            }
        }
        return parameterTypes;
    }

    static QueryParameter[] toArray(List p) {
        QueryParameter[] params = null;
        if (p.size() > 0) {
            params = p.toArray(new QueryParameter[p.size()]);
        }
        return params;
    }
}

