/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.JndiProxyFactory;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.session.BaseSessionProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public abstract class BaseStatefulProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatefulProxyFactory.class);
    protected Class proxyClass;
    protected Constructor proxyConstructor;
    protected Context proxyFactoryContext;
    protected String jndiName;
    public static final String PROXY_FACTORY_NAME = "StatefulProxyFactory";

    public void init() throws Exception {
        this.initializeJndiName();
        Class[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), interfaces);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        this.proxyConstructor = proxyClass.getConstructor(constructorParams);
    }

    public void start() throws Exception {
        this.init();
        Context ctx = this.container.getInitialContext();
        Name name = ctx.getNameParser("").parse(this.jndiName);
        ctx = Util.createSubcontext(ctx, name.getPrefix(name.size() - 1));
        String atom = name.get(name.size() - 1);
        StringRefAddr refAddr = new StringRefAddr("FACTORY", this.jndiName + PROXY_FACTORY_NAME);
        Reference ref = new Reference("java.lang.Object", refAddr, JndiProxyFactory.class.getName(), null);
        try {
            Util.rebind(ctx, atom, (Object)ref);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful proxy with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + ctx.getNameInNamespace() + "/" + atom);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.container.getInitialContext(), this.jndiName);
    }

    protected abstract Class[] getInterfaces();

    protected abstract void initializeJndiName();
}

