/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.annotation.ejb.Clustered;
import org.jboss.annotation.ejb.RemoteBinding;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.Remoting;
import org.jboss.ejb3.JBossProxy;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.stateful.StatefulClusteredProxy;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ejb3.stateful.StatefulHandleImpl;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.FirstAvailable;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.LoadBalancePolicy;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.naming.Util;
import org.jboss.remoting.InvokerLocator;

public class StatefulClusterProxyFactory
extends BaseStatefulProxyFactory
implements RemoteProxyFactory {
    public static final String FACTORY_ATTRIBUTE = ",element=ProxyFactory,partition=";
    private RemoteBinding binding;
    private InvokerLocator locator;
    private HATarget hatarget;
    private String proxyFamilyName;
    private LoadBalancePolicy lbPolicy;
    private FamilyWrapper wrapper;

    public void setRemoteBinding(RemoteBinding binding) {
        this.binding = binding;
    }

    protected Class[] getInterfaces() {
        Class[] remoteInterfaces = ProxyFactoryHelper.getRemoteInterfaces(this.container);
        Class[] interfaces = new Class[remoteInterfaces.length + 1];
        System.arraycopy(remoteInterfaces, 0, interfaces, 0, remoteInterfaces.length);
        interfaces[remoteInterfaces.length] = JBossProxy.class;
        return interfaces;
    }

    protected void initializeJndiName() {
        this.jndiName = ProxyFactoryHelper.getRemoteJndiName(this.container, this.binding);
    }

    public void start() throws Exception {
        String clientBindUrl = ProxyFactoryHelper.getClientBindUrl(this.binding);
        this.locator = new InvokerLocator(clientBindUrl);
        Clustered clustered = (Clustered)this.advisor.resolveAnnotation(Clustered.class);
        if (clustered == null) {
            throw new RuntimeException("Could not find @Clustered annotation.  Cannot deploy.");
        }
        String partitionName = ((StatefulContainer)this.container).getPartitionName();
        this.proxyFamilyName = this.container.getEjbName() + this.locator.getProtocol() + partitionName;
        HAPartition partition = (HAPartition)this.container.getInitialContext().lookup("/HAPartition/" + partitionName);
        this.hatarget = new HATarget(partition, this.proxyFamilyName, (Serializable)this.locator, 2);
        ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (List)this.hatarget.getReplicants());
        ((StatefulContainer)this.container).getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
        this.lbPolicy = clustered.loadBalancePolicy() == null || clustered.loadBalancePolicy().equals(LoadBalancePolicy.class) ? new FirstAvailable() : (LoadBalancePolicy)clustered.loadBalancePolicy().newInstance();
        this.wrapper = new FamilyWrapper(this.proxyFamilyName, this.hatarget.getReplicants());
        super.start();
        Class[] interfaces = new Class[]{ProxyFactory.class};
        String targetId = this.getTargetId();
        Object factoryProxy = Remoting.createPojiProxy(targetId, interfaces, ProxyFactoryHelper.getClientBindUrl(this.binding));
        try {
            Util.rebind((Context)this.container.getInitialContext(), this.jndiName + "StatefulProxyFactory", factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful cluster proxy with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        Dispatcher.singleton.registerTarget(targetId, this);
    }

    public Object createProxy() {
        try {
            String containerId = this.container.getObjectName().getCanonicalName();
            String stackName = "ClusteredStatefulSessionClientInterceptors";
            if (this.binding.interceptorStack() != null && !this.binding.interceptorStack().equals("")) {
                stackName = this.binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            String partitionName = ((StatefulContainer)this.container).getPartitionName();
            Object[] args = new Object[]{new StatefulClusteredProxy(containerId, stack.createInterceptors((Advisor)((Object)this.container), null), this.wrapper, this.lbPolicy, partitionName)};
            return this.proxyConstructor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getTargetException());
        }
    }

    public Object createProxy(Object id) {
        throw new RuntimeException("NYI");
    }

    public void stop() throws Exception {
        Dispatcher.singleton.unregisterTarget(this.getTargetId());
        this.hatarget.destroy();
        ((StatefulContainer)this.container).getClusterFamilies().remove(this.proxyFamilyName);
        Util.unbind((Context)this.container.getInitialContext(), this.jndiName + "StatefulProxyFactory");
        super.stop();
    }

    protected StatefulHandleImpl getHandle() {
        StatefulHandleImpl handle = new StatefulHandleImpl();
        RemoteBinding remoteBinding = (RemoteBinding)this.advisor.resolveAnnotation(RemoteBinding.class);
        if (remoteBinding != null) {
            handle.jndiName = remoteBinding.jndiBinding();
        }
        return handle;
    }

    protected String getTargetId() {
        String partition = ((StatefulContainer)this.container).getPartitionName();
        return this.container.getObjectName().getCanonicalName() + FACTORY_ATTRIBUTE + partition;
    }
}

