/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded;

import java.net.URL;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;
import org.jboss.logging.Logger;

public class WebInfLibScanner
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(WebInfLibScanner.class);
    private DeploymentGroup group = Bootstrap.getInstance().createDeploymentGroup();

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.scan(servletContextEvent, "/WEB-INF/lib");
    }

    protected void scan(ServletContextEvent servletContextEvent, String path) {
        try {
            ServletContext servletContext = servletContextEvent.getServletContext();
            Set libJars = servletContext.getResourcePaths(path);
            for (Object jar : libJars) {
                URL archive = servletContext.getResource((String)jar);
                this.group.add(archive);
            }
            this.group.process();
        }
        catch (Exception e) {
            try {
                this.group.undeploy();
            }
            catch (DeploymentException e1) {
                log.warn("failed to undeploy on error");
            }
            log.error("failed to deploy from ServletListenerDeployer", e);
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            this.group.undeploy();
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }
}

