/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.delegate;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.jms.JMSException;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.container.JMSClientVMIdentifier;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.server.Version;
import org.jboss.jms.server.endpoint.CreateConnectionResult;
import org.jboss.jms.server.remoting.JMSWireFormat;
import org.jboss.jms.util.MessagingNetworkFailureException;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateRequest;
import org.jboss.jms.wireformat.ConnectionFactoryGetClientAOPStackRequest;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class ClientConnectionFactoryDelegate
extends DelegateSupport
implements ConnectionFactoryDelegate,
Serializable,
Advised {
    private static final long serialVersionUID = 2512460695662741413L;
    private String serverLocatorURI;
    private Version serverVersion;
    private int serverID;
    private boolean clientPing;
    private static ClassAdvisor aop$classAdvisor$aop = AspectManager.instance().getAdvisor(Class.forName("org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate"));
    protected transient ClassInstanceAdvisor _instanceAdvisor;
    private static WeakReference aop$MethodInfo_createConnectionDelegate4579211046834694258;
    private static WeakReference aop$MethodInfo_getClientAOPStack7161396531404689859;

    public static Version getVersionToUse(Version connectionVersion) {
        Version clientVersion = Version.instance();
        Version versionToUse = connectionVersion.getProviderIncrementingVersion() <= clientVersion.getProviderIncrementingVersion() ? connectionVersion : clientVersion;
        return versionToUse;
    }

    public ClientConnectionFactoryDelegate(int objectID, int serverID, String serverLocatorURI, Version serverVersion, boolean clientPing) {
        super(objectID);
        this.serverID = serverID;
        this.serverLocatorURI = serverLocatorURI;
        this.serverVersion = serverVersion;
        this.clientPing = clientPing;
    }

    public ClientConnectionFactoryDelegate() {
    }

    public CreateConnectionResult createConnectionDelegate(String string, String string2, int n) throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_createConnectionDelegate4579211046834694258.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            createConnectionDelegate_4579211046834694258 createConnectionDelegate_45792110468346942582 = new createConnectionDelegate_4579211046834694258(methodInfo, interceptorArray);
            createConnectionDelegate_45792110468346942582.arg0 = string;
            createConnectionDelegate_45792110468346942582.arg1 = string2;
            createConnectionDelegate_45792110468346942582.arg2 = n;
            createConnectionDelegate_45792110468346942582.setTargetObject(this);
            createConnectionDelegate_45792110468346942582.typedTargetObject = this;
            createConnectionDelegate_45792110468346942582.setAdvisor(aop$classAdvisor$aop);
            return (CreateConnectionResult)createConnectionDelegate_45792110468346942582.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(string, string2, n);
    }

    public byte[] getClientAOPStack() throws JMSException {
        MethodInfo methodInfo = (MethodInfo)aop$MethodInfo_getClientAOPStack7161396531404689859.get();
        ClassInstanceAdvisor classInstanceAdvisor = (ClassInstanceAdvisor)this._getInstanceAdvisor();
        Interceptor[] interceptorArray = methodInfo.getInterceptors();
        if (interceptorArray != (Object[])null || classInstanceAdvisor != null && classInstanceAdvisor.hasInstanceAspects) {
            if (classInstanceAdvisor != null) {
                interceptorArray = classInstanceAdvisor.getInterceptors(interceptorArray);
            }
            getClientAOPStack_7161396531404689859 getClientAOPStack_71613965314046898592 = new getClientAOPStack_7161396531404689859(methodInfo, interceptorArray);
            getClientAOPStack_71613965314046898592.setTargetObject(this);
            getClientAOPStack_71613965314046898592.typedTargetObject = this;
            getClientAOPStack_71613965314046898592.setAdvisor(aop$classAdvisor$aop);
            return (byte[])getClientAOPStack_71613965314046898592.invokeNext();
        }
        return this.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop();
    }

    public String toString() {
        return "ConnectionFactoryDelegate[" + this.id + ", SID=" + this.serverID + "]";
    }

    public String getServerLocatorURI() {
        return this.serverLocatorURI;
    }

    public int getServerID() {
        return this.serverID;
    }

    public boolean getClientPing() {
        return this.clientPing;
    }

    public Version getServerVersion() {
        return this.serverVersion;
    }

    public void synchronizeWith(DelegateSupport newDelegate) throws Exception {
        super.synchronizeWith(newDelegate);
    }

    private Client createClient() throws JMSException {
        Client client;
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("enableLease", String.valueOf(false));
        try {
            client = new Client(new InvokerLocator(this.serverLocatorURI), configuration);
            client.setSubsystem("JMS");
            client.connect();
        }
        catch (Exception e) {
            throw new MessagingNetworkFailureException("Failed to connect client", e);
        }
        client.setMarshaller(new JMSWireFormat());
        client.setUnMarshaller(new JMSWireFormat());
        return client;
    }

    public void read(DataInputStream in) throws Exception {
        super.read(in);
        this.serverLocatorURI = in.readUTF();
        this.serverVersion = new Version();
        this.serverVersion.read(in);
        this.serverID = in.readInt();
        this.clientPing = in.readBoolean();
    }

    public void write(DataOutputStream out) throws Exception {
        super.write(out);
        out.writeUTF(this.serverLocatorURI);
        this.serverVersion.write(out);
        out.writeInt(this.serverID);
        out.writeBoolean(this.clientPing);
    }

    public Advisor _getAdvisor() {
        return aop$classAdvisor$aop;
    }

    public InstanceAdvisor _getInstanceAdvisor() {
        ClientConnectionFactoryDelegate clientConnectionFactoryDelegate = this;
        synchronized (clientConnectionFactoryDelegate) {
            if (this._instanceAdvisor == null) {
                this._instanceAdvisor = new ClassInstanceAdvisor(this);
            }
            return this._instanceAdvisor;
        }
    }

    public void _setInstanceAdvisor(InstanceAdvisor instanceAdvisor) {
        ClientConnectionFactoryDelegate clientConnectionFactoryDelegate = this;
        synchronized (clientConnectionFactoryDelegate) {
            this._instanceAdvisor = (ClassInstanceAdvisor)instanceAdvisor;
        }
    }

    public CreateConnectionResult org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(String username, String password, int failedNodeID) throws JMSException {
        CreateConnectionResult res;
        Version version = ClientConnectionFactoryDelegate.getVersionToUse(this.serverVersion);
        byte v = version.getProviderIncrementingVersion();
        JMSRemotingConnection remotingConnection = null;
        try {
            remotingConnection = new JMSRemotingConnection(this.serverLocatorURI, this.clientPing);
            remotingConnection.start();
            Client client = remotingConnection.getRemotingClient();
            String remotingSessionId = client.getSessionId();
            String clientVMId = JMSClientVMIdentifier.instance;
            ConnectionFactoryCreateConnectionDelegateRequest req = new ConnectionFactoryCreateConnectionDelegateRequest(this.id, v, remotingSessionId, clientVMId, username, password, failedNodeID);
            ResponseSupport rs = (ResponseSupport)client.invoke(req, null);
            res = (CreateConnectionResult)rs.getResponse();
        }
        catch (Throwable t) {
            if (remotingConnection != null) {
                try {
                    remotingConnection.stop();
                }
                catch (Throwable ignore) {
                    // empty catch block
                }
            }
            throw this.handleThrowable(t);
        }
        ClientConnectionDelegate connectionDelegate = res.getDelegate();
        if (connectionDelegate != null) {
            connectionDelegate.setRemotingConnection(remotingConnection);
            connectionDelegate.setVersionToUse(version);
            remotingConnection.getCallbackManager().setConnectionDelegate(connectionDelegate);
        } else {
            try {
                remotingConnection.stop();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return res;
    }

    public byte[] org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop() throws JMSException {
        Version version = ClientConnectionFactoryDelegate.getVersionToUse(this.serverVersion);
        byte v = version.getProviderIncrementingVersion();
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("enableLease", String.valueOf(false));
        Client theClient = this.createClient();
        ConnectionFactoryGetClientAOPStackRequest req = new ConnectionFactoryGetClientAOPStackRequest(this.id, v);
        return (byte[])this.doInvoke(theClient, req);
    }

    public static class createConnectionDelegate_4579211046834694258
    extends MethodInvocation
    implements Untransformable {
        public String arg0;
        public String arg1;
        public int arg2;
        public ClientConnectionFactoryDelegate typedTargetObject;

        public createConnectionDelegate_4579211046834694258(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public createConnectionDelegate_4579211046834694258(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public createConnectionDelegate_4579211046834694258(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public createConnectionDelegate_4579211046834694258() {
        }

        public Object invokeNext() throws Throwable {
            if (this.currentInterceptor < this.interceptors.length) {
                try {
                    Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                    Object var3_2 = null;
                    --this.currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --this.currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$createConnectionDelegate$aop(this.arg0, this.arg1, this.arg2);
        }

        public void setArguments(Object[] objectArray) {
            this.arguments = objectArray;
            Object object = objectArray[0];
            this.arg0 = (String)object;
            Object object2 = objectArray[1];
            this.arg1 = (String)object2;
            this.arg2 = (Integer)objectArray[2];
        }

        public Object[] getArguments() {
            if (this.marshalledArguments != null) {
                Object[] objectArray = super.getArguments();
                this.setArguments(objectArray);
                return objectArray;
            }
            if (this.arguments != (Object[])null) {
                return this.arguments;
            }
            this.arguments = new Object[3];
            this.arguments[0] = this.arg0;
            this.arguments[1] = this.arg1;
            new Integer(this.arg2);
            return this.arguments;
        }

        public Invocation copy() {
            createConnectionDelegate_4579211046834694258 createConnectionDelegate_45792110468346942582 = new createConnectionDelegate_4579211046834694258(this.interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
            createConnectionDelegate_45792110468346942582.arguments = this.arguments;
            createConnectionDelegate_45792110468346942582.metadata = this.metadata;
            createConnectionDelegate_45792110468346942582.currentInterceptor = this.currentInterceptor;
            createConnectionDelegate_45792110468346942582.instanceResolver = this.instanceResolver;
            createConnectionDelegate_45792110468346942582.typedTargetObject = this.typedTargetObject;
            createConnectionDelegate_45792110468346942582.targetObject = this.targetObject;
            createConnectionDelegate_45792110468346942582.arg0 = this.arg0;
            createConnectionDelegate_45792110468346942582.arg1 = this.arg1;
            createConnectionDelegate_45792110468346942582.arg2 = this.arg2;
            return createConnectionDelegate_45792110468346942582;
        }
    }

    public static class getClientAOPStack_7161396531404689859
    extends MethodInvocation
    implements Untransformable {
        public ClientConnectionFactoryDelegate typedTargetObject;

        public getClientAOPStack_7161396531404689859(MethodInfo methodInfo, Interceptor[] interceptorArray) {
            super(methodInfo, interceptorArray);
        }

        public getClientAOPStack_7161396531404689859(Interceptor[] interceptorArray, long l, Method method, Method method2, Advisor advisor) {
            super(interceptorArray, l, method, method2, advisor);
        }

        public getClientAOPStack_7161396531404689859(Interceptor[] interceptorArray) {
            super(interceptorArray);
        }

        public getClientAOPStack_7161396531404689859() {
        }

        public Object invokeNext() throws Throwable {
            if (this.currentInterceptor < this.interceptors.length) {
                try {
                    Object object = this.interceptors[this.currentInterceptor++].invoke(this);
                    Object var3_2 = null;
                    --this.currentInterceptor;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    --this.currentInterceptor;
                    throw throwable;
                }
            }
            return this.typedTargetObject.org$jboss$jms$client$delegate$ClientConnectionFactoryDelegate$getClientAOPStack$aop();
        }

        public Invocation copy() {
            getClientAOPStack_7161396531404689859 getClientAOPStack_71613965314046898592 = new getClientAOPStack_7161396531404689859(this.interceptors, this.methodHash, this.advisedMethod, this.unadvisedMethod, this.advisor);
            getClientAOPStack_71613965314046898592.arguments = this.arguments;
            getClientAOPStack_71613965314046898592.metadata = this.metadata;
            getClientAOPStack_71613965314046898592.currentInterceptor = this.currentInterceptor;
            getClientAOPStack_71613965314046898592.instanceResolver = this.instanceResolver;
            getClientAOPStack_71613965314046898592.typedTargetObject = this.typedTargetObject;
            getClientAOPStack_71613965314046898592.targetObject = this.targetObject;
            return getClientAOPStack_71613965314046898592;
        }
    }
}

