/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.jms.server.security.SecurityActions;
import org.jboss.security.SecurityAssociation;

class SecurityActions {
    SecurityActions() {
    }

    static void pushSubjectContext(Principal principal, Object credential, Subject subject) {
        if (System.getSecurityManager() == null) {
            PrincipalInfoAction.NON_PRIVILEGED.push(principal, credential, subject);
        } else {
            PrincipalInfoAction.PRIVILEGED.push(principal, credential, subject);
        }
    }

    static interface PrincipalInfoAction {
        public static final PrincipalInfoAction PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                AccessController.doPrivileged(new PrivilegedAction(this, subject, principal, credential){
                    private final /* synthetic */ Subject val$subject;
                    private final /* synthetic */ Principal val$principal;
                    private final /* synthetic */ Object val$credential;
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                        this.val$subject = val$subject;
                        this.val$principal = val$principal;
                        this.val$credential = val$credential;
                    }

                    public Object run() {
                        SecurityAssociation.pushSubjectContext(this.val$subject, this.val$principal, this.val$credential);
                        return null;
                    }
                });
            }

            public void dup() {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        SecurityAssociation.dupSubjectContext();
                        return null;
                    }
                });
            }

            public void pop() {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ 1 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    public Object run() {
                        SecurityAssociation.popSubjectContext();
                        return null;
                    }
                });
            }
        };
        public static final PrincipalInfoAction NON_PRIVILEGED = new PrincipalInfoAction(){

            public void push(Principal principal, Object credential, Subject subject) {
                SecurityAssociation.pushSubjectContext(subject, principal, credential);
            }

            public void dup() {
                SecurityAssociation.dupSubjectContext();
            }

            public void pop() {
                SecurityAssociation.popSubjectContext();
            }
        };

        public void push(Principal var1, Object var2, Subject var3);

        public void dup();

        public void pop();
    }
}

