/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.List;
import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ParameterMetaData;
import org.jboss.joinpoint.spi.JoinpointException;
import org.jboss.joinpoint.spi.MethodJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.config.Configurator;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LifecycleAction
extends KernelControllerContextAction {
    public abstract String getInstallMethod(BeanMetaData var1);

    public abstract String getDefaultInstallMethod();

    public abstract String getInstallAnnotation();

    public abstract List<ParameterMetaData> getInstallParameters(BeanMetaData var1);

    public abstract String getUninstallMethod(BeanMetaData var1);

    public abstract String getDefaultUninstallMethod();

    public abstract String getUninstallAnnotation();

    public abstract List<ParameterMetaData> getUninstallParameters(BeanMetaData var1);

    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        MethodJoinpoint joinpoint;
        boolean trace = this.log.isTraceEnabled();
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object target = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        String method = this.getInstallMethod(context);
        List<ParameterMetaData> parameters = this.getInstallParameters(context);
        try {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
        }
        catch (JoinpointException ignored) {
            if (trace) {
                if (parameters == null) {
                    this.log.trace("No " + method + " method for " + context);
                } else {
                    this.log.trace("No " + method + parameters + " method for " + context);
                }
            }
            return;
        }
        joinpoint.setTarget(target);
        LifecycleAction.dispatchJoinPoint(context, joinpoint);
    }

    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        boolean trace = this.log.isTraceEnabled();
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object target = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        String method = this.getUninstallMethod(context);
        List<ParameterMetaData> parameters = this.getUninstallParameters(context);
        try {
            ClassLoader cl = Configurator.getClassLoader(metaData);
            MethodJoinpoint joinpoint = configurator.getMethodJoinPoint(info, cl, method, parameters, false, true);
            joinpoint.setTarget(target);
            LifecycleAction.dispatchJoinPoint(context, joinpoint);
        }
        catch (JoinpointException ignored) {
            if (trace) {
                if (parameters == null) {
                    this.log.trace("No " + method + " method for " + context);
                } else {
                    this.log.trace("No " + method + parameters + " method for " + context);
                }
            }
        }
        catch (Throwable throwable) {
            this.log.warn("Error during " + method + " for " + context.getName(), throwable);
        }
    }

    public String getInstallMethod(KernelControllerContext context) {
        String installMethod = this.getInstallMethod(context.getBeanMetaData());
        if (installMethod != null) {
            return installMethod;
        }
        BeanInfo beanInfo = context.getBeanInfo();
        Set<MethodInfo> methods = beanInfo.getMethods();
        if (methods != null) {
            for (MethodInfo mi : methods) {
                if (!mi.isAnnotationPresent(this.getInstallAnnotation())) continue;
                return mi.getName();
            }
        }
        return this.getDefaultInstallMethod();
    }

    public List<ParameterMetaData> getInstallParameters(KernelControllerContext context) {
        return this.getInstallParameters(context.getBeanMetaData());
    }

    public String getUninstallMethod(KernelControllerContext context) {
        String uninstallMethod = this.getUninstallMethod(context.getBeanMetaData());
        if (uninstallMethod != null) {
            return uninstallMethod;
        }
        BeanInfo beanInfo = context.getBeanInfo();
        Set<MethodInfo> methods = beanInfo.getMethods();
        if (methods != null) {
            for (MethodInfo mi : methods) {
                if (!mi.isAnnotationPresent(this.getUninstallAnnotation())) continue;
                return mi.getName();
            }
        }
        return this.getDefaultUninstallMethod();
    }

    public List<ParameterMetaData> getUninstallParameters(KernelControllerContext context) {
        return this.getUninstallParameters(context.getBeanMetaData());
    }
}

