/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerServiceMBean;

public class JDBCMBeanSupport
extends ServiceMBeanSupport {
    protected DataSource ds;
    protected Properties sqlProperties = new Properties();
    protected TransactionManager tm;
    private String dataSourceJNDIName;
    private boolean createTablesOnStartup = true;
    private ObjectName tmObjectName;

    protected void startService() throws Exception {
        try {
            if (this.ds == null) {
                InitialContext ic = new InitialContext();
                this.ds = (DataSource)ic.lookup(this.dataSourceJNDIName);
                ic.close();
            }
            if (this.ds == null) {
                throw new IllegalStateException("No DataSource found. This service dependencies must have not been enforced correctly!");
            }
            this.log.debug(this + " started");
            this.tm = this.getTransactionManagerReference();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    protected void stopService() throws Exception {
        this.log.debug(this + " stopped");
    }

    public String getSqlProperties() {
        try {
            ByteArrayOutputStream boa = new ByteArrayOutputStream();
            this.sqlProperties.store(boa, "");
            return new String(boa.toByteArray());
        }
        catch (IOException shouldnothappen) {
            return "";
        }
    }

    public void setSqlProperties(String value) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(value.getBytes());
            this.sqlProperties = new Properties();
            this.sqlProperties.load(is);
        }
        catch (IOException shouldnothappen) {
            this.log.error("Caught IOException", shouldnothappen);
        }
    }

    public void setDataSource(String dataSourceJNDIName) throws Exception {
        this.dataSourceJNDIName = dataSourceJNDIName;
    }

    public String getDataSource() {
        return this.dataSourceJNDIName;
    }

    public void setTransactionManager(ObjectName tmObjectName) throws Exception {
        this.tmObjectName = tmObjectName;
    }

    public ObjectName getTransactionManager() {
        return this.tmObjectName;
    }

    public boolean isCreateTablesOnStartup() throws Exception {
        return this.createTablesOnStartup;
    }

    public void setCreateTablesOnStartup(boolean b) throws Exception {
        this.createTablesOnStartup = b;
    }

    private TransactionManager getTransactionManagerReference() {
        if (this.tm == null) {
            TransactionManagerServiceMBean tms = (TransactionManagerServiceMBean)MBeanServerInvocationHandler.newProxyInstance(this.getServer(), this.tmObjectName, TransactionManagerServiceMBean.class, false);
            this.tm = tms.getTransactionManager();
        }
        return this.tm;
    }
}

