/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;

public class JDBCSupport
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(JDBCSupport.class);
    private static boolean trace = log.isTraceEnabled();
    protected DataSource ds;
    private TransactionManager tm;
    protected Properties sqlProperties;
    private Map defaultDMLStatements = new LinkedHashMap();
    private Map defaultDDLStatements = new LinkedHashMap();
    private boolean createTablesOnStartup = true;

    public JDBCSupport() {
        this.sqlProperties = new Properties();
    }

    public JDBCSupport(DataSource ds, TransactionManager tm, Properties sqlProperties, boolean createTablesOnStartup) {
        this();
        this.ds = ds;
        this.tm = tm;
        if (sqlProperties != null) {
            this.sqlProperties = sqlProperties;
        }
        this.createTablesOnStartup = createTablesOnStartup;
    }

    public void start() throws Exception {
        String statementName;
        this.defaultDMLStatements.putAll(this.getDefaultDMLStatements());
        this.defaultDDLStatements.putAll(this.getDefaultDDLStatements());
        Properties sqlPropertiesCopy = new Properties();
        Iterator<Map.Entry<Object, Object>> iterSQL = this.sqlProperties.entrySet().iterator();
        while (iterSQL.hasNext()) {
            Map.Entry<Object, Object> entry = iterSQL.next();
            if (this.ignoreVerificationOnStartup((String)entry.getKey())) continue;
            sqlPropertiesCopy.put(entry.getKey(), entry.getValue());
        }
        Iterator<Object> iter = sqlPropertiesCopy.keySet().iterator();
        while (iter.hasNext()) {
            statementName = (String)iter.next();
            this.getSQLStatement(statementName);
        }
        if (!sqlPropertiesCopy.isEmpty()) {
            iter = this.defaultDMLStatements.keySet().iterator();
            while (iter.hasNext()) {
                statementName = (String)iter.next();
                if (this.sqlProperties.get(statementName) != null) continue;
                throw new IllegalStateException("SQL statement " + statementName + " is not specified in the SQL properties");
            }
            iter = this.defaultDDLStatements.keySet().iterator();
            while (iter.hasNext()) {
                statementName = (String)iter.next();
                if (sqlPropertiesCopy.get(statementName) != null) continue;
                throw new IllegalStateException("SQL statement " + statementName + " is not specified in the SQL properties");
            }
        }
        if (this.createTablesOnStartup) {
            this.createSchema();
        }
        log.debug(this + " started");
    }

    public void stop() throws Exception {
        log.debug(this + " stopped");
    }

    protected String getSQLStatement(String statementName) {
        String defaultStatement = (String)this.defaultDMLStatements.get(statementName);
        if (defaultStatement == null) {
            defaultStatement = (String)this.defaultDDLStatements.get(statementName);
        }
        if (defaultStatement == null) {
            throw new IllegalArgumentException("No such SQL statement: " + statementName);
        }
        return this.sqlProperties.getProperty(statementName, defaultStatement);
    }

    protected Map getDefaultDMLStatements() {
        return Collections.EMPTY_MAP;
    }

    protected Map getDefaultDDLStatements() {
        return Collections.EMPTY_MAP;
    }

    protected boolean ignoreVerificationOnStartup(String statementName) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSchema() throws Exception {
        Iterator i = this.defaultDDLStatements.keySet().iterator();
        while (i.hasNext()) {
            TransactionWrapper tx;
            block11: {
                Throwable t2;
                Object var8_7;
                Connection conn = null;
                tx = new TransactionWrapper();
                try {
                    conn = this.ds.getConnection();
                    String statementName = (String)i.next();
                    String statement = this.getSQLStatement(statementName);
                    if (!"IGNORE".equals(statement)) {
                        try {
                            if (log.isTraceEnabled()) {
                                log.trace("Executing: " + statement);
                            }
                            conn.createStatement().executeUpdate(statement);
                        }
                        catch (SQLException e) {
                            log.debug("Failed to execute: " + statement, e);
                            tx.exceptionOccurred();
                        }
                    }
                    var8_7 = null;
                    if (conn == null) break block11;
                }
                catch (Throwable throwable) {
                    var8_7 = null;
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable t2) {
                            // empty catch block
                        }
                    }
                    tx.end();
                    throw throwable;
                }
                try {
                    conn.close();
                }
                catch (Throwable t2) {
                    // empty catch block
                }
            }
            tx.end();
            {
            }
        }
    }

    protected class TransactionWrapper {
        private Transaction oldTx;
        private boolean failed;

        public TransactionWrapper() throws Exception {
            this.oldTx = JDBCSupport.this.tm.suspend();
            JDBCSupport.this.tm.begin();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() throws Exception {
            try {
                if (1 == JDBCSupport.this.tm.getStatus()) {
                    this.failed = true;
                    if (trace) {
                        log.trace("Rolling back tx");
                    }
                    JDBCSupport.this.tm.rollback();
                } else {
                    if (trace) {
                        log.trace("Committing tx");
                    }
                    JDBCSupport.this.tm.commit();
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (this.oldTx != null && JDBCSupport.this.tm != null) {
                    if (trace) {
                        log.trace("Resuming tx");
                    }
                    JDBCSupport.this.tm.resume(this.oldTx);
                }
                throw throwable;
            }
            if (this.oldTx != null && JDBCSupport.this.tm != null) {
                if (trace) {
                    log.trace("Resuming tx");
                }
                JDBCSupport.this.tm.resume(this.oldTx);
            }
        }

        public void exceptionOccurred() throws Exception {
            JDBCSupport.this.tm.setRollbackOnly();
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

