/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.plugin.postoffice.cluster;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.plugin.contract.Condition;
import org.jboss.messaging.core.plugin.postoffice.cluster.ClusterRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessageHolder;
import org.jboss.messaging.core.plugin.postoffice.cluster.MessagesRequest;
import org.jboss.messaging.core.plugin.postoffice.cluster.PostOfficeInternal;
import org.jboss.messaging.core.plugin.postoffice.cluster.SendTransactionRequest;
import org.jboss.messaging.core.tx.TransactionException;
import org.jboss.messaging.core.tx.TxCallback;

class CastMessagesCallback
implements TxCallback {
    private static final Logger log = Logger.getLogger(CastMessagesCallback.class);
    private boolean trace = log.isTraceEnabled();
    private List persistent;
    private List nonPersistent;
    private int nodeId;
    private long txId;
    private PostOfficeInternal office;
    private boolean multicast;
    private int toNodeId;
    private boolean failBeforeCommit;
    private boolean failAfterCommit;
    private long checkChannelID;

    void addMessage(Condition routingKey, Message message, Map queueNameToNodeIdMap, int lastNodeId, long channelID) {
        if (lastNodeId == -1) {
            this.multicast = true;
        } else if (lastNodeId != this.toNodeId) {
            this.multicast = true;
        } else {
            this.toNodeId = lastNodeId;
        }
        MessageHolder holder = new MessageHolder(routingKey.toText(), message, queueNameToNodeIdMap);
        if (message.isReliable()) {
            if (this.persistent == null) {
                this.persistent = new ArrayList();
            }
            this.persistent.add(holder);
            this.checkChannelID = channelID;
        } else {
            if (this.nonPersistent == null) {
                this.nonPersistent = new ArrayList();
            }
            this.nonPersistent.add(holder);
        }
    }

    CastMessagesCallback(int nodeId, long txId, PostOfficeInternal office, boolean failBeforeCommit, boolean failAfterCommit) {
        this.nodeId = nodeId;
        this.txId = txId;
        this.office = office;
        this.failBeforeCommit = failBeforeCommit;
        this.failAfterCommit = failAfterCommit;
    }

    public void afterCommit(boolean onePhase) throws Exception {
        ClusterRequest req;
        if (this.nonPersistent != null) {
            req = new MessagesRequest(this.nonPersistent);
            this.sendRequest(req);
        }
        if (this.persistent != null) {
            if (this.failAfterCommit) {
                throw new TransactionException("Forced failure for testing");
            }
            req = new SendTransactionRequest(this.nodeId, this.txId);
            this.sendRequest(req);
        }
        this.persistent = null;
        this.nonPersistent = null;
    }

    public void afterPrepare() throws Exception {
    }

    public void afterRollback(boolean onePhase) throws Exception {
    }

    public void beforeCommit(boolean onePhase) throws Exception {
        if (this.persistent != null) {
            SendTransactionRequest req = new SendTransactionRequest(this.nodeId, this.txId, this.persistent, this.checkChannelID);
            this.sendRequest(req);
        }
        if (this.failBeforeCommit) {
            throw new TransactionException("Forced failure for testing");
        }
    }

    public void beforePrepare() throws Exception {
    }

    public void beforeRollback(boolean onePhase) throws Exception {
    }

    private void sendRequest(ClusterRequest req) throws Exception {
        if (this.multicast) {
            if (this.trace) {
                log.trace("Multicasting transaction across group");
            }
            this.office.asyncSendRequest(req);
        } else {
            if (this.trace) {
                log.trace("Unicasting transaction to node");
            }
            this.office.asyncSendRequest(req, this.toNodeId);
        }
    }
}

