/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core.tx;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.Queue;
import org.jboss.messaging.core.SimpleDelivery;
import org.jboss.messaging.core.message.Message;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.IDManager;
import org.jboss.messaging.core.plugin.contract.MessageStore;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;
import org.jboss.messaging.core.plugin.contract.PersistenceManager;
import org.jboss.messaging.core.plugin.contract.PostOffice;
import org.jboss.messaging.core.plugin.postoffice.Binding;
import org.jboss.messaging.core.tx.PreparedTxInfo;
import org.jboss.messaging.core.tx.Transaction;
import org.jboss.messaging.core.tx.TransactionException;
import org.jboss.messaging.core.tx.TxCallback;

public class TransactionRepository
implements MessagingComponent {
    private static final Logger log = Logger.getLogger(TransactionRepository.class);
    private boolean trace = log.isTraceEnabled();
    private Map globalToLocalMap;
    private PersistenceManager persistenceManager;
    protected MessageStore messageStore;
    private IDManager idManager;
    private PostOffice postOffice;

    public TransactionRepository(PersistenceManager persistenceManager, MessageStore store, IDManager idManager) {
        this.persistenceManager = persistenceManager;
        this.messageStore = store;
        this.idManager = idManager;
        this.globalToLocalMap = new ConcurrentHashMap();
    }

    public void injectPostOffice(PostOffice po) {
        this.postOffice = po;
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public synchronized List recoverPreparedTransactions() {
        if (this.trace) {
            log.trace(this + " recoverPreparedTransactions()");
        }
        ArrayList<Xid> prepared = new ArrayList<Xid>();
        Iterator iter = this.globalToLocalMap.values().iterator();
        while (iter.hasNext()) {
            Transaction tx = (Transaction)iter.next();
            if (tx.getXid() == null || tx.getState() != 1) continue;
            try {
                if (this.trace) {
                    log.trace("Loading and handling refs and acks to the Tx " + tx);
                }
                if (tx.isRecoveredFromStorage()) {
                    tx.loadState();
                }
            }
            catch (Exception e) {
                log.warn("Failed to replay transaction (XID: " + tx.getXid() + ", LocalID: " + tx.getId() + ") during recovery.", e);
            }
            prepared.add(tx.getXid());
        }
        if (this.trace) {
            log.trace("Returning " + prepared.size() + " transactions");
        }
        return prepared;
    }

    public void loadPreparedTransactions() throws Exception {
        if (this.trace) {
            log.trace("load prepared transactions...");
        }
        List prepared = null;
        prepared = this.persistenceManager.retrievePreparedTransactions();
        if (this.trace) {
            log.trace("found " + prepared.size() + " transactions in prepared state");
        }
        if (prepared != null) {
            Iterator iter = prepared.iterator();
            while (iter.hasNext()) {
                PreparedTxInfo txInfo = (PreparedTxInfo)iter.next();
                if (!this.globalToLocalMap.containsKey(txInfo.getXid())) {
                    Transaction tx = this.createTransaction(txInfo);
                    tx.setState(1);
                    tx.setRecoveredFromStorage(true);
                    if (!this.trace) continue;
                    log.trace("reinstating TX(XID: " + txInfo.getXid() + ", LocalId " + txInfo.getTxId() + ")");
                    continue;
                }
                if (!this.trace) continue;
                log.trace("Not adding to map since it's already in map");
            }
        }
    }

    public List getPreparedTransactions() {
        return new ArrayList(this.globalToLocalMap.keySet());
    }

    public Transaction getPreparedTx(Xid xid) throws Exception {
        Transaction tx = (Transaction)this.globalToLocalMap.get(xid);
        if (tx == null) {
            throw new TransactionException("Cannot find local tx for xid:" + xid);
        }
        if (tx.getState() != 1) {
            throw new TransactionException("Transaction with xid " + xid + " is not in prepared state");
        }
        return tx;
    }

    public void deleteTransaction(Transaction transaction) throws Exception {
        Xid id = transaction.getXid();
        int state = transaction.getState();
        if (id == null) {
            throw new IllegalArgumentException("DeleteTransaction was called for non XA transaction");
        }
        if (state != 2 && state != 3) {
            throw new TransactionException("Transaction with xid " + id + " can't be removed as it's not yet commited or rolledback: (Current state is " + Transaction.stateToString(state));
        }
        this.globalToLocalMap.remove(id);
    }

    public Transaction createTransaction(Xid xid) throws Exception {
        if (this.globalToLocalMap.containsKey(xid)) {
            throw new TransactionException("There is already a local tx for global tx " + xid);
        }
        Transaction tx = new Transaction(this.idManager.getID(), xid, this);
        if (this.trace) {
            log.trace("created transaction " + tx);
        }
        this.globalToLocalMap.put(xid, tx);
        return tx;
    }

    public Transaction createTransaction() throws Exception {
        Transaction tx = new Transaction(this.idManager.getID());
        if (this.trace) {
            log.trace("created transaction " + tx);
        }
        return tx;
    }

    public boolean removeTransaction(Xid xid) {
        return this.globalToLocalMap.remove(xid) != null;
    }

    public int getNumberOfRegisteredTransactions() {
        return this.globalToLocalMap.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleReferences(Transaction tx) throws Exception {
        if (this.trace) {
            log.trace("Handle references for TX(XID: " + tx.getXid() + ", LocalID: " + tx.getId() + "):");
        }
        long txId = tx.getId();
        List pairs = this.persistenceManager.getMessageChannelPairRefsForTx(txId);
        if (this.trace) {
            log.trace("Found " + pairs.size() + " unhandled references.");
        }
        Iterator iter = pairs.iterator();
        while (iter.hasNext()) {
            PersistenceManager.MessageChannelPair pair = (PersistenceManager.MessageChannelPair)iter.next();
            Message msg = pair.getMessage();
            long channelID = pair.getChannelId();
            MessageReference ref = null;
            try {
                ref = this.messageStore.reference(msg);
                Binding binding = this.postOffice.getBindingforChannelId(channelID);
                if (binding == null) {
                    throw new IllegalStateException("Cannot find binding for channel id " + channelID);
                }
                Queue queue = binding.getQueue();
                if (this.trace) {
                    log.trace("Destination for message[ID=" + ref.getMessage().getMessageID() + "] is: " + queue);
                }
                queue.handle(null, ref, tx);
            }
            finally {
                if (ref == null) continue;
                ref.releaseMemoryReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleAcks(Transaction tx) throws Exception {
        long txId = tx.getId();
        List pairs = this.persistenceManager.getMessageChannelPairAcksForTx(txId);
        if (this.trace) {
            log.trace("Found " + pairs.size() + " unhandled acks.");
        }
        ArrayList<SimpleDelivery> dels = new ArrayList<SimpleDelivery>();
        Iterator iter = pairs.iterator();
        while (iter.hasNext()) {
            PersistenceManager.MessageChannelPair pair = (PersistenceManager.MessageChannelPair)iter.next();
            Message msg = pair.getMessage();
            long channelID = pair.getChannelId();
            MessageReference ref = null;
            try {
                ref = this.messageStore.reference(msg);
                Binding binding = this.postOffice.getBindingforChannelId(channelID);
                if (binding == null) {
                    throw new IllegalStateException("Cannot find binding for channel id " + channelID);
                }
                Queue queue = binding.getQueue();
                if (this.trace) {
                    log.trace("Destination for message[ID=" + ref.getMessage().getMessageID() + "] is: " + queue);
                }
                SimpleDelivery del = new SimpleDelivery(queue, ref);
                if (this.trace) {
                    log.trace("Acknowledging..");
                }
                try {
                    del.acknowledge(tx);
                }
                catch (Throwable t) {
                    log.error("Failed to acknowledge " + del + " during recovery", t);
                }
                dels.add(del);
            }
            finally {
                if (ref == null) continue;
                ref.releaseMemoryReference();
            }
        }
        if (!dels.isEmpty()) {
            tx.addCallback(new CancelCallback(dels), this);
        }
    }

    private Transaction createTransaction(PreparedTxInfo txInfo) throws Exception {
        if (this.globalToLocalMap.containsKey(txInfo.getXid())) {
            throw new TransactionException("There is already a local tx for global tx " + txInfo.getXid());
        }
        Transaction tx = new Transaction(txInfo.getTxId(), txInfo.getXid(), this);
        if (this.trace) {
            log.trace("created transaction " + tx);
        }
        this.globalToLocalMap.put(txInfo.getXid(), tx);
        return tx;
    }

    private class CancelCallback
    implements TxCallback {
        private List toCancel;

        private CancelCallback(List toCancel) {
            this.toCancel = toCancel;
        }

        public void afterCommit(boolean onePhase) throws Exception {
        }

        public void afterPrepare() throws Exception {
        }

        public void afterRollback(boolean onePhase) throws Exception {
            for (int i = this.toCancel.size() - 1; i >= 0; --i) {
                Delivery del = (Delivery)this.toCancel.get(i);
                try {
                    del.cancel();
                    continue;
                }
                catch (Throwable t) {
                    log.error("Failed to cancel delivery", t);
                    throw new TransactionException(t.getMessage(), t);
                }
            }
        }

        public void beforeCommit(boolean onePhase) throws Exception {
        }

        public void beforePrepare() throws Exception {
        }

        public void beforeRollback(boolean onePhase) throws Exception {
        }
    }
}

