/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata;

import java.io.Serializable;
import org.jboss.deployment.DeploymentException;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.RelationMetaData;
import org.w3c.dom.Element;

public class RelationshipRoleMetaData
extends MetaData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static int ONE = 1;
    private static int MANY = 2;
    private String relationshipRoleName;
    private RelationMetaData relationMetaData;
    private int multiplicity;
    private boolean cascadeDelete;
    private String entityName;
    private String cmrFieldName;
    private String cmrFieldType;

    public RelationshipRoleMetaData(RelationMetaData relationMetaData) {
        this.relationMetaData = relationMetaData;
    }

    public String getRelationshipRoleName() {
        return this.relationshipRoleName;
    }

    public RelationMetaData getRelationMetaData() {
        return this.relationMetaData;
    }

    public RelationshipRoleMetaData getRelatedRoleMetaData() {
        return this.relationMetaData.getOtherRelationshipRole(this);
    }

    public boolean isMultiplicityOne() {
        return this.multiplicity == ONE;
    }

    public boolean isMultiplicityMany() {
        return this.multiplicity == MANY;
    }

    public boolean isCascadeDelete() {
        return this.cascadeDelete;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getCMRFieldName() {
        return this.cmrFieldName;
    }

    public String getCMRFieldType() {
        return this.cmrFieldType;
    }

    public void setRelationshipRoleName(String relationshipRoleName) {
        this.relationshipRoleName = relationshipRoleName;
    }

    public void setMultiplicity(String multiplicity) {
        if ("One".equals(multiplicity)) {
            this.multiplicity = ONE;
        } else if ("Many".equals(multiplicity)) {
            this.multiplicity = MANY;
        } else {
            throw new IllegalStateException("multiplicity must be exactaly 'One' or 'Many' but is " + multiplicity + "; this is case " + "sensitive");
        }
    }

    public void setCascadeDelete(boolean cascadeDelete) {
        this.cascadeDelete = cascadeDelete;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public void setCmrFieldName(String cmrFieldName) {
        this.cmrFieldName = cmrFieldName;
    }

    public void setCmrFieldType(String cmrFieldType) {
        this.cmrFieldType = cmrFieldType;
    }

    public void importEjbJarXml(Element element) throws DeploymentException {
        this.relationshipRoleName = RelationshipRoleMetaData.getOptionalChildContent(element, "ejb-relationship-role-name");
        String multiplicityString = RelationshipRoleMetaData.getUniqueChildContent(element, "multiplicity");
        if ("One".equals(multiplicityString)) {
            this.multiplicity = ONE;
        } else if ("Many".equals(multiplicityString)) {
            this.multiplicity = MANY;
        } else {
            throw new DeploymentException("multiplicity must be exactaly 'One' or 'Many' but is " + multiplicityString + "; this is case " + "sensitive");
        }
        if (RelationshipRoleMetaData.getOptionalChild(element, "cascade-delete") != null) {
            this.cascadeDelete = true;
        }
        Element relationshipRoleSourceElement = RelationshipRoleMetaData.getUniqueChild(element, "relationship-role-source");
        this.entityName = RelationshipRoleMetaData.getUniqueChildContent(relationshipRoleSourceElement, "ejb-name");
        Element cmrFieldElement = RelationshipRoleMetaData.getOptionalChild(element, "cmr-field");
        if (cmrFieldElement != null) {
            this.cmrFieldName = RelationshipRoleMetaData.getUniqueChildContent(cmrFieldElement, "cmr-field-name");
            this.cmrFieldType = RelationshipRoleMetaData.getOptionalChildContent(cmrFieldElement, "cmr-field-type");
            if (this.cmrFieldType != null && !this.cmrFieldType.equals("java.util.Collection") && !this.cmrFieldType.equals("java.util.Set")) {
                throw new DeploymentException("cmr-field-type should be java.util.Collection or java.util.Set but is " + this.cmrFieldType);
            }
        }
        if (this.relationshipRoleName == null) {
            this.relationshipRoleName = this.entityName + (this.cmrFieldName == null ? "" : "_" + this.cmrFieldName);
        }
    }
}

