/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.api.types;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.jboss.metatype.api.types.AbstractMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CompositeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableCompositeMetaType
extends AbstractMetaType
implements CompositeMetaType {
    private static final long serialVersionUID = 1133171306971861455L;
    private TreeMap<String, String> nameToDescription;
    private TreeMap<String, MetaType> nameToType;
    private transient int cachedHashCode = Integer.MIN_VALUE;
    private transient String cachedToString = null;

    public ImmutableCompositeMetaType(String typeName, String description, String[] itemNames, String[] itemDescriptions, MetaType[] itemTypes) {
        super(CompositeValue.class.getName(), typeName, description);
        if (itemNames == null || itemNames.length == 0) {
            throw new IllegalArgumentException("null or empty itemNames");
        }
        if (itemDescriptions == null || itemDescriptions.length == 0) {
            throw new IllegalArgumentException("null or empty itemDescriptions");
        }
        if (itemTypes == null || itemTypes.length == 0) {
            throw new IllegalArgumentException("null or empty itemTypes");
        }
        if (itemNames.length != itemDescriptions.length) {
            throw new IllegalArgumentException("wrong number of itemDescriptions");
        }
        if (itemNames.length != itemTypes.length) {
            throw new IllegalArgumentException("wrong number of itemTypes");
        }
        this.nameToDescription = new TreeMap();
        this.nameToType = new TreeMap();
        for (int i = 0; i < itemNames.length; ++i) {
            if (itemNames[i] == null) {
                throw new IllegalArgumentException("null item name " + i);
            }
            String itemName = itemNames[i].trim();
            if (itemName.length() == 0) {
                throw new IllegalArgumentException("empty item name " + i);
            }
            if (this.nameToDescription.containsKey(itemName)) {
                throw new IllegalArgumentException("duplicate item name " + itemName);
            }
            if (itemDescriptions[i] == null) {
                throw new IllegalArgumentException("null item description " + i);
            }
            String itemDescription = itemDescriptions[i].trim();
            if (itemDescription.length() == 0) {
                throw new IllegalArgumentException("empty item description " + i);
            }
            if (itemTypes[i] == null) {
                throw new IllegalArgumentException("null item type " + i);
            }
            this.nameToDescription.put(itemName, itemDescription);
            this.nameToType.put(itemName, itemTypes[i]);
        }
    }

    @Override
    public boolean containsKey(String itemName) {
        if (itemName == null) {
            return false;
        }
        return this.nameToDescription.containsKey(itemName);
    }

    @Override
    public String getDescription(String itemName) {
        if (itemName == null) {
            return null;
        }
        return this.nameToDescription.get(itemName);
    }

    @Override
    public MetaType getType(String itemName) {
        if (itemName == null) {
            return null;
        }
        return this.nameToType.get(itemName);
    }

    @Override
    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.nameToDescription.keySet());
    }

    @Override
    public boolean isValue(Object obj) {
        if (obj == null || !(obj instanceof CompositeValue)) {
            return false;
        }
        return this.equals(((CompositeValue)obj).getMetaType());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ImmutableCompositeMetaType)) {
            return false;
        }
        ImmutableCompositeMetaType other = (ImmutableCompositeMetaType)obj;
        if (!this.getTypeName().equals(other.getTypeName())) {
            return false;
        }
        Iterator<String> thisNames = this.keySet().iterator();
        Iterator<String> otherNames = other.keySet().iterator();
        while (thisNames.hasNext() && otherNames.hasNext()) {
            String otherName;
            String thisName = thisNames.next();
            if (!thisName.equals(otherName = otherNames.next())) {
                return false;
            }
            if (this.getType(thisName).equals(other.getType(otherName))) continue;
            return false;
        }
        return !thisNames.hasNext() && !otherNames.hasNext();
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode != Integer.MIN_VALUE) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getTypeName().hashCode();
        Iterator<Object> i = this.nameToType.values().iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        i = this.nameToDescription.keySet().iterator();
        while (i.hasNext()) {
            this.cachedHashCode += i.next().hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append("{items=");
        Iterator<String> thisNames = this.keySet().iterator();
        while (thisNames.hasNext()) {
            String thisName = thisNames.next();
            buffer.append("[");
            buffer.append("name=");
            buffer.append(thisName);
            buffer.append(" type=");
            buffer.append(this.getType(thisName));
            buffer.append("]");
            if (!thisNames.hasNext()) continue;
            buffer.append(", ");
        }
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }
}

