/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.CannotConnectException;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.RemoteClientInvoker;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.MarshallerDecorator;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.rmi.RMIMarshaller;
import org.jboss.remoting.transport.rmi.RMIServerInvokerInf;
import org.jboss.remoting.transport.rmi.RemotingRMIClientSocketFactory;

public class RMIClientInvoker
extends RemoteClientInvoker {
    private static final Logger log = Logger.getLogger(class$org$jboss$remoting$transport$rmi$RMIClientInvoker == null ? (class$org$jboss$remoting$transport$rmi$RMIClientInvoker = RMIClientInvoker.class$("org.jboss.remoting.transport.rmi.RMIClientInvoker")) : class$org$jboss$remoting$transport$rmi$RMIClientInvoker);
    private static final boolean isTraceEnabled = log.isTraceEnabled();
    private RMIServerInvokerInf server;
    private boolean connected = false;
    static /* synthetic */ Class class$org$jboss$remoting$transport$rmi$RMIClientInvoker;

    public RMIClientInvoker(InvokerLocator locator) {
        super(locator);
    }

    public RMIClientInvoker(InvokerLocator locator, Map configuration) {
        super(locator, configuration);
    }

    private int getRegistryPort(InvokerLocator locator) {
        String value;
        int port = 3455;
        Map params = locator.getParameters();
        if (params != null && (value = (String)params.get("registryPort")) != null) {
            try {
                port = Integer.parseInt(value);
                log.debug("Using port " + port + " for rmi registry.");
            }
            catch (NumberFormatException e) {
                log.error("Can not set the RMIServerInvoker RMI registry to port " + value + ".  This is not a valid port number.");
            }
        }
        return port;
    }

    public void setServerStub(RMIServerInvokerInf server) {
        this.server = server;
        log.trace(this.server);
    }

    public RMIServerInvokerInf getServerStub() {
        return this.server;
    }

    protected void handleConnect() throws ConnectionFailedException {
        try {
            this.storeLocalConfig(this.configuration);
            String host = this.locator.getHost();
            int port = this.getRegistryPort(this.locator);
            Registry regsitry = LocateRegistry.getRegistry(host, port);
            Remote remoteObj = regsitry.lookup("remoting/RMIServerInvoker/" + this.locator.getPort());
            log.debug("Remote RMI Stub: " + remoteObj);
            this.setServerStub((RMIServerInvokerInf)remoteObj);
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            log.debug("Error connecting RMI invoker client.", e);
            throw new CannotConnectException("Error connecting RMI invoker client", e);
        }
    }

    protected void handleDisconnect() {
    }

    protected String getDefaultDataType() {
        return "rmi";
    }

    protected void storeLocalConfig(Map config) {
        HashMap<String, SocketFactory> localConfig = new HashMap<String, SocketFactory>(config);
        if (this.socketFactory != null && !this.socketFactoryCreatedFromSSLParameters && AbstractInvoker.isCompleteSocketFactory(this.socketFactory)) {
            localConfig.put("customSocketFactory", this.socketFactory);
        }
        RemotingRMIClientSocketFactory.addLocalConfiguration(this.locator, localConfig);
    }

    protected Object transport(String sessionId, Object invocation, Map metadata, Marshaller marshaller, UnMarshaller unmarshaller) throws IOException, ConnectionFailedException {
        if (this.server == null) {
            log.error("Server stub has not been set in RMI invoker client.  See previous errors for details.");
            throw new CannotConnectException("Server stub has not been set.");
        }
        try {
            Object payload = invocation;
            if (marshaller != null && !(marshaller instanceof RMIMarshaller)) {
                if (marshaller instanceof MarshallerDecorator) {
                    payload = ((MarshallerDecorator)((Object)marshaller)).addDecoration(payload);
                } else {
                    ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                    marshaller.write(payload, byteOut);
                    ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(byteIn);
                    try {
                        byteOut.close();
                        payload = ois.readObject();
                        ois.close();
                    }
                    catch (ClassNotFoundException e) {
                        log.error("Could not marshall invocation payload object " + payload, e);
                        throw new IOException(e.getMessage());
                    }
                }
            }
            Object response = this.server.transport(payload);
            return response;
        }
        catch (RemoteException e) {
            log.error(e);
            throw new CannotConnectException("Error making invocation in RMI client invoker.", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

