/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jms.inflow.dlq;

import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.Context;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.logging.Logger;
import org.jboss.resource.adapter.jms.inflow.DLQHandler;
import org.jboss.resource.adapter.jms.inflow.JmsActivation;
import org.jboss.resource.adapter.jms.inflow.JmsActivationSpec;
import org.jboss.util.naming.Util;

public abstract class AbstractDLQHandler
implements DLQHandler,
ExceptionListener {
    protected static final Logger log = Logger.getLogger(AbstractDLQHandler.class);
    protected JmsActivation activation;
    protected Queue dlq;
    protected QueueConnection connection;

    public boolean handleRedeliveredMessage(Message msg) {
        boolean handled = this.handleDelivery(msg);
        if (handled) {
            this.sendToDLQ(msg);
        }
        return handled;
    }

    public void messageDelivered(Message msg) {
    }

    public void setup(JmsActivation activation, Context ctx) throws Exception {
        this.activation = activation;
        this.setupDLQDestination(ctx);
        this.setupDLQConnection(ctx);
    }

    public void teardown() {
        this.teardownDLQConnection();
        this.teardownDLQDestination();
    }

    public void onException(JMSException exception) {
        this.activation.handleFailure(exception);
    }

    protected void setupDLQDestination(Context ctx) throws Exception {
        String name = this.activation.getActivationSpec().getDLQJNDIName();
        this.dlq = (Queue)Util.lookup(ctx, name, Queue.class);
    }

    protected void teardownDLQDestination() {
    }

    protected void setupDLQConnection(Context ctx) throws Exception {
        JmsActivationSpec spec = this.activation.getActivationSpec();
        String user = spec.getDLQUser();
        String pass = spec.getDLQPassword();
        String clientID = spec.getDLQClientID();
        JMSProviderAdapter adapter = this.activation.getProviderAdapter();
        String queueFactoryRef = adapter.getQueueFactoryRef();
        log.debug("Attempting to lookup dlq connection factory " + queueFactoryRef);
        QueueConnectionFactory qcf = (QueueConnectionFactory)Util.lookup(ctx, queueFactoryRef, QueueConnectionFactory.class);
        log.debug("Got dlq connection factory " + qcf + " from " + queueFactoryRef);
        log.debug("Attempting to create queue connection with user " + user);
        this.connection = user != null ? qcf.createQueueConnection(user, pass) : qcf.createQueueConnection();
        if (clientID != null) {
            this.connection.setClientID(clientID);
        }
        this.connection.setExceptionListener(this);
        log.debug("Using queue connection " + this.connection);
    }

    protected void teardownDLQConnection() {
        try {
            if (this.connection != null) {
                log.debug("Closing the " + this.connection);
                this.connection.close();
            }
        }
        catch (Throwable t) {
            log.debug("Error closing the connection " + this.connection, t);
        }
    }

    protected abstract boolean handleDelivery(Message var1);

    protected void warnDLQ(Message msg, int count, int max) {
        log.warn("Message redelivered=" + count + " max=" + max + " sending it to the dlq " + msg);
    }

    protected void sendToDLQ(Message msg) {
        int deliveryMode = this.getDeliveryMode(msg);
        int priority = this.getPriority(msg);
        long timeToLive = this.getTimeToLive(msg);
        if (timeToLive < 0L) {
            if (log.isTraceEnabled()) {
                log.trace("Not sending the message to the DLQ, it has expired " + msg);
            }
            return;
        }
        Message copy = this.makeWritable(msg);
        if (copy != null) {
            this.doSend(copy, deliveryMode, priority, timeToLive);
        }
    }

    protected int getDeliveryMode(Message msg) {
        try {
            return msg.getJMSDeliveryMode();
        }
        catch (Throwable t) {
            return 2;
        }
    }

    protected int getPriority(Message msg) {
        try {
            return msg.getJMSPriority();
        }
        catch (Throwable t) {
            return 4;
        }
    }

    protected long getTimeToLive(Message msg) {
        try {
            long expires = msg.getJMSExpiration();
            if (expires == 0L) {
                return 0L;
            }
            return expires - System.currentTimeMillis();
        }
        catch (Throwable t) {
            return 0L;
        }
    }

    protected Message makeWritable(Message msg) {
        boolean trace = log.isTraceEnabled();
        try {
            HashMap<String, Object> tmp = new HashMap<String, Object>();
            Enumeration en = msg.getPropertyNames();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                tmp.put(key, msg.getObjectProperty(key));
            }
            msg.clearProperties();
            for (String key : tmp.keySet()) {
                try {
                    msg.setObjectProperty(key, tmp.get(key));
                }
                catch (JMSException ignored) {
                    if (!trace) continue;
                    log.trace("Could not copy message property " + key, ignored);
                }
            }
            msg.setStringProperty("JBOSS_ORIG_MESSAGEID", msg.getJMSMessageID());
            Destination destination = msg.getJMSDestination();
            if (destination != null) {
                msg.setStringProperty("JBOSS_ORIG_DESTINATION", destination.toString());
            }
            return msg;
        }
        catch (Throwable t) {
            log.error("Unable to make writable " + msg, t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSend(Message msg, int deliveryMode, int priority, long timeToLive) {
        QueueSession session = null;
        try {
            session = this.connection.createQueueSession(false, 1);
            QueueSender sender = session.createSender(this.dlq);
            sender.send(msg, deliveryMode, priority, timeToLive);
        }
        catch (Throwable t) {
            this.handleSendError(msg, t);
        }
        finally {
            if (session != null) {
                try {
                    session.close();
                }
                catch (Throwable t) {
                    log.trace("Ignored ", t);
                }
            }
        }
    }

    protected void handleSendError(Message msg, Throwable t) {
        log.error("DLQ " + this.dlq + " error sending message " + msg, t);
    }
}

