/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.resource.spi.ResourceAdapter;
import org.jboss.deployment.DeploymentException;
import org.jboss.resource.deployment.DummyResourceAdapter;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.RARDeploymentMetaData;

public class ResourceAdapterFactory {
    public static final String DUMMY_RA_CLASS = DummyResourceAdapter.class.getName();

    public static ResourceAdapter createResourceAdapter(RARDeploymentMetaData ramd) throws Exception {
        ResourceAdapter adapter = ResourceAdapterFactory.createResourceAdapter(ramd.getConnectorMetaData());
        for (ConfigPropertyMetaData cpmd : ramd.getRaXmlMetaData().getProperties()) {
            ResourceAdapterFactory.applyProperty(cpmd, adapter.getClass(), adapter);
        }
        return adapter;
    }

    public static ResourceAdapter createResourceAdapter(ConnectorMetaData cmd) throws Exception {
        Class<?> raClass;
        String className = cmd.getRAClass();
        if (className == null) {
            if (cmd.getVersion().equals("1.0")) {
                className = DUMMY_RA_CLASS;
            } else {
                throw new IllegalArgumentException("No resource adapter class name specified");
            }
        }
        if (!ResourceAdapter.class.isAssignableFrom(raClass = Thread.currentThread().getContextClassLoader().loadClass(className))) {
            throw new DeploymentException(raClass.getName() + " is not a resource adapter class");
        }
        ResourceAdapter result = (ResourceAdapter)raClass.newInstance();
        for (ConfigPropertyMetaData cpmd : cmd.getProperties()) {
            ResourceAdapterFactory.applyProperty(cpmd, raClass, result);
        }
        return result;
    }

    private static void applyProperty(ConfigPropertyMetaData cpmd, Class clz, ResourceAdapter ra) throws Exception {
        String name = cpmd.getName();
        String type = cpmd.getType();
        String value = cpmd.getValue();
        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(type);
        PropertyEditor editor = PropertyEditorManager.findEditor(clazz);
        if (editor == null) {
            throw new IllegalArgumentException("No property editor found for property " + cpmd);
        }
        editor.setAsText(value);
        Object object = editor.getValue();
        try {
            String setter = "set" + Character.toUpperCase(name.charAt(0));
            if (name.length() > 1) {
                setter = setter.concat(name.substring(1));
            }
            Method method = clz.getMethod(setter, clazz);
            method.invoke((Object)ra, object);
        }
        catch (InvocationTargetException e) {
            DeploymentException.rethrowAsDeploymentException("Error for resource adapter class " + clz.getName() + " setting property " + cpmd, e.getTargetException());
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException("Error for resource adapter class " + clz.getName() + " accessing property setter " + cpmd, t);
        }
    }
}

