/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.config;

import java.util.HashMap;
import java.util.Map;
import org.jboss.security.auth.login.ModuleOption;

public class AuthorizationModuleEntry {
    private String policyModuleName;
    private ControlFlag controlFlag;
    private Map options = null;

    public AuthorizationModuleEntry(String name) {
        this.policyModuleName = name;
    }

    public AuthorizationModuleEntry(String name, Map options) {
        this.policyModuleName = name;
        this.options = options;
    }

    public void add(ModuleOption option) {
        if (this.options == null) {
            this.options = new HashMap();
        }
        this.options.put(option.getName(), option.getValue());
    }

    public String getPolicyModuleName() {
        return this.policyModuleName;
    }

    public Map getOptions() {
        return this.options;
    }

    public ControlFlag getControlFlag() {
        return this.controlFlag;
    }

    public void setControlFlag(ControlFlag controlFlag) {
        this.controlFlag = controlFlag;
    }

    public static class ControlFlag {
        private String flag = "";
        public static final ControlFlag REQUIRED = new ControlFlag("REQUIRED");
        public static final ControlFlag REQUISITE = new ControlFlag("REQUISITE");
        public static final ControlFlag SUFFICIENT = new ControlFlag("SUFFICIENT");
        public static final ControlFlag OPTIONAL = new ControlFlag("OPTIONAL");

        public ControlFlag(String flag) {
            this.flag = flag;
        }

        public String toString() {
            return this.flag;
        }
    }
}

