/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.plugins;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RunAs;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextUtil;
import org.jboss.security.SubjectInfo;
import org.jboss.security.Util;
import org.jboss.security.audit.AuditManager;
import org.jboss.security.audit.SecurityAuditManager;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.plugins.SecurityContextFactory;
import org.jboss.security.plugins.mapping.JBossMappingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSecurityContext
implements SecurityContext {
    private static final long serialVersionUID = 1L;
    protected static final Logger log = Logger.getLogger(JBossSecurityContext.class);
    protected boolean trace = log.isTraceEnabled();
    protected Map<String, Object> contextData = new HashMap<String, Object>();
    protected String securityDomain = "other";
    protected SubjectInfo subjectInfo = null;
    protected RunAs configuredRunAs = null;

    public JBossSecurityContext(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return Util.getAuthenticationManager(this.securityDomain);
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return Util.getAuthorizationManager(this.securityDomain);
    }

    @Override
    public Map<String, Object> getData() {
        return this.contextData;
    }

    @Override
    public String getSecurityDomain() {
        return this.securityDomain;
    }

    @Override
    public SubjectInfo getSubjectInfo() {
        return this.subjectInfo;
    }

    @Override
    public SecurityAuditManager getAuditManager() {
        return AuditManager.getAuditContext(this.securityDomain);
    }

    @Override
    public MappingManager getMappingManager() {
        return new JBossMappingManager(this.securityDomain);
    }

    @Override
    public RunAs getRunAs() {
        return this.configuredRunAs;
    }

    @Override
    public void setRunAs(RunAs runAs) {
        this.configuredRunAs = runAs;
    }

    @Override
    public SecurityContextUtil getUtil() {
        return SecurityContextFactory.createUtil();
    }

    @Override
    public void setSubjectInfo(SubjectInfo si) {
        this.subjectInfo = si;
    }

    public void setRoles(Group roles, boolean replace) {
        Group mergedRoles = roles;
        if (!replace) {
            mergedRoles = this.mergeGroups((Group)this.contextData.get("Roles"), roles);
        }
        this.contextData.put("Roles", mergedRoles);
    }

    private Group mergeGroups(Group a, Group b) {
        Group newGroup = b;
        if (a != null) {
            Enumeration en = a.members();
            while (en.hasMoreElements()) {
                newGroup.addMember((Principal)en.nextElement());
            }
        }
        return newGroup;
    }

    protected Object clone() throws CloneNotSupportedException {
        JBossSecurityContext jsc = (JBossSecurityContext)super.clone();
        if (jsc != null) {
            jsc.contextData = (Map)((HashMap)this.contextData).clone();
        }
        return super.clone();
    }
}

