/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.deployers;

import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.security.JaccPolicyMBean;
import org.jboss.logging.Logger;
import org.jboss.metadata.WebMetaData;
import org.jboss.web.WebApplication;
import org.jboss.web.deployers.AbstractWarDeployer;
import org.jboss.web.deployers.AbstractWarDeployment;
import org.jboss.web.deployers.WebModuleMBean;

public class WebModule
implements WebModuleMBean {
    private static Logger log = Logger.getLogger(WebModule.class);
    private DeploymentUnit di;
    private AbstractWarDeployer container;
    private AbstractWarDeployment deployment;
    private JaccPolicyMBean jaccPolicy;

    public WebModule(DeploymentUnit di, AbstractWarDeployer container, AbstractWarDeployment deployment) {
        this.di = di;
        this.container = container;
        this.deployment = deployment;
    }

    public JaccPolicyMBean getJaccPolicy() {
        return this.jaccPolicy;
    }

    public void setJaccPolicy(JaccPolicyMBean jaccPolicy) {
        this.jaccPolicy = jaccPolicy;
    }

    public void create() {
    }

    public void start() throws Exception {
        this.startModule();
    }

    public void stop() throws Exception {
        this.stopModule();
    }

    public void destroy() {
        this.di = null;
        this.container = null;
        this.deployment = null;
    }

    public synchronized void startModule() throws Exception {
        WebMetaData metaData = this.di.getAttachment(WebMetaData.class);
        this.deployment.setJaccPolicy(this.jaccPolicy);
        WebApplication webApp = this.deployment.start(this.di, metaData);
        String warURL = this.di.getName();
        this.container.addDeployedApp(warURL, webApp);
    }

    public synchronized void stopModule() throws DeploymentException {
        String warURL = this.di.getName();
        try {
            WebApplication webApp = this.container.removeDeployedApp(warURL);
            if (this.deployment != null && webApp != null) {
                this.deployment.stop(this.di, webApp);
            } else {
                log.debug("Failed to find deployer/deployment for war: " + warURL);
            }
        }
        catch (Exception e) {
            throw new DeploymentException("Error during stop", e);
        }
    }
}

