/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.jaxrpc.binding;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.transform.Result;
import org.jboss.logging.Logger;
import org.jboss.ws.core.jaxrpc.binding.BindingException;
import org.jboss.ws.core.jaxrpc.binding.BufferedStreamResult;
import org.jboss.ws.core.jaxrpc.binding.SerializationContext;
import org.jboss.ws.core.jaxrpc.binding.SerializerSupport;
import org.jboss.ws.core.utils.DOMWriter;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SOAPElementSerializer
extends SerializerSupport {
    private static final Logger log = Logger.getLogger(SOAPElementSerializer.class);

    public Result serialize(QName xmlName, QName xmlType, Object value, SerializationContext serContext, NamedNodeMap attributes) throws BindingException {
        log.debug("serialize: [xmlName=" + xmlName + ",xmlType=" + xmlType + "]");
        if (value == null) {
            throw new IllegalArgumentException("SOAPElement value cannot be null");
        }
        if (!(value instanceof SOAPElement)) {
            throw new IllegalArgumentException("Value is not a SOAPElement: " + value.getClass().getName());
        }
        String xmlFragment = DOMWriter.printNode((Node)((SOAPElement)value), false);
        return new BufferedStreamResult(xmlFragment);
    }
}

