/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.security.element;

import java.security.cert.X509Certificate;
import org.apache.xml.security.exceptions.Base64DecodingException;
import org.apache.xml.security.utils.Base64;
import org.apache.xml.security.utils.XMLUtils;
import org.jboss.ws.extensions.security.WSSecurityException;
import org.jboss.ws.extensions.security.element.BinarySecurityToken;
import org.jboss.ws.extensions.security.element.Reference;
import org.jboss.ws.extensions.security.element.X509Token;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyIdentifier
extends Reference {
    public static final String SKI_TYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509SubjectKeyIdentifier";
    private Document doc;
    private String value;
    private Element cachedElement;

    public KeyIdentifier(Document doc, BinarySecurityToken token) throws WSSecurityException {
        this.doc = doc;
        this.referenceToken(token);
    }

    public KeyIdentifier(Element element) throws WSSecurityException {
        this.doc = element.getOwnerDocument();
        if (!"KeyIdentifier".equals(element.getLocalName())) {
            throw new WSSecurityException("Invalid message, invalid local name on a KeyIdentifier");
        }
        String valueType = element.getAttribute("ValueType");
        if (valueType == null || valueType.length() == 0) {
            throw new WSSecurityException("Inavliad message, KeyIdentifier element is missing an ValueType");
        }
        if (!SKI_TYPE.equals(valueType)) {
            throw new WSSecurityException("Currently only SubjectKeyIdentifiers are supported, was passed: " + valueType);
        }
        this.value = XMLUtils.getFullTextChildrenFromElement((Element)element);
    }

    public void referenceToken(BinarySecurityToken token) throws WSSecurityException {
        if (!(token instanceof X509Token)) {
            throw new WSSecurityException("KeyIdentifier tried to reference something besides an X509 token");
        }
        X509Token x509 = (X509Token)token;
        X509Certificate cert = x509.getCert();
        byte[] encoded = cert.getExtensionValue("2.5.29.14");
        if (encoded == null) {
            throw new WSSecurityException("Certificate did not contain a subject key identifier!");
        }
        int trunc = encoded.length - 4;
        byte[] identifier = new byte[trunc];
        System.arraycopy(identifier, 4, encoded, 0, trunc);
        this.value = Base64.encode((byte[])identifier);
    }

    public String getValue() {
        return this.value;
    }

    public String getValueType() {
        return SKI_TYPE;
    }

    public Document getDocument() {
        return this.doc;
    }

    public byte[] getIdentifier() throws WSSecurityException {
        if (this.value == null) {
            return null;
        }
        try {
            return Base64.decode((String)this.value);
        }
        catch (Base64DecodingException e) {
            throw new WSSecurityException("Error decoding key identifier", e);
        }
    }

    public Element getElement() {
        if (this.cachedElement != null) {
            return this.cachedElement;
        }
        Element element = this.doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:KeyIdentifier");
        element.setAttribute("ValueType", this.getValueType());
        element.setAttribute("EncodingType", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary");
        this.cachedElement = element;
        return this.cachedElement;
    }
}

