/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.xop.jaxws;

import java.awt.Image;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import javax.xml.bind.annotation.XmlAttachmentRef;
import javax.xml.bind.annotation.XmlMimeType;
import javax.xml.transform.Source;
import org.jboss.ws.core.utils.JavaUtils;
import org.jboss.ws.extensions.xop.jaxws.AttachmentScanResult;

public class ReflectiveAttachmentRefScanner {
    private static List<Class> SUPPORTED_TYPES = new ArrayList<Class>(5);
    private List<Field> scannedFields = new ArrayList<Field>();

    public AttachmentScanResult scan(Class xmlRoot) {
        if (ReflectiveAttachmentRefScanner.isJDKType(xmlRoot)) {
            return null;
        }
        AttachmentScanResult result = null;
        for (Field field : xmlRoot.getDeclaredFields()) {
            String mimeType;
            Class<?> type = field.getType();
            boolean exceptionToTheRule = ReflectiveAttachmentRefScanner.isAttachmentDataType(type);
            if (this.alreadyScanned(field) || !exceptionToTheRule && ReflectiveAttachmentRefScanner.isJDKType(type)) continue;
            if (field.isAnnotationPresent(XmlAttachmentRef.class)) {
                result = new AttachmentScanResult("application/octet-stream", AttachmentScanResult.Type.SWA_REF);
            } else if (field.isAnnotationPresent(XmlMimeType.class)) {
                XmlMimeType mimeTypeDecl = field.getAnnotation(XmlMimeType.class);
                result = new AttachmentScanResult(mimeTypeDecl.value(), AttachmentScanResult.Type.XOP);
            }
            if (null == result && (mimeType = ReflectiveAttachmentRefScanner.scanGetterAnnotation(xmlRoot, field)) != null) {
                result = new AttachmentScanResult(mimeType, AttachmentScanResult.Type.XOP);
            }
            if (!ReflectiveAttachmentRefScanner.isAttachmentDataType(type)) {
                this.scannedFields.add(field);
            }
            if (null != result) continue;
            result = this.scan(type);
        }
        return result;
    }

    private boolean alreadyScanned(Field field) {
        for (Field f : this.scannedFields) {
            if (!f.equals(field)) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.scannedFields.clear();
    }

    private static boolean isAttachmentDataType(Class clazz) {
        for (Class cl : SUPPORTED_TYPES) {
            if (!JavaUtils.isAssignableFrom(cl, clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean isJDKType(Class clazz) {
        return clazz.getPackage() != null ? clazz.getPackage().getName().startsWith("java") : true;
    }

    private static String scanGetterAnnotation(Class owner, Field field) {
        String getterMethodName = "get" + field.getName();
        for (Method method : owner.getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase(getterMethodName) || !method.isAnnotationPresent(XmlMimeType.class)) continue;
            XmlMimeType mimeTypeDecl = method.getAnnotation(XmlMimeType.class);
            return mimeTypeDecl.value();
        }
        return null;
    }

    static {
        SUPPORTED_TYPES.add(String.class);
        SUPPORTED_TYPES.add(byte[].class);
        SUPPORTED_TYPES.add(Image.class);
        SUPPORTED_TYPES.add(Source.class);
        SUPPORTED_TYPES.add(DataHandler.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResultType {
        XOP,
        SWA_REF;

    }
}

